/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaProperty;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlException;
import org.mule.common.metadata.DefaultListMetaDataModel;
import org.mule.common.metadata.DefaultMetaDataField;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.DefaultXmlMetaDataModel;
import org.mule.common.metadata.MetaDataField;
import org.mule.common.metadata.MetaDataFieldFactory;
import org.mule.common.metadata.MetaDataGenerationException;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.MetaDataModelProperty;
import org.mule.common.metadata.SchemaProvider;
import org.mule.common.metadata.XmlConstants;
import org.mule.common.metadata.XmlMetaDataModel;
import org.mule.common.metadata.XmlMetaDataNamespaceManager;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.metadata.property.LabelMetaDataProperty;
import org.mule.common.metadata.property.QNameMetaDataProperty;
import org.mule.common.metadata.property.xml.AttributeMetaDataFieldProperty;
import org.mule.common.metadata.property.xml.SchemaTypeMetaDataProperty;
import org.mule.common.metadata.property.xml.UnboundMetaDataProperty;

public class XmlMetaDataFieldFactory
implements MetaDataFieldFactory {
    private static final Map<QName, DataType> typeMapping = new HashMap<QName, DataType>();
    public static final String TEXT = "text()";
    private SchemaProvider schemas;
    private QName rootElementName;
    private XmlMetaDataNamespaceManager namespaceManager;

    public XmlMetaDataFieldFactory(SchemaProvider schemas, QName rootElementName, XmlMetaDataNamespaceManager namespaceManager) {
        this.schemas = schemas;
        this.rootElementName = rootElementName;
        this.namespaceManager = namespaceManager;
    }

    @Override
    public List<MetaDataField> createFields() {
        ArrayList<MetaDataField> metaDataFields = new ArrayList<MetaDataField>();
        HashMap<SchemaType, XmlMetaDataModel> visitedTypes = new HashMap<SchemaType, XmlMetaDataModel>();
        SchemaType rootType = this.getRootType();
        if (rootType != null) {
            this.loadFields(rootType, metaDataFields, visitedTypes);
        }
        return metaDataFields;
    }

    protected void loadFields(SchemaType type, List<MetaDataField> metaDataFields, Map<SchemaType, XmlMetaDataModel> visitedTypes) {
        SchemaProperty[] properties;
        if (this.hasSimpleContent(type)) {
            DataType dataType = this.getDataType(type, DataType.STRING);
            metaDataFields.add(new DefaultMetaDataField(TEXT, (MetaDataModel)new DefaultSimpleMetaDataModel(dataType), new QNameMetaDataProperty(new QName(TEXT))));
        }
        for (SchemaProperty property : properties = type.getProperties()) {
            XmlMetaDataModel model;
            DefaultSimpleMetaDataModel model2;
            DataType dataType;
            QName name = this.namespaceManager.assignPrefixIfNotPresent(property.getName());
            SchemaType propertyType = property.getType();
            if (property.isAttribute()) {
                dataType = this.getDataType(propertyType, DataType.STRING);
                model2 = new DefaultSimpleMetaDataModel(dataType);
                this.addSchemaType(propertyType, model2);
                metaDataFields.add(new DefaultMetaDataField(this.toLabel(name), (MetaDataModel)model2, new QNameMetaDataProperty(name), new LabelMetaDataProperty(this.toAttributeLabel(name)), new AttributeMetaDataFieldProperty(true)));
                continue;
            }
            if (this.isList(property)) {
                DefaultListMetaDataModel defaultListMetaDataModel;
                if (this.isSimpleType(propertyType)) {
                    dataType = this.getDataType(propertyType, DataType.STRING);
                    defaultListMetaDataModel = new DefaultListMetaDataModel(new DefaultSimpleMetaDataModel(dataType));
                    defaultListMetaDataModel.addProperty(this.getUnboundProperty(property));
                    this.addSchemaType(propertyType, defaultListMetaDataModel);
                    metaDataFields.add(new DefaultMetaDataField(this.toLabel(name), (MetaDataModel)defaultListMetaDataModel, new QNameMetaDataProperty(name)));
                    continue;
                }
                model = this.buildXMLMetaDataModel(visitedTypes, propertyType);
                defaultListMetaDataModel = new DefaultListMetaDataModel(model);
                this.addSchemaType(propertyType, defaultListMetaDataModel);
                defaultListMetaDataModel.addProperty(this.getUnboundProperty(property));
                metaDataFields.add(new DefaultMetaDataField(this.toLabel(name), (MetaDataModel)defaultListMetaDataModel, new QNameMetaDataProperty(name)));
                continue;
            }
            if (this.isSimpleType(propertyType)) {
                dataType = this.getDataType(propertyType, DataType.STRING);
                model2 = new DefaultSimpleMetaDataModel(dataType);
                this.addSchemaType(propertyType, model2);
                metaDataFields.add(new DefaultMetaDataField(this.toLabel(name), (MetaDataModel)model2, new QNameMetaDataProperty(name)));
                continue;
            }
            model = this.buildXMLMetaDataModel(visitedTypes, propertyType);
            this.addSchemaType(propertyType, model);
            metaDataFields.add(new DefaultMetaDataField(this.toLabel(name), (MetaDataModel)model, new QNameMetaDataProperty(name)));
        }
    }

    public SchemaType getRootType() {
        try {
            SchemaGlobalElement rootElement = this.schemas.findRootElement(this.rootElementName);
            if (rootElement != null) {
                return rootElement.getType();
            }
        }
        catch (XmlException e) {
            throw new MetaDataGenerationException(e);
        }
        return null;
    }

    private void addSchemaType(SchemaType type, MetaDataModel metaDataModel) {
        QName typeQName = type.getName();
        if (typeQName != null) {
            metaDataModel.addProperty(new SchemaTypeMetaDataProperty(typeQName));
        }
    }

    private String toAttributeLabel(QName name) {
        return "@" + this.toLabel(name);
    }

    private XmlMetaDataModel buildXMLMetaDataModel(Map<SchemaType, XmlMetaDataModel> visitedTypes, SchemaType propertyType) {
        XmlMetaDataModel model;
        if (visitedTypes.containsKey(propertyType)) {
            model = visitedTypes.get(propertyType);
        } else {
            ArrayList<MetaDataField> fields = new ArrayList<MetaDataField>();
            model = new DefaultXmlMetaDataModel(this.schemas, this.rootElementName, fields, this.namespaceManager, new MetaDataModelProperty[0]);
            visitedTypes.put(propertyType, model);
            this.loadFields(propertyType, fields, visitedTypes);
        }
        return model;
    }

    private String toLabel(QName name) {
        if (this.namespaceManager.isPrefixDeclared(name)) {
            return name.getPrefix() + ":" + name.getLocalPart();
        }
        return name.getLocalPart();
    }

    private boolean hasSimpleContentOnly(SchemaType type) {
        return this.hasSimpleContent(type) && this.isPlainElement(type);
    }

    private boolean hasSimpleContent(SchemaType type) {
        return type.isSimpleType() || type.getContentType() == 2 || type.getContentType() == 4 || type.getComponentType() == 1;
    }

    private boolean isList(SchemaProperty property) {
        BigInteger maxOccurs = property.getMaxOccurs();
        return maxOccurs == null || property.getMaxOccurs().intValue() > 1;
    }

    private UnboundMetaDataProperty getUnboundProperty(SchemaProperty property) {
        BigInteger maxOccurs = property.getMaxOccurs();
        BigInteger minOccurs = property.getMinOccurs();
        int max = maxOccurs == null ? Integer.MAX_VALUE : maxOccurs.intValue();
        int min = minOccurs == null ? 0 : minOccurs.intValue();
        return new UnboundMetaDataProperty(min, max);
    }

    private DataType getDataType(SchemaType type, DataType defaultDataType) {
        SchemaType simpleType = XmlMetaDataFieldFactory.getSimpleBaseType(type);
        do {
            DataType fieldType;
            if ((fieldType = typeMapping.get(simpleType.getName())) == null) continue;
            return fieldType;
        } while ((simpleType = simpleType.getBaseType()) != null);
        return defaultDataType;
    }

    private boolean isSimpleType(SchemaType type) {
        return this.getDataType(type, null) != null && this.hasSimpleContentOnly(type);
    }

    private boolean isPlainElement(SchemaType type) {
        return !(type.getAttributeProperties() != null && type.getAttributeProperties().length != 0 || type.getElementProperties() != null && type.getElementProperties().length != 0);
    }

    private static SchemaType getSimpleBaseType(SchemaType type) {
        SchemaType basic = type;
        while (basic.getBaseType() != null && !basic.isSimpleType()) {
            basic = basic.getBaseType();
        }
        return basic;
    }

    public QName getRootElementName() {
        return this.rootElementName;
    }

    public SchemaProvider getSchemas() {
        return this.schemas;
    }

    static {
        typeMapping.put(XmlConstants.XSD_BYTE, DataType.INTEGER);
        typeMapping.put(XmlConstants.XSD_INT, DataType.INTEGER);
        typeMapping.put(XmlConstants.XSD_INTEGER, DataType.INTEGER);
        typeMapping.put(XmlConstants.XSD_SHORT, DataType.INTEGER);
        typeMapping.put(XmlConstants.XSD_NEGATIVEINTEGER, DataType.INTEGER);
        typeMapping.put(XmlConstants.XSD_NONNEGATIVEINTEGER, DataType.INTEGER);
        typeMapping.put(XmlConstants.XSD_NONPOSITIVEINTEGER, DataType.INTEGER);
        typeMapping.put(XmlConstants.XSD_POSITIVEINTEGER, DataType.INTEGER);
        typeMapping.put(XmlConstants.XSD_UNSIGNEDBYTE, DataType.INTEGER);
        typeMapping.put(XmlConstants.XSD_UNSIGNEDINT, DataType.INTEGER);
        typeMapping.put(XmlConstants.XSD_UNSIGNEDSHORT, DataType.INTEGER);
        typeMapping.put(XmlConstants.XSD_LONG, DataType.LONG);
        typeMapping.put(XmlConstants.XSD_UNSIGNEDLONG, DataType.LONG);
        typeMapping.put(XmlConstants.XSD_FLOAT, DataType.DOUBLE);
        typeMapping.put(XmlConstants.XSD_DOUBLE, DataType.DOUBLE);
        typeMapping.put(XmlConstants.XSD_BOOLEAN, DataType.BOOLEAN);
        typeMapping.put(XmlConstants.XSD_STRING, DataType.STRING);
        typeMapping.put(XmlConstants.XSD_ANY, DataType.STRING);
        typeMapping.put(XmlConstants.XSD_NORMALIZEDSTRING, DataType.STRING);
        typeMapping.put(XmlConstants.XSD_DECIMAL, DataType.DECIMAL);
        typeMapping.put(XmlConstants.XSD_DATE, DataType.DATE);
        typeMapping.put(XmlConstants.XSD_DATETIME, DataType.DATE_TIME);
        typeMapping.put(XmlConstants.XSD_HEXBIN, DataType.BYTE);
        typeMapping.put(XmlConstants.XSD_BASE64, DataType.BYTE);
    }
}

