/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata.parser.json;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mule.common.metadata.parser.json.AbstractType;
import org.mule.common.metadata.parser.json.JSONType;
import org.mule.common.metadata.parser.json.SchemaEnv;
import org.mule.common.metadata.parser.json.SchemaException;

public class JSONArrayType
extends AbstractType {
    private SchemaEnv env;
    private JSONType itemsType;

    public JSONArrayType(SchemaEnv schemaEnv, JSONObject schema) throws SchemaException {
        this.env = schemaEnv;
        this.itemsType = new JSONType.Everything();
        if (schema.has("items")) {
            try {
                this.itemsType = this.env.evaluate(schema.get("items"));
            }
            catch (JSONException e) {
                throw new SchemaException(e);
            }
        }
    }

    public JSONType getItemsType() {
        return this.itemsType;
    }

    @Override
    public boolean contains(Object obj) {
        if (obj == null || !(obj instanceof JSONArray)) {
            return false;
        }
        JSONArray array = (JSONArray)obj;
        for (int i = 0; i < array.length(); ++i) {
            try {
                if (this.itemsType.contains(array.get(i))) continue;
                return false;
            }
            catch (JSONException e) {
                throw new IllegalArgumentException(array.toString());
            }
        }
        return true;
    }

    @Override
    public String explain(Object obj) {
        if (obj == null) {
            return String.format("REJECT: null value", new Object[0]);
        }
        if (!(obj instanceof JSONArray)) {
            return String.format("REJECT: %s is type %s, not a JSONArray", obj.toString(), obj.getClass().getSimpleName());
        }
        JSONArray array = (JSONArray)obj;
        for (int i = 0; i < array.length(); ++i) {
            try {
                if (this.itemsType.contains(array.get(i))) continue;
                return this.itemsType.explain(array.get(i));
            }
            catch (JSONException e) {
                throw new IllegalArgumentException(array.toString());
            }
        }
        return null;
    }

    @Override
    public boolean isJSONPrimitive() {
        return false;
    }

    @Override
    public boolean isJSONArray() {
        return true;
    }

    @Override
    public boolean isJSONObject() {
        return false;
    }

    @Override
    public boolean isJSONPointer() {
        return false;
    }
}

