/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.json.JSONObject;
import org.mule.common.metadata.AbstractMetaDataModel;
import org.mule.common.metadata.DefaultListMetaDataModel;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.DefaultStructuredMetadataModel;
import org.mule.common.metadata.DefaultUnknownMetaDataModel;
import org.mule.common.metadata.JSONSchemaMetaDataFieldFactory;
import org.mule.common.metadata.MetaDataGenerationException;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.metadata.parser.json.JSONArrayType;
import org.mule.common.metadata.parser.json.JSONObjectType;
import org.mule.common.metadata.parser.json.JSONType;
import org.mule.common.metadata.parser.json.JSONTypeUtils;
import org.mule.common.metadata.parser.json.SchemaEnv;
import org.mule.common.metadata.parser.json.SchemaException;

public class JSONSchemaMetadataModelFactory {
    public static final String OBJECT_ELEMENT_NAME = "object";
    public static final String ARRAY_ELEMENT_NAME = "array";
    public static final String TYPE = "type";
    public static final String PROPERTIES = "properties";

    private MetaDataModel buildModel(String jsonSchemaString, URL jsonSchemaURL) {
        try {
            JSONObject jsonSchemaObject = new JSONObject(jsonSchemaString);
            if (jsonSchemaObject.has(TYPE) && jsonSchemaObject.get(TYPE).toString().toLowerCase().equals(ARRAY_ELEMENT_NAME)) {
                JSONArrayType arrayType = new JSONArrayType(new SchemaEnv(jsonSchemaObject, jsonSchemaURL), jsonSchemaObject);
                JSONType itemsType = arrayType.getItemsType();
                if (itemsType.isJSONObject()) {
                    DefaultStructuredMetadataModel model = new DefaultStructuredMetadataModel(DataType.JSON, new JSONSchemaMetaDataFieldFactory((JSONObjectType)itemsType));
                    return new DefaultListMetaDataModel(model);
                }
                if (itemsType.isJSONPrimitive()) {
                    DataType dataType = JSONTypeUtils.getDataType(itemsType);
                    AbstractMetaDataModel model = dataType == DataType.UNKNOWN ? new DefaultUnknownMetaDataModel() : new DefaultSimpleMetaDataModel(dataType);
                    return new DefaultListMetaDataModel(model);
                }
                DefaultUnknownMetaDataModel model = new DefaultUnknownMetaDataModel();
                return new DefaultListMetaDataModel(model);
            }
            if (jsonSchemaObject.has(TYPE) && jsonSchemaObject.get(TYPE).toString().toLowerCase().equals(OBJECT_ELEMENT_NAME) || jsonSchemaObject.has(PROPERTIES)) {
                JSONSchemaMetaDataFieldFactory fieldFactory = new JSONSchemaMetaDataFieldFactory(new JSONObjectType(new SchemaEnv(jsonSchemaObject, jsonSchemaURL), jsonSchemaObject));
                return new DefaultStructuredMetadataModel(DataType.JSON, fieldFactory);
            }
            return new DefaultUnknownMetaDataModel();
        }
        catch (SchemaException e) {
            throw new MetaDataGenerationException(e);
        }
    }

    public MetaDataModel buildModel(String jsonSchemaString) {
        return this.buildModel(jsonSchemaString, null);
    }

    public MetaDataModel buildModel(URL url) throws IOException {
        String jsonSchemaString = IOUtils.toString((InputStream)url.openStream());
        return this.buildModel(jsonSchemaString, url);
    }
}

