/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.mule.common.metadata.AbstractStructuredMetaDataModel;
import org.mule.common.metadata.MetaDataField;
import org.mule.common.metadata.MetaDataModelProperty;
import org.mule.common.metadata.MetaDataModelVisitor;
import org.mule.common.metadata.XmlMetaDataFieldFactory;
import org.mule.common.metadata.XmlMetaDataModel;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.metadata.property.TextBasedExampleMetaDataModelProperty;

public class DefaultXmlMetaDataModel
extends AbstractStructuredMetaDataModel
implements XmlMetaDataModel {
    private List<String> schemas;
    private QName rootElement;
    private Charset encoding;

    @Deprecated
    public DefaultXmlMetaDataModel(List<String> schemas, String rootElement, Charset encoding) {
        this(schemas, new QName(rootElement), encoding, new MetaDataModelProperty[0]);
    }

    public DefaultXmlMetaDataModel(List<String> schemas, QName rootElement, Charset encoding, MetaDataModelProperty ... properties) {
        this(schemas, rootElement, encoding, new XmlMetaDataFieldFactory(schemas, rootElement, encoding).createFields(), properties);
    }

    DefaultXmlMetaDataModel(List<String> schemas, QName rootElement, Charset encoding, List<MetaDataField> fields, MetaDataModelProperty ... properties) {
        super(DataType.XML, fields);
        this.schemas = schemas;
        this.rootElement = rootElement;
        this.encoding = encoding;
        this.addAllProperties(properties);
    }

    @Override
    public QName getRootElement() {
        return this.rootElement;
    }

    @Override
    public List<InputStream> getSchemas() {
        ArrayList<InputStream> result = new ArrayList<InputStream>();
        for (String schema : this.schemas) {
            result.add(new ByteArrayInputStream(schema.getBytes(this.encoding)));
        }
        return result;
    }

    @Override
    public void accept(MetaDataModelVisitor modelVisitor) {
        modelVisitor.visitXmlMetaDataModel(this);
    }

    @Override
    public String getExample() {
        if (this.hasProperty(TextBasedExampleMetaDataModelProperty.class)) {
            return this.getProperty(TextBasedExampleMetaDataModelProperty.class).getExampleContent();
        }
        return null;
    }

    @Override
    public void setExample(String xmlExample) {
        this.addProperty(new TextBasedExampleMetaDataModelProperty(xmlExample));
    }
}

