/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.implv2.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExchangeDependencyUtils {
    public static final Pattern DEPENDENCY_PATH_PATTERN = Pattern.compile("^exchange_modules/|/exchange_modules/");

    private ExchangeDependencyUtils() {
    }

    public static String getExchangeModulePath(String path) {
        Matcher matcher = DEPENDENCY_PATH_PATTERN.matcher(path);
        if (matcher.find()) {
            String matching = matcher.group(0);
            int dependencyIndex = path.lastIndexOf(matching);
            if (dependencyIndex <= 0) {
                return path;
            }
            String rootPath = path.substring(0, path.indexOf(matching));
            String exchangeModulePath = path.substring(dependencyIndex);
            return rootPath + "/" + exchangeModulePath;
        }
        return path;
    }
}

