/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.model;

import amf.apicontract.client.platform.AMFBaseUnitClient;
import amf.apicontract.client.platform.APIConfiguration;
import amf.apicontract.client.platform.model.domain.EndPoint;
import amf.apicontract.client.platform.model.domain.Server;
import amf.apicontract.client.platform.model.domain.api.WebApi;
import amf.core.client.platform.config.RenderOptions;
import amf.core.client.platform.execution.BaseExecutionEnvironment;
import amf.core.client.platform.model.document.BaseUnit;
import amf.core.client.platform.model.document.Document;
import amf.core.internal.remote.Spec;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.mule.amf.impl.model.ParameterImpl;
import org.mule.amf.impl.model.ResourceImpl;
import org.mule.amf.impl.parser.factory.AMFParserWrapper;
import org.mule.amf.impl.util.LazyValue;
import org.mule.apikit.ApiType;
import org.mule.apikit.common.RamlUtils;
import org.mule.apikit.model.ApiSpecification;
import org.mule.apikit.model.ApiVendor;
import org.mule.apikit.model.Resource;
import org.mule.apikit.model.SecurityScheme;
import org.mule.apikit.model.Template;
import org.mule.apikit.model.parameter.Parameter;
import org.mulesoft.common.io.Output;
import org.yaml.builder.JsonOutputBuilder;
import scala.Option;

public class AMFImpl
implements ApiSpecification {
    private final WebApi webApi;
    private final Map<String, Map<String, Resource>> resources;
    private final List<String> references;
    private final ApiVendor apiVendor;
    private final transient LazyValue<Document> consoleModel;
    private final String apiLocation;
    private final AMFParserWrapper parser;

    public AMFImpl(WebApi webApi, List<String> references, ApiVendor vendor, String location, AMFParserWrapper parser) {
        this.webApi = webApi;
        this.parser = parser;
        this.resources = this.buildResources(webApi.endPoints());
        this.references = references;
        this.apiVendor = vendor;
        this.apiLocation = location;
        this.consoleModel = new LazyValue<Document>(parser::parseApi);
    }

    private Map<String, Map<String, Resource>> buildResources(List<EndPoint> endPoints) {
        HashMap<String, Map<String, Resource>> resources = new HashMap<String, Map<String, Resource>>();
        endPoints.forEach(endPoint -> this.addToMap((Map<String, Map<String, Resource>>)resources, (EndPoint)endPoint));
        return resources;
    }

    private void addToMap(Map<String, Map<String, Resource>> resources, EndPoint endPoint) {
        String parentKey = AMFImpl.parentKey(endPoint);
        Map parentMap = resources.computeIfAbsent(parentKey, k -> new LinkedHashMap());
        String childKey = endPoint.relativePath();
        parentMap.put(childKey, new ResourceImpl(this, endPoint, this.parser.getAMFConfiguration()));
    }

    private static String parentKey(EndPoint endPoint) {
        String path = endPoint.path().value();
        String relativePath = endPoint.relativePath();
        return path.substring(0, path.length() - relativePath.length());
    }

    public Resource getResource(String path) {
        return this.getResources().get(path);
    }

    public Map<String, String> getConsolidatedSchemas() {
        return null;
    }

    public Map<String, Object> getCompiledSchemas() {
        return null;
    }

    public String getBaseUri() {
        return this.getServer().map(server -> server.url().value()).orElse(null);
    }

    public String getLocation() {
        return this.apiLocation;
    }

    private Optional<Server> getServer() {
        return this.webApi.servers().stream().findFirst();
    }

    public Map<String, Resource> getResources() {
        return this.resources.getOrDefault("", Collections.emptyMap());
    }

    Map<String, Resource> getResources(Resource resource) {
        String key = resource.getUri();
        return this.resources.getOrDefault(key, Collections.emptyMap());
    }

    public String getVersion() {
        return this.webApi.version().value();
    }

    public Map<String, Parameter> getBaseUriParameters() {
        return this.getServer().map(server -> server.variables().stream().collect(Collectors.toMap(p -> p.name().value(), p -> new ParameterImpl((amf.apicontract.client.platform.model.domain.Parameter)p, this.parser.getAMFConfiguration())))).orElseGet(Collections::emptyMap);
    }

    public List<Map<String, SecurityScheme>> getSecuritySchemes() {
        return null;
    }

    public List<Map<String, Template>> getTraits() {
        return null;
    }

    public String getUri() {
        Option location = this.webApi._internal().location();
        return location.isDefined() ? (String)location.get() : null;
    }

    public String dump(String newBaseUri) {
        String dump = this.renderApi();
        if (newBaseUri != null) {
            dump = RamlUtils.replaceBaseUri((String)dump, (String)newBaseUri);
        }
        return dump;
    }

    public ApiVendor getApiVendor() {
        return this.apiVendor;
    }

    public ApiType getType() {
        return ApiType.AMF;
    }

    private String renderApi() {
        Document document = this.consoleModel.get();
        return this.getRenderClient().render((BaseUnit)document);
    }

    public List<Map<String, String>> getSchemas() {
        return Collections.emptyList();
    }

    public List<String> getAllReferences() {
        return this.references;
    }

    public String dumpAmf() {
        return this.renderApi(this.consoleModel.get());
    }

    public void writeAMFModel(OutputStream outputStream) {
        try (OutputStreamWriter writer = new OutputStreamWriter(outputStream, Charset.forName("UTF-8"));){
            this.renderApi(this.consoleModel.get(), new JsonOutputBuilder((Object)writer, false, Output.outputWriter()));
        }
        catch (IOException e) {
            throw new RuntimeException("Error trying to dump AMF model", e);
        }
    }

    public void updateBaseUri(String baseUri) {
        this.updateBaseUri(baseUri, this.webApi);
        this.updateBaseUri(baseUri, (WebApi)this.consoleModel.get().encodes());
    }

    private void updateBaseUri(String baseUri, WebApi webApi) {
        if (webApi.servers() != null && webApi.servers().size() > 0) {
            Server server = (Server)webApi.servers().get(0);
            server.withUrl(baseUri);
            server.withVariables(Collections.emptyList());
        } else {
            webApi.withServer(baseUri);
        }
    }

    public boolean includesCallbacks() {
        return this.webApi.endPoints().stream().flatMap(endPoint -> endPoint.operations().stream()).anyMatch(operation -> CollectionUtils.isNotEmpty((Collection)operation.callbacks()));
    }

    public String renderApi(Document document) {
        return this.getRenderClient().render((BaseUnit)document, "application/ld+json");
    }

    public AMFBaseUnitClient getRenderClient() {
        RenderOptions renderOptions = new RenderOptions().withoutSourceMaps().withoutPrettyPrint().withCompactUris();
        return APIConfiguration.fromSpec((Spec)this.parser.getSpec()).withExecutionEnvironment((BaseExecutionEnvironment)this.parser.getExecutionEnvironment()).withRenderOptions(renderOptions).baseUnitClient();
    }

    public <W> void renderApi(Document document, JsonOutputBuilder<W> wJsonOutputBuilder) {
        this.getRenderClient().renderGraphToBuilder((BaseUnit)document, wJsonOutputBuilder);
    }
}

