/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.model;

import amf.client.model.domain.AnyShape;
import amf.client.model.domain.ArrayShape;
import amf.client.model.domain.ValidatorAware;
import amf.client.validate.PayloadValidator;
import amf.client.validate.ValidationReport;
import org.mule.amf.impl.exceptions.ParserException;
import org.mule.amf.impl.model.ValidationStrategy;
import org.mule.amf.impl.util.LazyValue;
import org.mule.apikit.ParserUtils;

class YamlParameterValidationStrategy
extends ValidationStrategy {
    private final LazyValue<PayloadValidator> parameterValidator = new LazyValue<PayloadValidator>(() -> (PayloadValidator)this.schema.parameterValidator("application/yaml").orElseThrow(() -> new ParserException("application/yaml validator not found for shape " + this.schema)));

    public YamlParameterValidationStrategy(AnyShape anyShape, boolean schemaNeedsQuotes) {
        super((ValidatorAware)anyShape, schemaNeedsQuotes);
    }

    @Override
    public boolean valueNeedQuotes(String value) {
        return this.schemaNeedsQuotes || value != null && value.startsWith("*");
    }

    @Override
    public boolean needsPreProcess(String value) {
        String trimmedValue = value.trim();
        return this.schema instanceof ArrayShape && !trimmedValue.startsWith("{") && !trimmedValue.startsWith("-");
    }

    @Override
    public ValidationReport validate(String value) {
        return this.parameterValidator.get().syncValidate("application/yaml", value == null ? "null" : value);
    }

    @Override
    public String escapeCharsInValue(String value) {
        return ParserUtils.escapeSpecialCharsInYamlValue((String)value);
    }

    @Override
    public String removeLeadingZeros(String value) {
        return value;
    }
}

