/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.model;

import amf.client.model.StrField;
import amf.client.model.domain.AnyShape;
import amf.client.model.domain.ArrayShape;
import amf.client.model.domain.DataNode;
import amf.client.model.domain.FileShape;
import amf.client.model.domain.NodeShape;
import amf.client.model.domain.PropertyShape;
import amf.client.model.domain.ScalarNode;
import amf.client.model.domain.ScalarShape;
import amf.client.model.domain.Shape;
import amf.client.validate.ValidationReport;
import amf.client.validate.ValidationResult;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.mule.amf.impl.exceptions.UnsupportedSchemaException;
import org.mule.amf.impl.model.ParameterValidationStrategy;
import org.mule.amf.impl.model.ParameterValidationStrategyFactory;
import org.mule.apikit.model.parameter.FileProperties;
import org.mule.apikit.model.parameter.Parameter;
import org.mule.metadata.api.model.MetadataType;

class ParameterImpl
implements Parameter {
    private final ParameterValidationStrategy validationStrategy;
    private AnyShape schema;
    private Set<String> allowedEncoding;
    private boolean required;

    ParameterImpl(amf.client.model.domain.Parameter parameter) {
        this(ParameterImpl.getSchema(parameter), parameter.required().value());
    }

    ParameterImpl(PropertyShape property) {
        this(ParameterImpl.castToAnyShape(property.range()), property.minCount().value() > 0);
    }

    ParameterImpl(PropertyShape property, Set<String> allowedEncoding) {
        this(property);
        this.allowedEncoding = allowedEncoding;
    }

    ParameterImpl(AnyShape anyShape, boolean required) {
        this.schema = anyShape;
        this.required = required;
        this.validationStrategy = ParameterValidationStrategyFactory.getStrategy(anyShape);
    }

    public boolean validate(String value) {
        return this.validatePayload(value).conforms();
    }

    ValidationReport validatePayload(String value) {
        return this.validationStrategy.validate(value);
    }

    static String quote(String payload) {
        return "\"" + payload + "\"";
    }

    private static AnyShape getSchema(amf.client.model.domain.Parameter parameter) {
        Shape shape = parameter.schema();
        return ParameterImpl.castToAnyShape(shape);
    }

    private static AnyShape castToAnyShape(Shape shape) {
        if (shape instanceof AnyShape) {
            return (AnyShape)shape;
        }
        throw new UnsupportedSchemaException();
    }

    public String message(String value) {
        ValidationReport validationReport = this.validatePayload(value);
        if (validationReport.conforms()) {
            return "OK";
        }
        return validationReport.results().stream().findFirst().map(ValidationResult::message).orElse("Error");
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getDefaultValue() {
        DataNode defaultValue = this.schema.defaultValue();
        if (defaultValue instanceof ScalarNode) {
            return ((ScalarNode)defaultValue).value().value();
        }
        return this.schema.defaultValueStr().option().orElse(null);
    }

    public boolean isRepeat() {
        return this.schema instanceof ArrayShape;
    }

    public boolean isArray() {
        return this.schema instanceof ArrayShape;
    }

    public String getDisplayName() {
        return this.schema.displayName().value();
    }

    public String getDescription() {
        return this.schema.description().value();
    }

    public String getExample() {
        return this.schema.examples().stream().filter(example -> example.name().value() == null).map(example -> example.value().value()).findFirst().orElse(null);
    }

    public Map<String, String> getExamples() {
        return this.schema.examples().stream().filter(example -> example.name().value() != null).collect(Collectors.toMap(e -> e.name().value(), e -> e.value().value()));
    }

    public Object getInstance() {
        throw new UnsupportedOperationException();
    }

    public MetadataType getMetadata() {
        throw new UnsupportedOperationException();
    }

    public boolean isScalar() {
        return this.schema instanceof ScalarShape;
    }

    public boolean isFacetArray(String facet) {
        if (this.schema instanceof NodeShape) {
            for (PropertyShape type : ((NodeShape)this.schema).properties()) {
                if (!facet.equals(type.name().value())) continue;
                return type.range() instanceof ArrayShape;
            }
        }
        return false;
    }

    public String surroundWithQuotesIfNeeded(String value) {
        if (value != null && (value.startsWith("*") || this.isStringArray())) {
            return ParameterImpl.quote(value);
        }
        return value;
    }

    public Optional<FileProperties> getFileProperties() {
        if (this.schema instanceof FileShape) {
            FileShape fileShape = (FileShape)this.schema;
            return Optional.of(new FileProperties(Integer.valueOf(fileShape.minLength().value()), Integer.valueOf(fileShape.maxLength().value()), fileShape.fileTypes().stream().map(StrField::value).collect(Collectors.toSet())));
        }
        if (CollectionUtils.isNotEmpty(this.allowedEncoding)) {
            return Optional.of(new FileProperties(Integer.valueOf(0), Integer.valueOf(0), this.allowedEncoding));
        }
        return Optional.empty();
    }

    private boolean isStringArray() {
        if (!(this.schema instanceof ArrayShape)) {
            return false;
        }
        Shape items = ((ArrayShape)this.schema).items();
        if (!(items instanceof ScalarShape)) {
            return false;
        }
        return ((ScalarShape)items).dataType().value().equals("http://www.w3.org/2001/XMLSchema#string");
    }
}

