/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.model;

import amf.client.model.domain.AnyShape;
import amf.client.validate.PayloadValidator;
import amf.client.validate.ValidationReport;
import org.mule.amf.impl.exceptions.ParserException;
import org.mule.amf.impl.model.ParameterImpl;
import org.mule.amf.impl.model.ParameterValidationStrategy;
import org.mule.amf.impl.util.LazyValue;

class JsonParameterValidationStrategy
implements ParameterValidationStrategy {
    private final boolean needsQuotes;
    private AnyShape anyShape;
    private final LazyValue<PayloadValidator> jsonValidator = new LazyValue<PayloadValidator>(() -> (PayloadValidator)this.anyShape.payloadValidator("application/json").orElseThrow(() -> new ParserException("application/json validator not found for shape " + this.anyShape)));
    private final LazyValue<ValidationReport> nullValidationReport = new LazyValue<ValidationReport>(() -> {
        PayloadValidator yamlPayloadValidator = (PayloadValidator)this.anyShape.payloadValidator("application/yaml").orElseThrow(() -> new ParserException("application/yaml validator not found for shape " + this.anyShape));
        return yamlPayloadValidator.syncValidate("application/yaml", "null");
    });

    JsonParameterValidationStrategy(AnyShape anyShape, boolean needsQuotes) {
        this.anyShape = anyShape;
        this.needsQuotes = needsQuotes;
    }

    @Override
    public ValidationReport validate(String value) {
        if (value == null) {
            return this.nullValidationReport.get();
        }
        return this.jsonValidator.get().syncValidate("application/json", this.needsQuotes ? ParameterImpl.quote(value.replaceAll("\"", "\\\\\"")) : value);
    }
}

