/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.parser.rule;

import amf.client.validate.ValidationResult;
import amf.core.parser.Position;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.apikit.validation.ApiValidationResult;
import org.mule.apikit.validation.Severity;

public class ApiValidationResultImpl
implements ApiValidationResult {
    private static final String ERROR_FORMAT = "%s\n  Location: %s\n  Position: %s";
    private static final String POSITION_FORMAT = "Line %s,  Column %s";
    private ValidationResult validationResult;
    private List<String> severities;

    public ApiValidationResultImpl(ValidationResult validationResult) {
        this.validationResult = validationResult;
        this.severities = Arrays.stream(Severity.values()).map(Enum::name).collect(Collectors.toList());
    }

    public String getMessage() {
        return ApiValidationResultImpl.buildErrorMessage(this.validationResult.message(), this.validationResult.location().orElse(""), this.validationResult.position().start());
    }

    public Optional<Integer> getLine() {
        return Optional.empty();
    }

    public String getPath() {
        throw new UnsupportedOperationException();
    }

    public Severity getSeverity() {
        return !this.severities.contains(this.validationResult.level()) ? Severity.ERROR : Severity.fromString((String)this.validationResult.level());
    }

    private static String buildErrorMessage(String message, String location, Position startPosition) {
        return String.format(ERROR_FORMAT, message, URLDecoder.decode(location), ApiValidationResultImpl.getPositionMessage(startPosition));
    }

    private static String getPositionMessage(Position startPosition) {
        return String.format(POSITION_FORMAT, startPosition.line(), startPosition.column());
    }

    public String toString() {
        return this.getMessage();
    }
}

