/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.model;

import amf.client.model.document.BaseUnit;
import amf.client.model.document.Document;
import amf.client.model.domain.DomainElement;
import amf.client.model.domain.EndPoint;
import amf.client.model.domain.Server;
import amf.client.model.domain.WebApi;
import amf.client.render.AmfGraphRenderer;
import amf.client.render.Oas20Renderer;
import amf.client.render.Raml08Renderer;
import amf.client.render.Raml10Renderer;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.mule.amf.impl.model.ParameterImpl;
import org.mule.amf.impl.model.ResourceImpl;
import org.mule.apikit.ApiType;
import org.mule.apikit.common.RamlUtils;
import org.mule.apikit.model.ApiSpecification;
import org.mule.apikit.model.ApiVendor;
import org.mule.apikit.model.Resource;
import org.mule.apikit.model.SecurityScheme;
import org.mule.apikit.model.Template;
import org.mule.apikit.model.api.ApiReference;
import org.mule.apikit.model.parameter.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

public class AMFImpl
implements ApiSpecification {
    private static final Logger LOGGER = LoggerFactory.getLogger(AMFImpl.class);
    private final WebApi webApi;
    private final Map<String, Map<String, Resource>> resources;
    private final List<String> references;
    private final ApiVendor apiVendor;
    private final Document consoleModel;
    private final ApiReference apiRef;

    public AMFImpl(WebApi webApi, List<String> references, ApiVendor apiVendor, Document console, ApiReference apiRef) {
        this.webApi = webApi;
        this.resources = this.buildResources(webApi.endPoints());
        this.references = references;
        this.apiVendor = apiVendor;
        this.consoleModel = console;
        this.apiRef = apiRef;
    }

    private Map<String, Map<String, Resource>> buildResources(List<EndPoint> endPoints) {
        HashMap<String, Map<String, Resource>> resources = new HashMap<String, Map<String, Resource>>();
        endPoints.forEach(endPoint -> this.addToMap((Map<String, Map<String, Resource>>)resources, (EndPoint)endPoint));
        return resources;
    }

    private void addToMap(Map<String, Map<String, Resource>> resources, EndPoint endPoint) {
        String parentKey = AMFImpl.parentKey(endPoint);
        Map parentMap = resources.computeIfAbsent(parentKey, k -> new LinkedHashMap());
        String childKey = endPoint.relativePath();
        parentMap.put(childKey, new ResourceImpl(this, endPoint));
    }

    private static String parentKey(EndPoint endPoint) {
        String path = endPoint.path().value();
        String relativePath = endPoint.relativePath();
        return path.substring(0, path.length() - relativePath.length());
    }

    public Resource getResource(String path) {
        return this.getResources().get(path);
    }

    public Map<String, String> getConsolidatedSchemas() {
        return null;
    }

    public Map<String, Object> getCompiledSchemas() {
        return null;
    }

    public String getBaseUri() {
        return this.getServer().map(server -> server.url().value()).orElse(null);
    }

    public String getLocation() {
        return this.apiRef.getLocation();
    }

    private Optional<Server> getServer() {
        return this.webApi.servers().stream().findFirst();
    }

    public Map<String, Resource> getResources() {
        return this.resources.getOrDefault("", Collections.emptyMap());
    }

    Map<String, Resource> getResources(Resource resource) {
        String key = resource.getUri();
        return this.resources.getOrDefault(key, Collections.emptyMap());
    }

    public String getVersion() {
        return this.webApi.version().value();
    }

    public Map<String, Parameter> getBaseUriParameters() {
        return this.getServer().map(server -> server.variables().stream().collect(Collectors.toMap(p -> p.name().value(), ParameterImpl::new))).orElseGet(Collections::emptyMap);
    }

    public List<Map<String, SecurityScheme>> getSecuritySchemes() {
        return null;
    }

    public List<Map<String, Template>> getTraits() {
        return null;
    }

    public String getUri() {
        Option location = this.webApi._internal().location();
        return location.isDefined() ? (String)location.get() : null;
    }

    public String dump(String newBaseUri) {
        String dump = this.renderApi();
        if (newBaseUri != null) {
            dump = RamlUtils.replaceBaseUri((String)dump, (String)newBaseUri);
        }
        return dump;
    }

    public ApiVendor getApiVendor() {
        return this.apiVendor;
    }

    public ApiType getType() {
        return ApiType.AMF;
    }

    private String renderApi() {
        Raml08Renderer renderer;
        switch (this.apiVendor) {
            case RAML_08: {
                renderer = new Raml08Renderer();
                break;
            }
            case OAS_20: {
                renderer = new Oas20Renderer();
                break;
            }
            default: {
                renderer = new Raml10Renderer();
            }
        }
        try {
            return (String)renderer.generateString((BaseUnit)this.consoleModel).get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error(String.format("Error render API '%s' to '%s'", this.apiRef.getLocation(), this.apiVendor.name()), (Throwable)e);
            return "";
        }
    }

    public List<Map<String, String>> getSchemas() {
        return Collections.emptyList();
    }

    public List<String> getAllReferences() {
        return this.references;
    }

    public String dumpAmf() {
        try {
            return (String)new AmfGraphRenderer().generateString((BaseUnit)this.consoleModel).get();
        }
        catch (InterruptedException | ExecutionException e) {
            return e.getMessage();
        }
    }

    public void updateBaseUri(String baseUri) {
        if (this.webApi.servers() != null && this.webApi.servers().size() > 0) {
            Server server = (Server)this.webApi.servers().get(0);
            server.withUrl(baseUri);
            server.withVariables(Collections.emptyList());
        } else {
            this.webApi.withServer(baseUri);
        }
        this.consoleModel.withEncodes((DomainElement)this.webApi);
    }
}

