/*
 * Decompiled with CFR 0.152.
 */
package org.mule.parser.service.strategy;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.mule.apikit.model.ApiSpecification;
import org.mule.apikit.model.api.ApiReference;
import org.mule.parser.service.references.ReferencesResolver;
import org.mule.parser.service.result.DefaultParsingIssue;
import org.mule.parser.service.result.ParseResult;
import org.mule.parser.service.result.ParsingIssue;
import org.mule.parser.service.strategy.AMFParsingStrategy;
import org.mule.parser.service.strategy.ParsingStrategy;
import org.mule.parser.service.strategy.RamlParsingStrategy;

public class WithFallbackParsingStrategy
implements ParsingStrategy {
    private static final AMFParsingStrategy AMF_DELEGATE = new AMFParsingStrategy();
    private ScheduledExecutorService executor;

    @Override
    public ParseResult parse(ApiReference ref) {
        ParseResult amfResult = AMF_DELEGATE.parse(ref);
        if (amfResult.success()) {
            return amfResult;
        }
        ReferencesResolver referencesResolver = new ReferencesResolver(amfResult);
        if (this.executor != null) {
            referencesResolver.setExecutor(this.executor);
        }
        ParseResult ramlResult = new RamlParsingStrategy(referencesResolver).parse(ref);
        return new FallbackParseResult(ramlResult);
    }

    @Override
    public void setExecutor(ScheduledExecutorService executor) {
        this.executor = executor;
        AMF_DELEGATE.setExecutor(executor);
    }

    public class FallbackParseResult
    implements ParseResult {
        private final ParseResult delegate;

        FallbackParseResult(ParseResult delegate) {
            this.delegate = delegate;
        }

        @Override
        public ApiSpecification get() {
            return this.delegate.get();
        }

        @Override
        public boolean success() {
            return this.delegate.success();
        }

        @Override
        public List<ParsingIssue> getErrors() {
            return this.delegate.getErrors();
        }

        @Override
        public List<ParsingIssue> getWarnings() {
            return ImmutableList.builder().add((Object)new DefaultParsingIssue("AMF parsing failed, fallback into RAML parser")).addAll(this.delegate.getWarnings()).build();
        }
    }
}

