/*
 * Decompiled with CFR 0.152.
 */
package org.mule.parser.service.references;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.mule.apikit.model.api.ApiReference;
import org.mule.parser.service.result.ParseResult;
import org.mule.parser.service.strategy.AMFParsingStrategy;

public class ReferencesResolver {
    private ParseResult amfParseResult;
    private static final AMFParsingStrategy amfParsingStrategy = new AMFParsingStrategy(false);

    public ReferencesResolver() {
    }

    public ReferencesResolver(ParseResult amfParseResult) {
        this.amfParseResult = amfParseResult;
    }

    public List<String> getReferences(ApiReference reference) {
        if (this.amfParseResult != null) {
            return this.getReferences(this.amfParseResult);
        }
        return this.getReferences(amfParsingStrategy.parse(reference));
    }

    private List<String> getReferences(ParseResult amfParseResult) {
        return amfParseResult.get() != null ? amfParseResult.get().getAllReferences() : Collections.emptyList();
    }

    public void setExecutor(ScheduledExecutorService executor) {
        amfParsingStrategy.setExecutor(executor);
    }
}

