/*
 * Decompiled with CFR 0.152.
 */
package org.mule.parser.service.strategy;

import java.util.Collections;
import java.util.List;
import org.mule.apikit.ApiParser;
import org.mule.apikit.implv1.ParserWrapperV1;
import org.mule.apikit.implv2.ParserWrapperV2;
import org.mule.apikit.loader.ResourceLoader;
import org.mule.apikit.model.ApiVendor;
import org.mule.apikit.model.api.ApiReference;
import org.mule.apikit.validation.ApiValidationReport;
import org.mule.parser.service.references.ReferencesResolver;
import org.mule.parser.service.result.DefaultParseResult;
import org.mule.parser.service.result.ExceptionParseResult;
import org.mule.parser.service.result.ParseResult;
import org.mule.parser.service.strategy.ParsingStrategy;
import org.mule.parser.service.strategy.ValidationReportHelper;

public class RamlParsingStrategy
implements ParsingStrategy {
    private ReferencesResolver referencesResolver;

    public RamlParsingStrategy() {
        this.referencesResolver = new ReferencesResolver();
    }

    public RamlParsingStrategy(ReferencesResolver referencesResolver) {
        this.referencesResolver = referencesResolver;
    }

    @Override
    public ParseResult parse(ApiReference ref) {
        try {
            ApiParser parser = this.create(ref);
            ApiValidationReport report = parser.validate();
            return new DefaultParseResult(report.conforms() ? parser.parse() : null, ValidationReportHelper.errors(report), ValidationReportHelper.warnings(report));
        }
        catch (Exception e) {
            return new ExceptionParseResult(e);
        }
    }

    public ApiParser create(ApiReference ref) {
        String path = ref.getLocation();
        ResourceLoader apiLoader = ref.getResourceLoader().orElse(null);
        List<String> references = this.referencesResolver.getReferences(ref);
        if (ApiVendor.RAML_08.equals((Object)ref.getVendor())) {
            return this.createParserV1(path, apiLoader, references);
        }
        return this.createRamlV2(path, apiLoader, references);
    }

    private ParserWrapperV1 createParserV1(String path, ResourceLoader loader, List<String> refs) {
        return loader != null ? new ParserWrapperV1(path, Collections.singletonList(arg_0 -> ((ResourceLoader)loader).getResourceAsStream(arg_0)), refs) : new ParserWrapperV1(path, refs);
    }

    private ParserWrapperV2 createRamlV2(String path, ResourceLoader loader, List<String> refs) {
        return loader != null ? new ParserWrapperV2(path, Collections.singletonList(arg_0 -> ((ResourceLoader)loader).getResourceAsStream(arg_0)), refs) : new ParserWrapperV2(path, refs);
    }
}

