/*
 * Decompiled with CFR 0.152.
 */
package org.mule.parser.service.strategy;

import java.util.Collections;
import java.util.concurrent.ExecutionException;
import org.mule.amf.impl.AMFParser;
import org.mule.apikit.model.api.ApiReference;
import org.mule.apikit.validation.ApiValidationReport;
import org.mule.parser.service.result.DefaultParseResult;
import org.mule.parser.service.result.ExceptionParseResult;
import org.mule.parser.service.result.ParseResult;
import org.mule.parser.service.strategy.ParsingStrategy;
import org.mule.parser.service.strategy.ValidationReportHelper;

public class AMFParsingStrategy
implements ParsingStrategy {
    private final boolean validate;

    public AMFParsingStrategy() {
        this(true);
    }

    public AMFParsingStrategy(boolean validate) {
        this.validate = validate;
    }

    @Override
    public ParseResult parse(ApiReference ref) {
        try {
            AMFParser parser = this.create(ref);
            if (!this.validate) {
                return new DefaultParseResult(parser.parse(), Collections.emptyList(), Collections.emptyList());
            }
            ApiValidationReport report = parser.validate();
            return new DefaultParseResult(parser.parse(), ValidationReportHelper.errors(report), ValidationReportHelper.warnings(report));
        }
        catch (Exception e) {
            return new ExceptionParseResult(e);
        }
    }

    private AMFParser create(ApiReference ref) {
        try {
            return new AMFParser(ref, false);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

