/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;

public abstract class AbstractTransportFactory {
    protected Bus bus;
    private List<String> transportIds;

    public AbstractTransportFactory() {
    }

    public AbstractTransportFactory(List<String> ids) {
        this.transportIds = ids;
    }

    public AbstractTransportFactory(List<String> ids, Bus b) {
        this.transportIds = ids;
        this.bus = b;
        this.register();
    }

    public Bus getBus() {
        return this.bus;
    }

    public void setBus(Bus b) {
        this.unregister();
        this.bus = b;
        this.register();
    }

    public final List<String> getTransportIds() {
        return this.transportIds;
    }

    public void setTransportIds(List<String> transportIds) {
        this.unregister();
        this.transportIds = transportIds;
        this.register();
    }

    public Set<String> getUriPrefixes() {
        return CastUtils.cast(Collections.EMPTY_SET);
    }

    public final void register() {
        ConduitInitiatorManager cim;
        DestinationFactoryManager dfm;
        if (null == this.bus) {
            return;
        }
        if (this instanceof DestinationFactory && null != (dfm = this.bus.getExtension(DestinationFactoryManager.class)) && this.getTransportIds() != null) {
            for (String ns : this.getTransportIds()) {
                dfm.registerDestinationFactory(ns, (DestinationFactory)((Object)this));
            }
        }
        if (this instanceof ConduitInitiator && (cim = this.bus.getExtension(ConduitInitiatorManager.class)) != null && this.getTransportIds() != null) {
            for (String ns : this.getTransportIds()) {
                cim.registerConduitInitiator(ns, (ConduitInitiator)((Object)this));
            }
        }
    }

    public final void unregister() {
        ConduitInitiatorManager cim;
        DestinationFactoryManager dfm;
        if (null == this.bus) {
            return;
        }
        if (this instanceof DestinationFactory && null != (dfm = this.bus.getExtension(DestinationFactoryManager.class)) && this.getTransportIds() != null) {
            for (String ns : this.getTransportIds()) {
                try {
                    if (dfm.getDestinationFactory(ns) != this) continue;
                    dfm.deregisterDestinationFactory(ns);
                }
                catch (BusException busException) {}
            }
        }
        if (this instanceof ConduitInitiator && (cim = this.bus.getExtension(ConduitInitiatorManager.class)) != null && this.getTransportIds() != null) {
            for (String ns : this.getTransportIds()) {
                try {
                    if (cim.getConduitInitiator(ns) != this) continue;
                    cim.deregisterConduitInitiator(ns);
                }
                catch (BusException busException) {}
            }
        }
    }
}

