/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.core;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.core.buffer.ArrayBufferInput;
import org.msgpack.core.buffer.ChannelBufferInput;
import org.msgpack.core.buffer.ChannelBufferOutput;
import org.msgpack.core.buffer.InputStreamBufferInput;
import org.msgpack.core.buffer.MessageBufferInput;
import org.msgpack.core.buffer.MessageBufferOutput;
import org.msgpack.core.buffer.OutputStreamBufferOutput;

public class MessagePack {
    public static final Charset UTF8 = Charset.forName("UTF-8");

    private MessagePack() {
    }

    public static MessagePacker newDefaultPacker(MessageBufferOutput messageBufferOutput) {
        return new PackerConfig().newPacker(messageBufferOutput);
    }

    public static MessagePacker newDefaultPacker(OutputStream outputStream) {
        return new PackerConfig().newPacker(outputStream);
    }

    public static MessagePacker newDefaultPacker(WritableByteChannel writableByteChannel) {
        return new PackerConfig().newPacker(writableByteChannel);
    }

    public static MessageBufferPacker newDefaultBufferPacker() {
        return new PackerConfig().newBufferPacker();
    }

    public static MessageUnpacker newDefaultUnpacker(MessageBufferInput messageBufferInput) {
        return new UnpackerConfig().newUnpacker(messageBufferInput);
    }

    public static MessageUnpacker newDefaultUnpacker(InputStream inputStream) {
        return new UnpackerConfig().newUnpacker(inputStream);
    }

    public static MessageUnpacker newDefaultUnpacker(ReadableByteChannel readableByteChannel) {
        return new UnpackerConfig().newUnpacker(readableByteChannel);
    }

    public static MessageUnpacker newDefaultUnpacker(byte[] byArray) {
        return new UnpackerConfig().newUnpacker(byArray);
    }

    public static MessageUnpacker newDefaultUnpacker(byte[] byArray, int n, int n2) {
        return new UnpackerConfig().newUnpacker(byArray, n, n2);
    }

    public static class UnpackerConfig {
        public boolean allowReadingStringAsBinary = true;
        public boolean allowReadingBinaryAsString = true;
        public CodingErrorAction actionOnMalformedString = CodingErrorAction.REPLACE;
        public CodingErrorAction actionOnUnmappableString = CodingErrorAction.REPLACE;
        public int stringSizeLimit = Integer.MAX_VALUE;
        public int stringDecoderBufferSize = 8192;

        public MessageUnpacker newUnpacker(MessageBufferInput messageBufferInput) {
            return new MessageUnpacker(messageBufferInput, this);
        }

        public MessageUnpacker newUnpacker(InputStream inputStream) {
            return this.newUnpacker(new InputStreamBufferInput(inputStream));
        }

        public MessageUnpacker newUnpacker(ReadableByteChannel readableByteChannel) {
            return this.newUnpacker(new ChannelBufferInput(readableByteChannel));
        }

        public MessageUnpacker newUnpacker(byte[] byArray) {
            return this.newUnpacker(new ArrayBufferInput(byArray));
        }

        public MessageUnpacker newUnpacker(byte[] byArray, int n, int n2) {
            return this.newUnpacker(new ArrayBufferInput(byArray, n, n2));
        }
    }

    public static class PackerConfig {
        public int smallStringOptimizationThreshold = 512;
        public int bufferFlushThreshold = 8192;

        public MessagePacker newPacker(MessageBufferOutput messageBufferOutput) {
            return new MessagePacker(messageBufferOutput, this);
        }

        public MessagePacker newPacker(OutputStream outputStream) {
            return this.newPacker(new OutputStreamBufferOutput(outputStream));
        }

        public MessagePacker newPacker(WritableByteChannel writableByteChannel) {
            return this.newPacker(new ChannelBufferOutput(writableByteChannel));
        }

        public MessageBufferPacker newBufferPacker() {
            return new MessageBufferPacker(this);
        }
    }

    public static final class Code {
        public static final byte POSFIXINT_MASK = -128;
        public static final byte FIXMAP_PREFIX = -128;
        public static final byte FIXARRAY_PREFIX = -112;
        public static final byte FIXSTR_PREFIX = -96;
        public static final byte NIL = -64;
        public static final byte NEVER_USED = -63;
        public static final byte FALSE = -62;
        public static final byte TRUE = -61;
        public static final byte BIN8 = -60;
        public static final byte BIN16 = -59;
        public static final byte BIN32 = -58;
        public static final byte EXT8 = -57;
        public static final byte EXT16 = -56;
        public static final byte EXT32 = -55;
        public static final byte FLOAT32 = -54;
        public static final byte FLOAT64 = -53;
        public static final byte UINT8 = -52;
        public static final byte UINT16 = -51;
        public static final byte UINT32 = -50;
        public static final byte UINT64 = -49;
        public static final byte INT8 = -48;
        public static final byte INT16 = -47;
        public static final byte INT32 = -46;
        public static final byte INT64 = -45;
        public static final byte FIXEXT1 = -44;
        public static final byte FIXEXT2 = -43;
        public static final byte FIXEXT4 = -42;
        public static final byte FIXEXT8 = -41;
        public static final byte FIXEXT16 = -40;
        public static final byte STR8 = -39;
        public static final byte STR16 = -38;
        public static final byte STR32 = -37;
        public static final byte ARRAY16 = -36;
        public static final byte ARRAY32 = -35;
        public static final byte MAP16 = -34;
        public static final byte MAP32 = -33;
        public static final byte NEGFIXINT_PREFIX = -32;

        public static final boolean isFixInt(byte by) {
            int n = by & 0xFF;
            return n <= 127 || n >= 224;
        }

        public static final boolean isPosFixInt(byte by) {
            return (by & 0xFFFFFF80) == 0;
        }

        public static final boolean isNegFixInt(byte by) {
            return (by & 0xFFFFFFE0) == -32;
        }

        public static final boolean isFixStr(byte by) {
            return (by & 0xFFFFFFE0) == -96;
        }

        public static final boolean isFixedArray(byte by) {
            return (by & 0xFFFFFFF0) == -112;
        }

        public static final boolean isFixedMap(byte by) {
            return (by & 0xFFFFFFF0) == -128;
        }

        public static final boolean isFixedRaw(byte by) {
            return (by & 0xFFFFFFE0) == -96;
        }
    }
}

