/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.core.buffer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.msgpack.core.Preconditions;
import org.msgpack.core.buffer.MessageBuffer;

public class MessageBufferU
extends MessageBuffer {
    public MessageBufferU(ByteBuffer byteBuffer) {
        super(null, 0L, byteBuffer.capacity(), byteBuffer.order(ByteOrder.BIG_ENDIAN));
        Preconditions.checkNotNull(this.reference);
    }

    MessageBufferU(byte[] byArray) {
        this(ByteBuffer.wrap(byArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageBufferU slice(int n, int n2) {
        if (n == 0 && n2 == this.size()) {
            return this;
        }
        Preconditions.checkArgument(n + n2 <= this.size());
        try {
            this.reference.position(n);
            this.reference.limit(n + n2);
            MessageBufferU messageBufferU = new MessageBufferU(this.reference.slice());
            return messageBufferU;
        }
        finally {
            this.resetBufferPosition();
        }
    }

    private void resetBufferPosition() {
        this.reference.position(0);
        this.reference.limit(this.size);
    }

    @Override
    public byte getByte(int n) {
        return this.reference.get(n);
    }

    @Override
    public boolean getBoolean(int n) {
        return this.reference.get(n) != 0;
    }

    @Override
    public short getShort(int n) {
        return this.reference.getShort(n);
    }

    @Override
    public int getInt(int n) {
        return this.reference.getInt(n);
    }

    @Override
    public float getFloat(int n) {
        return this.reference.getFloat(n);
    }

    @Override
    public long getLong(int n) {
        return this.reference.getLong(n);
    }

    @Override
    public double getDouble(int n) {
        return this.reference.getDouble(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getBytes(int n, int n2, ByteBuffer byteBuffer) {
        try {
            this.reference.position(n);
            this.reference.limit(n + n2);
            byteBuffer.put(this.reference);
        }
        finally {
            this.resetBufferPosition();
        }
    }

    @Override
    public void putByte(int n, byte by) {
        this.reference.put(n, by);
    }

    @Override
    public void putBoolean(int n, boolean bl) {
        this.reference.put(n, bl ? (byte)1 : 0);
    }

    @Override
    public void putShort(int n, short s) {
        this.reference.putShort(n, s);
    }

    @Override
    public void putInt(int n, int n2) {
        this.reference.putInt(n, n2);
    }

    @Override
    public void putFloat(int n, float f) {
        this.reference.putFloat(n, f);
    }

    @Override
    public void putLong(int n, long l) {
        this.reference.putLong(n, l);
    }

    @Override
    public void putDouble(int n, double d) {
        this.reference.putDouble(n, d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer toByteBuffer(int n, int n2) {
        try {
            this.reference.position(n);
            this.reference.limit(n + n2);
            ByteBuffer byteBuffer = this.reference.slice();
            return byteBuffer;
        }
        finally {
            this.resetBufferPosition();
        }
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return this.toByteBuffer(0, this.size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getBytes(int n, byte[] byArray, int n2, int n3) {
        try {
            this.reference.position(n);
            this.reference.get(byArray, n2, n3);
        }
        finally {
            this.resetBufferPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putByteBuffer(int n, ByteBuffer byteBuffer, int n2) {
        assert (n2 <= byteBuffer.remaining());
        if (byteBuffer.hasArray()) {
            this.putBytes(n, byteBuffer.array(), byteBuffer.position() + byteBuffer.arrayOffset(), n2);
            byteBuffer.position(byteBuffer.position() + n2);
        } else {
            int n3 = byteBuffer.limit();
            try {
                byteBuffer.limit(byteBuffer.position() + n2);
                this.reference.position(n);
                this.reference.put(byteBuffer);
            }
            finally {
                byteBuffer.limit(n3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putBytes(int n, byte[] byArray, int n2, int n3) {
        try {
            this.reference.position(n);
            this.reference.put(byArray, n2, n3);
        }
        finally {
            this.resetBufferPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyTo(int n, MessageBuffer messageBuffer, int n2, int n3) {
        try {
            this.reference.position(n);
            messageBuffer.putByteBuffer(n2, this.reference, n3);
        }
        finally {
            this.resetBufferPosition();
        }
    }

    @Override
    public byte[] toByteArray() {
        byte[] byArray = new byte[this.size()];
        this.getBytes(0, byArray, 0, byArray.length);
        return byArray;
    }
}

