/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.core.buffer;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import org.msgpack.core.Preconditions;
import org.msgpack.core.buffer.ChannelBufferInput;
import org.msgpack.core.buffer.MessageBuffer;
import org.msgpack.core.buffer.MessageBufferInput;

public class InputStreamBufferInput
implements MessageBufferInput {
    private InputStream in;
    private final int bufferSize;
    private boolean reachedEOF = false;

    public static MessageBufferInput newBufferInput(InputStream inputStream) {
        FileChannel fileChannel;
        Preconditions.checkNotNull(inputStream, "InputStream is null");
        if (inputStream instanceof FileInputStream && (fileChannel = ((FileInputStream)inputStream).getChannel()) != null) {
            return new ChannelBufferInput(fileChannel);
        }
        return new InputStreamBufferInput(inputStream);
    }

    public InputStreamBufferInput(InputStream inputStream) {
        this(inputStream, 8192);
    }

    public InputStreamBufferInput(InputStream inputStream, int n) {
        this.in = Preconditions.checkNotNull(inputStream, "input is null");
        this.bufferSize = n;
    }

    public InputStream reset(InputStream inputStream) throws IOException {
        InputStream inputStream2 = this.in;
        this.in = inputStream;
        this.reachedEOF = false;
        return inputStream2;
    }

    @Override
    public MessageBuffer next() throws IOException {
        int n;
        int n2;
        if (this.reachedEOF) {
            return null;
        }
        byte[] byArray = null;
        for (n = 0; !this.reachedEOF && n < this.bufferSize; n += n2) {
            if (byArray == null) {
                byArray = new byte[this.bufferSize];
            }
            if ((n2 = this.in.read(byArray, n, this.bufferSize - n)) != -1) continue;
            this.reachedEOF = true;
            break;
        }
        return byArray == null ? null : MessageBuffer.wrap(byArray).slice(0, n);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

