/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.core.buffer;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.msgpack.core.Preconditions;
import org.msgpack.core.annotations.Insecure;
import sun.misc.Unsafe;

public class MessageBuffer {
    static final Unsafe unsafe;
    static final Constructor byteBufferConstructor;
    static final Class<?> directByteBufferClass;
    static final DirectBufferConstructorType directBufferConstructorType;
    static final Method memoryBlockWrapFromJni;
    static final int ARRAY_BYTE_BASE_OFFSET;
    static final int ARRAY_BYTE_INDEX_SCALE;
    private static final Class<?> msgBufferClass;
    private static final Constructor<?> mbArrConstructor;
    private static final Constructor<?> mbBBConstructor;
    protected final Object base;
    protected final long address;
    protected final int size;
    protected final ByteBuffer reference;

    static MessageBuffer newOffHeapBuffer(int n) {
        long l = unsafe.allocateMemory(n);
        return new MessageBuffer(l, n);
    }

    public static MessageBuffer newDirectBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
        return MessageBuffer.newMessageBuffer(byteBuffer);
    }

    public static MessageBuffer newBuffer(int n) {
        return MessageBuffer.newMessageBuffer(new byte[n]);
    }

    public static MessageBuffer wrap(byte[] byArray) {
        return MessageBuffer.newMessageBuffer(byArray);
    }

    public static MessageBuffer wrap(ByteBuffer byteBuffer) {
        return MessageBuffer.newMessageBuffer(byteBuffer).slice(byteBuffer.position(), byteBuffer.remaining());
    }

    private static MessageBuffer newMessageBuffer(ByteBuffer byteBuffer) {
        Preconditions.checkNotNull(byteBuffer);
        try {
            return (MessageBuffer)mbBBConstructor.newInstance(byteBuffer);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static MessageBuffer newMessageBuffer(byte[] byArray) {
        Preconditions.checkNotNull(byArray);
        try {
            return (MessageBuffer)mbArrConstructor.newInstance(new Object[]{byArray});
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static void releaseBuffer(MessageBuffer messageBuffer) {
        if (!(messageBuffer.base instanceof byte[])) {
            if (directByteBufferClass.isInstance(messageBuffer.base)) {
                DirectBufferAccess.clean(messageBuffer.base);
            } else {
                unsafe.freeMemory(messageBuffer.address);
            }
        }
    }

    MessageBuffer(long l, int n) {
        this.base = null;
        this.address = l;
        this.size = n;
        this.reference = null;
    }

    MessageBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer.isDirect()) {
            this.base = null;
            this.address = DirectBufferAccess.getAddress(byteBuffer);
            this.size = byteBuffer.capacity();
            this.reference = byteBuffer;
        } else if (byteBuffer.hasArray()) {
            this.base = byteBuffer.array();
            this.address = ARRAY_BYTE_BASE_OFFSET;
            this.size = byteBuffer.array().length;
            this.reference = null;
        } else {
            throw new IllegalArgumentException("Only the array-backed ByteBuffer or DirectBuffer are supported");
        }
    }

    MessageBuffer(byte[] byArray) {
        this.base = byArray;
        this.address = ARRAY_BYTE_BASE_OFFSET;
        this.size = byArray.length;
        this.reference = null;
    }

    MessageBuffer(Object object, long l, int n, ByteBuffer byteBuffer) {
        this.base = object;
        this.address = l;
        this.size = n;
        this.reference = byteBuffer;
    }

    public int size() {
        return this.size;
    }

    public MessageBuffer slice(int n, int n2) {
        if (n == 0 && n2 == this.size()) {
            return this;
        }
        Preconditions.checkArgument(n + n2 <= this.size());
        return new MessageBuffer(this.base, this.address + (long)n, n2, this.reference);
    }

    public byte getByte(int n) {
        return unsafe.getByte(this.base, this.address + (long)n);
    }

    public boolean getBoolean(int n) {
        return unsafe.getBoolean(this.base, this.address + (long)n);
    }

    public short getShort(int n) {
        short s = unsafe.getShort(this.base, this.address + (long)n);
        return Short.reverseBytes(s);
    }

    public int getInt(int n) {
        int n2 = unsafe.getInt(this.base, this.address + (long)n);
        return Integer.reverseBytes(n2);
    }

    public float getFloat(int n) {
        return Float.intBitsToFloat(this.getInt(n));
    }

    public long getLong(int n) {
        long l = unsafe.getLong(this.base, this.address + (long)n);
        return Long.reverseBytes(l);
    }

    public double getDouble(int n) {
        return Double.longBitsToDouble(this.getLong(n));
    }

    public void getBytes(int n, byte[] byArray, int n2, int n3) {
        unsafe.copyMemory(this.base, this.address + (long)n, byArray, ARRAY_BYTE_BASE_OFFSET + n2, n3);
    }

    public void getBytes(int n, int n2, ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() > n2) {
            throw new BufferOverflowException();
        }
        ByteBuffer byteBuffer2 = this.toByteBuffer(n, n2);
        byteBuffer.put(byteBuffer2);
    }

    public void putByte(int n, byte by) {
        unsafe.putByte(this.base, this.address + (long)n, by);
    }

    public void putBoolean(int n, boolean bl) {
        unsafe.putBoolean(this.base, this.address + (long)n, bl);
    }

    public void putShort(int n, short s) {
        s = Short.reverseBytes(s);
        unsafe.putShort(this.base, this.address + (long)n, s);
    }

    public void putInt(int n, int n2) {
        n2 = Integer.reverseBytes(n2);
        unsafe.putInt(this.base, this.address + (long)n, n2);
    }

    public void putFloat(int n, float f) {
        this.putInt(n, Float.floatToRawIntBits(f));
    }

    public void putLong(int n, long l) {
        l = Long.reverseBytes(l);
        unsafe.putLong(this.base, this.address + (long)n, l);
    }

    public void putDouble(int n, double d) {
        this.putLong(n, Double.doubleToRawLongBits(d));
    }

    public void putBytes(int n, byte[] byArray, int n2, int n3) {
        unsafe.copyMemory(byArray, ARRAY_BYTE_BASE_OFFSET + n2, this.base, this.address + (long)n, n3);
    }

    public void putByteBuffer(int n, ByteBuffer byteBuffer, int n2) {
        assert (n2 <= byteBuffer.remaining());
        if (byteBuffer.isDirect()) {
            unsafe.copyMemory(null, DirectBufferAccess.getAddress(byteBuffer) + (long)byteBuffer.position(), this.base, this.address + (long)n, n2);
        } else if (byteBuffer.hasArray()) {
            byte[] byArray = byteBuffer.array();
            unsafe.copyMemory(byArray, ARRAY_BYTE_BASE_OFFSET + byteBuffer.position(), this.base, this.address + (long)n, n2);
        } else if (this.base != null) {
            byteBuffer.get((byte[])this.base, n, n2);
        } else {
            for (int i = 0; i < n2; ++i) {
                unsafe.putByte(this.base, this.address + (long)n, byteBuffer.get());
            }
        }
        byteBuffer.position(byteBuffer.position() + n2);
    }

    public ByteBuffer toByteBuffer(int n, int n2) {
        if (this.hasArray()) {
            return ByteBuffer.wrap((byte[])this.base, (int)(this.address - (long)ARRAY_BYTE_BASE_OFFSET + (long)n), n2);
        }
        try {
            ByteBuffer byteBuffer = null;
            switch (directBufferConstructorType) {
                case ARGS_LONG_INT_REF: {
                    byteBuffer = (ByteBuffer)byteBufferConstructor.newInstance(this.address + (long)n, n2, this.reference);
                    break;
                }
                case ARGS_LONG_INT: {
                    byteBuffer = (ByteBuffer)byteBufferConstructor.newInstance(this.address + (long)n, n2);
                    break;
                }
                case ARGS_INT_INT: {
                    byteBuffer = (ByteBuffer)byteBufferConstructor.newInstance((int)this.address + n, n2);
                    break;
                }
                case ARGS_MB_INT_INT: {
                    byteBuffer = (ByteBuffer)byteBufferConstructor.newInstance(memoryBlockWrapFromJni.invoke(null, this.address + (long)n, n2), n2, 0);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value");
                }
            }
            return byteBuffer;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public ByteBuffer toByteBuffer() {
        return this.toByteBuffer(0, this.size());
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.size()];
        unsafe.copyMemory(this.base, this.address, byArray, ARRAY_BYTE_BASE_OFFSET, this.size());
        return byArray;
    }

    @Insecure
    public boolean hasArray() {
        return this.base instanceof byte[];
    }

    @Insecure
    public byte[] getArray() {
        return (byte[])this.base;
    }

    @Insecure
    public Object getBase() {
        return this.base;
    }

    @Insecure
    public long getAddress() {
        return this.address;
    }

    @Insecure
    public int offset() {
        if (this.hasArray()) {
            return (int)this.address - ARRAY_BYTE_BASE_OFFSET;
        }
        return 0;
    }

    @Insecure
    public ByteBuffer getReference() {
        return this.reference;
    }

    public void copyTo(int n, MessageBuffer messageBuffer, int n2, int n3) {
        unsafe.copyMemory(this.base, this.address + (long)n, messageBuffer.base, messageBuffer.address + (long)n2, n3);
    }

    public String toHexString(int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n; i < n2; ++i) {
            if (i != n) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(String.format("%02x", this.getByte(i)));
        }
        return stringBuilder.toString();
    }

    static {
        try {
            AccessibleObject accessibleObject;
            int n;
            String string = System.getProperty("java.specification.version", "");
            int n2 = string.indexOf(46);
            boolean bl = false;
            if (n2 == -1) {
                bl = false;
            } else {
                try {
                    n = Integer.parseInt(string.substring(0, n2));
                    int n3 = Integer.parseInt(string.substring(n2 + 1));
                    bl = n > 1 || n == 1 && n3 >= 7;
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace(System.err);
                }
            }
            n = System.getProperty("java.runtime.name", "").toLowerCase().contains("android") ? 1 : 0;
            if (n == 0) {
                accessibleObject = Unsafe.class.getDeclaredField("theUnsafe");
                ((Field)accessibleObject).setAccessible(true);
                unsafe = (Unsafe)((Field)accessibleObject).get(null);
            } else {
                accessibleObject = Unsafe.class.getDeclaredConstructor(new Class[0]);
                ((Constructor)accessibleObject).setAccessible(true);
                unsafe = (Unsafe)((Constructor)accessibleObject).newInstance(new Object[0]);
            }
            if (unsafe == null) {
                throw new RuntimeException("Unsafe is unavailable");
            }
            ARRAY_BYTE_BASE_OFFSET = unsafe.arrayBaseOffset(byte[].class);
            ARRAY_BYTE_INDEX_SCALE = unsafe.arrayIndexScale(byte[].class);
            if (ARRAY_BYTE_INDEX_SCALE != 1) {
                throw new IllegalStateException("Byte array index scale must be 1, but is " + ARRAY_BYTE_INDEX_SCALE);
            }
            directByteBufferClass = ClassLoader.getSystemClassLoader().loadClass("java.nio.DirectByteBuffer");
            accessibleObject = null;
            DirectBufferConstructorType directBufferConstructorType = null;
            Method method = null;
            try {
                accessibleObject = directByteBufferClass.getDeclaredConstructor(Long.TYPE, Integer.TYPE, Object.class);
                directBufferConstructorType = DirectBufferConstructorType.ARGS_LONG_INT_REF;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    accessibleObject = directByteBufferClass.getDeclaredConstructor(Long.TYPE, Integer.TYPE);
                    directBufferConstructorType = DirectBufferConstructorType.ARGS_LONG_INT;
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    try {
                        accessibleObject = directByteBufferClass.getDeclaredConstructor(Integer.TYPE, Integer.TYPE);
                        directBufferConstructorType = DirectBufferConstructorType.ARGS_INT_INT;
                    }
                    catch (NoSuchMethodException noSuchMethodException3) {
                        Class<?> clazz = Class.forName("java.nio.MemoryBlock");
                        method = clazz.getDeclaredMethod("wrapFromJni", Integer.TYPE, Long.TYPE);
                        method.setAccessible(true);
                        accessibleObject = directByteBufferClass.getDeclaredConstructor(clazz, Integer.TYPE, Integer.TYPE);
                        directBufferConstructorType = DirectBufferConstructorType.ARGS_MB_INT_INT;
                    }
                }
            }
            byteBufferConstructor = accessibleObject;
            MessageBuffer.directBufferConstructorType = directBufferConstructorType;
            memoryBlockWrapFromJni = method;
            if (byteBufferConstructor == null) {
                throw new RuntimeException("Constructor of DirectByteBuffer is not found");
            }
            byteBufferConstructor.setAccessible(true);
            boolean bl2 = true;
            byte[] byArray = new byte[8];
            unsafe.putLong(byArray, ARRAY_BYTE_BASE_OFFSET, 72623859790382856L);
            switch (byArray[0]) {
                case 1: {
                    bl2 = false;
                    break;
                }
                case 8: {
                    bl2 = true;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            boolean bl3 = Boolean.parseBoolean(System.getProperty("msgpack.universal-buffer", "false"));
            String string2 = !bl3 && n == 0 && bl ? (bl2 ? "org.msgpack.core.buffer.MessageBuffer" : "org.msgpack.core.buffer.MessageBufferBE") : "org.msgpack.core.buffer.MessageBufferU";
            Class<?> clazz = Class.forName(string2);
            msgBufferClass = clazz;
            Constructor<?> constructor = clazz.getDeclaredConstructor(byte[].class);
            constructor.setAccessible(true);
            mbArrConstructor = constructor;
            Constructor<?> constructor2 = clazz.getDeclaredConstructor(ByteBuffer.class);
            constructor2.setAccessible(true);
            mbBBConstructor = constructor2;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            throw new RuntimeException(exception);
        }
    }

    private static class DirectBufferAccess {
        static Method mGetAddress;
        static Method mCleaner;
        static Method mClean;

        private DirectBufferAccess() {
        }

        static long getAddress(Object object) {
            try {
                return (Long)mGetAddress.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
        }

        static void clean(Object object) {
            try {
                Object object2 = mCleaner.invoke(object, new Object[0]);
                mClean.invoke(object2, new Object[0]);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        static {
            try {
                mGetAddress = directByteBufferClass.getDeclaredMethod("address", new Class[0]);
                mGetAddress.setAccessible(true);
                mCleaner = directByteBufferClass.getDeclaredMethod("cleaner", new Class[0]);
                mCleaner.setAccessible(true);
                mClean = mCleaner.getReturnType().getDeclaredMethod("clean", new Class[0]);
                mClean.setAccessible(true);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException(noSuchMethodException);
            }
        }
    }

    static enum DirectBufferConstructorType {
        ARGS_LONG_INT_REF,
        ARGS_LONG_INT,
        ARGS_INT_INT,
        ARGS_MB_INT_INT;

    }
}

