/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.core.value.impl;

import org.msgpack.core.MessageTypeException;
import org.msgpack.core.value.ArrayCursor;
import org.msgpack.core.value.ArrayValue;
import org.msgpack.core.value.BinaryValue;
import org.msgpack.core.value.BooleanValue;
import org.msgpack.core.value.ExtendedValue;
import org.msgpack.core.value.FloatValue;
import org.msgpack.core.value.IntegerValue;
import org.msgpack.core.value.MapCursor;
import org.msgpack.core.value.MapValue;
import org.msgpack.core.value.NilValue;
import org.msgpack.core.value.NumberValue;
import org.msgpack.core.value.RawValue;
import org.msgpack.core.value.StringValue;
import org.msgpack.core.value.Value;
import org.msgpack.core.value.ValueRef;
import org.msgpack.core.value.ValueType;

public abstract class AbstractValueRef
implements ValueRef {
    protected static int NUMBER_TYPE_MASK = 1 << ValueType.INTEGER.ordinal() | 1 << ValueType.FLOAT.ordinal();
    protected static int RAW_TYPE_MASK = 1 << ValueType.STRING.ordinal() | 1 << ValueType.BINARY.ordinal();

    @Override
    public boolean isRef() {
        return true;
    }

    protected <E extends Value> E as(Class<E> clazz, ValueType valueType) {
        return this.as(clazz, 1 << valueType.ordinal());
    }

    protected <E extends Value> E as(Class<E> clazz, int n) {
        if (this.getValueType() == null) {
            throw new MessageTypeException("This value points to nothing");
        }
        if (!this.getValueType().isTypeOf(n)) {
            throw new MessageTypeException(String.format("Expected %s, but %s", new Object[]{clazz.getSimpleName(), this.getValueType()}));
        }
        return (E)((Value)clazz.cast(this));
    }

    @Override
    public NilValue asNil() throws MessageTypeException {
        return this.as(NilValue.class, ValueType.NIL);
    }

    @Override
    public BooleanValue asBoolean() throws MessageTypeException {
        return this.as(BooleanValue.class, ValueType.BOOLEAN);
    }

    @Override
    public NumberValue asNumber() throws MessageTypeException {
        return this.as(NumberValue.class, NUMBER_TYPE_MASK);
    }

    @Override
    public IntegerValue asInteger() throws MessageTypeException {
        return this.as(IntegerValue.class, ValueType.INTEGER);
    }

    @Override
    public FloatValue asFloat() throws MessageTypeException {
        return this.as(FloatValue.class, ValueType.FLOAT);
    }

    @Override
    public BinaryValue asBinary() throws MessageTypeException {
        return this.as(BinaryValue.class, ValueType.BINARY);
    }

    @Override
    public StringValue asString() throws MessageTypeException {
        return this.as(StringValue.class, ValueType.STRING);
    }

    @Override
    public RawValue asRaw() throws MessageTypeException {
        return this.as(RawValue.class, RAW_TYPE_MASK);
    }

    public ArrayValue asArrayValue() throws MessageTypeException {
        return this.as(ArrayValue.class, ValueType.ARRAY);
    }

    public MapValue asMapValue() throws MessageTypeException {
        return this.as(MapValue.class, ValueType.MAP);
    }

    @Override
    public ExtendedValue asExtended() throws MessageTypeException {
        return this.as(ExtendedValue.class, ValueType.EXTENDED);
    }

    @Override
    public ArrayCursor getArrayCursor() throws MessageTypeException {
        throw new MessageTypeException("This value is not an array type");
    }

    @Override
    public MapCursor getMapCursor() throws MessageTypeException {
        throw new MessageTypeException("This value is not a map type");
    }

    @Override
    public boolean isNil() {
        return this.getValueType().isNilType();
    }

    @Override
    public boolean isBoolean() {
        return this.getValueType().isBooleanType();
    }

    @Override
    public boolean isNumber() {
        return this.getValueType().isNumberType();
    }

    @Override
    public boolean isInteger() {
        return this.getValueType().isIntegerType();
    }

    @Override
    public boolean isFloat() {
        return this.getValueType().isFloatType();
    }

    @Override
    public boolean isBinary() {
        return this.getValueType().isBinaryType();
    }

    @Override
    public boolean isString() {
        return this.getValueType().isStringType();
    }

    @Override
    public boolean isRaw() {
        return this.getValueType().isRawType();
    }

    @Override
    public boolean isArray() {
        return this.getValueType().isArrayType();
    }

    @Override
    public boolean isMap() {
        return this.getValueType().isMapType();
    }

    @Override
    public boolean isExtended() {
        return this.getValueType().isExtendedType();
    }
}

