/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.core;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.core.buffer.ArrayBufferInput;
import org.msgpack.core.buffer.ChannelBufferInput;
import org.msgpack.core.buffer.ChannelBufferOutput;
import org.msgpack.core.buffer.InputStreamBufferInput;
import org.msgpack.core.buffer.OutputStreamBufferOutput;

public class MessagePackFactory {
    private final MessagePack.Config config;
    public static final MessagePackFactory DEFAULT = new MessagePackFactory(MessagePack.DEFAULT_CONFIG);

    public MessagePackFactory() {
        this(MessagePack.DEFAULT_CONFIG);
    }

    public MessagePackFactory(MessagePack.Config config) {
        this.config = config;
    }

    public static MessagePacker newDefaultPacker(OutputStream outputStream) {
        return DEFAULT.newPacker(outputStream);
    }

    public static MessagePacker newDefaultPacker(WritableByteChannel writableByteChannel) {
        return DEFAULT.newPacker(writableByteChannel);
    }

    public static MessageUnpacker newDefaultUnpacker(InputStream inputStream) {
        return DEFAULT.newUnpacker(inputStream);
    }

    public static MessageUnpacker newDefaultUnpacker(ReadableByteChannel readableByteChannel) {
        return DEFAULT.newUnpacker(readableByteChannel);
    }

    public static MessageUnpacker newDefaultUnpacker(byte[] byArray) {
        return DEFAULT.newUnpacker(byArray);
    }

    public static MessageUnpacker newDefaultUnpacker(byte[] byArray, int n, int n2) {
        return DEFAULT.newUnpacker(byArray, n, n2);
    }

    public MessagePacker newPacker(OutputStream outputStream) {
        return new MessagePacker(new OutputStreamBufferOutput(outputStream), this.config);
    }

    public MessagePacker newPacker(WritableByteChannel writableByteChannel) {
        return new MessagePacker(new ChannelBufferOutput(writableByteChannel), this.config);
    }

    public MessageUnpacker newUnpacker(InputStream inputStream) {
        return new MessageUnpacker(InputStreamBufferInput.newBufferInput(inputStream), this.config);
    }

    public MessageUnpacker newUnpacker(ReadableByteChannel readableByteChannel) {
        return new MessageUnpacker(new ChannelBufferInput(readableByteChannel), this.config);
    }

    public MessageUnpacker newUnpacker(byte[] byArray) {
        return new MessageUnpacker(new ArrayBufferInput(byArray), this.config);
    }

    public MessageUnpacker newUnpacker(byte[] byArray, int n, int n2) {
        return new MessageUnpacker(new ArrayBufferInput(byArray, n, n2), this.config);
    }
}

