/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.value.impl;

import java.io.IOException;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessageFormatException;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.Cursor;
import org.msgpack.value.Value;
import org.msgpack.value.ValueRef;
import org.msgpack.value.ValueType;
import org.msgpack.value.holder.ValueHolder;

public class CursorImpl
implements Cursor {
    private final MessageUnpacker unpacker;
    private MessageFormat currentFormat;
    private ValueHolder valueHolder;

    public CursorImpl(MessageUnpacker messageUnpacker) {
        this.unpacker = messageUnpacker;
        this.currentFormat = MessageFormat.NIL;
        this.valueHolder = new ValueHolder();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public boolean hasNext() {
        try {
            return this.unpacker.hasNext();
        }
        catch (IOException iOException) {
            throw new MessageFormatException(iOException);
        }
    }

    @Override
    public void skip() {
        try {
            this.unpacker.skipValue();
        }
        catch (IOException iOException) {
            throw new MessageFormatException(iOException);
        }
    }

    @Override
    public long getReadBytes() {
        return this.unpacker.getTotalReadBytes();
    }

    private final void readNext() {
        try {
            this.currentFormat = this.unpacker.unpackValue(this.valueHolder);
        }
        catch (IOException iOException) {
            throw new MessageFormatException(iOException);
        }
    }

    @Override
    public Value next() {
        this.readNext();
        return this.valueHolder.get();
    }

    @Override
    public ValueRef nextRef() {
        this.readNext();
        return this.valueHolder.getRef();
    }

    private ValueType getValueType() {
        return this.currentFormat.getValueType();
    }

    @Override
    public <Out> Out apply(Cursor.Function<Out> function) {
        return null;
    }

    @Override
    public boolean isNilValue() {
        return this.getValueType().isNilType();
    }

    @Override
    public boolean isBooleanValue() {
        return this.getValueType().isBooleanType();
    }

    @Override
    public boolean isNumberValue() {
        return this.getValueType().isNumberType();
    }

    @Override
    public boolean isIntegerValue() {
        return this.getValueType().isIntegerType();
    }

    @Override
    public boolean isFloatValue() {
        return this.getValueType().isFloatType();
    }

    @Override
    public boolean isBinaryValue() {
        return this.getValueType().isBinaryType();
    }

    @Override
    public boolean isStringValue() {
        return this.getValueType().isStringType();
    }

    @Override
    public boolean isRawValue() {
        return this.getValueType().isRawType();
    }

    @Override
    public boolean isArrayValue() {
        return this.getValueType().isArrayType();
    }

    @Override
    public boolean isMapValue() {
        return this.getValueType().isMapType();
    }

    @Override
    public boolean isExtendedValue() {
        return this.getValueType().isExtendedType();
    }

    @Override
    public void close() throws IOException {
        this.unpacker.close();
    }
}

