/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import org.mp4parser.BasicContainer;
import org.mp4parser.Box;
import org.mp4parser.BoxParser;
import org.mp4parser.PropertyBoxParserImpl;
import org.mp4parser.boxes.iso14496.part12.MovieBox;
import org.mp4parser.support.DoNotParseDetail;

@DoNotParseDetail
public class IsoFile
extends BasicContainer
implements Closeable {
    private final ReadableByteChannel readableByteChannel;
    private FileInputStream fis;

    public IsoFile(String file) throws IOException {
        this(new File(file));
    }

    public IsoFile(File file) throws IOException {
        this.fis = new FileInputStream(file);
        this.readableByteChannel = this.fis.getChannel();
        this.initContainer(this.readableByteChannel, -1L, new PropertyBoxParserImpl(new String[0]));
    }

    public IsoFile(ReadableByteChannel readableByteChannel) throws IOException {
        this(readableByteChannel, new PropertyBoxParserImpl(new String[0]));
    }

    public IsoFile(ReadableByteChannel readableByteChannel, BoxParser boxParser) throws IOException {
        this.readableByteChannel = readableByteChannel;
        this.initContainer(readableByteChannel, -1L, boxParser);
    }

    public static byte[] fourCCtoBytes(String fourCC) {
        byte[] result = new byte[4];
        if (fourCC != null) {
            int i = 0;
            while (i < Math.min(4, fourCC.length())) {
                result[i] = (byte)fourCC.charAt(i);
                ++i;
            }
        }
        return result;
    }

    public static String bytesToFourCC(byte[] type) {
        byte[] result = new byte[4];
        if (type != null) {
            System.arraycopy(type, 0, result, 0, Math.min(type.length, 4));
        }
        return new String(result, StandardCharsets.ISO_8859_1);
    }

    public long getSize() {
        return this.getContainerSize();
    }

    public MovieBox getMovieBox() {
        for (Box box : this.getBoxes()) {
            if (!(box instanceof MovieBox)) continue;
            return (MovieBox)box;
        }
        return null;
    }

    public void getBox(WritableByteChannel os) throws IOException {
        this.writeContainer(os);
    }

    @Override
    public void close() throws IOException {
        this.readableByteChannel.close();
        if (this.fis != null) {
            this.fis.close();
        }
        for (Box box : this.getBoxes()) {
            if (!(box instanceof Closeable)) continue;
            ((Closeable)((Object)box)).close();
        }
    }

    @Override
    public String toString() {
        return "model(" + this.readableByteChannel + ")";
    }
}

