/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.support;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.mp4parser.BoxParser;
import org.mp4parser.IsoFile;
import org.mp4parser.ParsableBox;
import org.mp4parser.support.DoNotParseDetail;
import org.mp4parser.tools.CastUtils;
import org.mp4parser.tools.Hex;
import org.mp4parser.tools.IsoTypeWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBox
implements ParsableBox {
    private static Logger LOG = LoggerFactory.getLogger(AbstractBox.class);
    protected String type;
    protected ByteBuffer content;
    boolean isParsed;
    private byte[] userType;
    private ByteBuffer deadBytes = null;

    protected AbstractBox(String type) {
        this.type = type;
        this.isParsed = true;
    }

    protected AbstractBox(String type, byte[] userType) {
        this.type = type;
        this.userType = userType;
        this.isParsed = true;
    }

    protected abstract long getContentSize();

    protected abstract void getContent(ByteBuffer var1);

    protected abstract void _parseDetails(ByteBuffer var1);

    @Override
    @DoNotParseDetail
    public void parse(ReadableByteChannel dataSource, ByteBuffer header, long contentSize, BoxParser boxParser) throws IOException {
        this.content = ByteBuffer.allocate(CastUtils.l2i(contentSize));
        while ((long)this.content.position() < contentSize) {
            if (dataSource.read(this.content) != -1) continue;
            LOG.error("{} might have been truncated by file end. bytesRead={} contentSize={}", new Object[]{this, this.content.position(), contentSize});
            break;
        }
        this.content.position(0);
        this.isParsed = false;
    }

    @Override
    public void getBox(WritableByteChannel os) throws IOException {
        if (this.isParsed) {
            ByteBuffer bb = ByteBuffer.allocate(CastUtils.l2i(this.getSize()));
            this.getHeader(bb);
            this.getContent(bb);
            if (this.deadBytes != null) {
                this.deadBytes.rewind();
                while (this.deadBytes.remaining() > 0) {
                    bb.put(this.deadBytes);
                }
            }
            os.write(bb.rewind());
        } else {
            ByteBuffer header = ByteBuffer.allocate((this.isSmallBox() ? 8 : 16) + ("uuid".equals(this.getType()) ? 16 : 0));
            this.getHeader(header);
            os.write(header.rewind());
            os.write(this.content.position(0));
        }
    }

    public final synchronized void parseDetails() {
        LOG.debug("parsing details of {}", (Object)this.getType());
        if (this.content != null) {
            ByteBuffer content = this.content;
            this.isParsed = true;
            content.rewind();
            this._parseDetails(content);
            if (content.remaining() > 0) {
                this.deadBytes = content.slice();
            }
            this.content = null;
            assert (this.verify(content));
        }
    }

    @Override
    public long getSize() {
        long size = this.isParsed ? this.getContentSize() : (long)this.content.limit();
        size += (long)(8 + (size >= 0xFFFFFFF8L ? 8 : 0) + ("uuid".equals(this.getType()) ? 16 : 0));
        return size += (long)(this.deadBytes == null ? 0 : this.deadBytes.limit());
    }

    @Override
    @DoNotParseDetail
    public String getType() {
        return this.type;
    }

    @DoNotParseDetail
    public byte[] getUserType() {
        return this.userType;
    }

    public boolean isParsed() {
        return this.isParsed;
    }

    private boolean verify(ByteBuffer content) {
        ByteBuffer bb = ByteBuffer.allocate(CastUtils.l2i(this.getContentSize() + (long)(this.deadBytes != null ? this.deadBytes.limit() : 0)));
        this.getContent(bb);
        if (this.deadBytes != null) {
            this.deadBytes.rewind();
            while (this.deadBytes.remaining() > 0) {
                bb.put(this.deadBytes);
            }
        }
        content.rewind();
        bb.rewind();
        if (content.remaining() != bb.remaining()) {
            LOG.error("{}: remaining differs {}  vs. {}", new Object[]{this.getType(), content.remaining(), bb.remaining()});
            return false;
        }
        int p = content.position();
        int i = content.limit() - 1;
        int j = bb.limit() - 1;
        while (i >= p) {
            byte v2;
            byte v1 = content.get(i);
            if (v1 != (v2 = bb.get(j))) {
                LOG.error("{}: buffers differ at {}: {}/{}", new Object[]{this.getType(), i, v1, v2});
                byte[] b1 = new byte[content.remaining()];
                byte[] b2 = new byte[bb.remaining()];
                content.get(b1);
                bb.get(b2);
                LOG.error("original      : {}", (Object)Hex.encodeHex(b1, 4));
                LOG.error("reconstructed : {}", (Object)Hex.encodeHex(b2, 4));
                return false;
            }
            --i;
            --j;
        }
        return true;
    }

    private boolean isSmallBox() {
        int baseSize = 8;
        if ("uuid".equals(this.getType())) {
            baseSize += 16;
        }
        if (this.isParsed) {
            return this.getContentSize() + (long)(this.deadBytes != null ? this.deadBytes.limit() : 0) + (long)baseSize < 0x100000000L;
        }
        return (long)(this.content.limit() + baseSize) < 0x100000000L;
    }

    private void getHeader(ByteBuffer byteBuffer) {
        if (this.isSmallBox()) {
            IsoTypeWriter.writeUInt32(byteBuffer, this.getSize());
            byteBuffer.put(IsoFile.fourCCtoBytes(this.getType()));
        } else {
            IsoTypeWriter.writeUInt32(byteBuffer, 1L);
            byteBuffer.put(IsoFile.fourCCtoBytes(this.getType()));
            IsoTypeWriter.writeUInt64(byteBuffer, this.getSize());
        }
        if ("uuid".equals(this.getType())) {
            byteBuffer.put(this.getUserType());
        }
    }
}

