/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class RewindableReadableByteChannel
implements ReadableByteChannel {
    private final ReadableByteChannel readableByteChannel;
    private final ByteBuffer buffer;
    private boolean passedRewindPoint;
    private int nextBufferWritePosition;
    private int nextBufferReadPosition;

    public RewindableReadableByteChannel(ReadableByteChannel readableByteChannel, int bufferCapacity) {
        this.buffer = ByteBuffer.allocate(bufferCapacity);
        this.readableByteChannel = readableByteChannel;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int initialDstPosition = dst.position();
        this.buffer.limit(this.buffer.capacity());
        this.buffer.position(this.nextBufferWritePosition);
        if (this.buffer.capacity() > 0) {
            this.readableByteChannel.read(this.buffer);
            this.nextBufferWritePosition = this.buffer.position();
        }
        this.buffer.position(this.nextBufferReadPosition);
        this.buffer.limit(this.nextBufferWritePosition);
        if (this.buffer.remaining() > dst.remaining()) {
            this.buffer.limit(this.buffer.position() + dst.remaining());
        }
        dst.put(this.buffer);
        this.nextBufferReadPosition = this.buffer.position();
        int bytesRead = this.readableByteChannel.read(dst);
        if (bytesRead > 0) {
            this.passedRewindPoint = true;
        } else if (bytesRead == -1 && dst.position() - initialDstPosition == 0) {
            return -1;
        }
        return dst.position() - initialDstPosition;
    }

    public void rewind() {
        if (this.passedRewindPoint) {
            throw new IllegalStateException("Passed the rewind point. Increase the buffer capacity.");
        }
        this.nextBufferReadPosition = 0;
    }

    @Override
    public boolean isOpen() {
        return this.readableByteChannel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.readableByteChannel.close();
    }
}

