/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.boxes.iso14496.part12;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.mp4parser.BoxParser;
import org.mp4parser.ParsableBox;
import org.mp4parser.support.DoNotParseDetail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MediaDataBox
implements ParsableBox {
    public static final String TYPE = "mdat";
    private static Logger LOG = LoggerFactory.getLogger(MediaDataBox.class);
    ByteBuffer header;
    File dataFile;

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        writableByteChannel.write(this.header.rewind());
        FileChannel fc = new FileInputStream(this.dataFile).getChannel();
        fc.transferTo(0L, this.dataFile.lastModified(), writableByteChannel);
        fc.close();
    }

    @Override
    public long getSize() {
        return (long)this.header.limit() + this.dataFile.length();
    }

    @Override
    @DoNotParseDetail
    public void parse(ReadableByteChannel dataSource, ByteBuffer header, long contentSize, BoxParser boxParser) throws IOException {
        this.dataFile = File.createTempFile("MediaDataBox", super.toString());
        this.dataFile.deleteOnExit();
        this.header = ByteBuffer.allocate(header.limit());
        this.header.put(header);
        RandomAccessFile raf = new RandomAccessFile(this.dataFile, "rw");
        try {
            raf.getChannel().transferFrom(dataSource, 0L, contentSize);
        }
        finally {
            raf.close();
        }
    }
}

