/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.boxes.dece;

import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.mp4parser.aj.lang.JoinPoint;
import org.mp4parser.aj.lang.Signature;
import org.mp4parser.aj.runtime.reflect.Factory;
import org.mp4parser.support.AbstractFullBox;
import org.mp4parser.support.RequiresParseDetailAspect;
import org.mp4parser.tools.IsoTypeReader;
import org.mp4parser.tools.IsoTypeWriter;
import org.mp4parser.tools.Utf8;

public class ContentInformationBox
extends AbstractFullBox {
    public static final String TYPE = "cinf";
    String mimeSubtypeName;
    String profileLevelIdc;
    String codecs;
    String protection;
    String languages;
    Map<String, String> brandEntries = new LinkedHashMap<String, String>();
    Map<String, String> idEntries = new LinkedHashMap<String, String>();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;

    public ContentInformationBox() {
        super(TYPE);
    }

    @Override
    protected long getContentSize() {
        long size = 4L;
        size += (long)(Utf8.utf8StringLengthInBytes(this.mimeSubtypeName) + 1);
        size += (long)(Utf8.utf8StringLengthInBytes(this.profileLevelIdc) + 1);
        size += (long)(Utf8.utf8StringLengthInBytes(this.codecs) + 1);
        size += (long)(Utf8.utf8StringLengthInBytes(this.protection) + 1);
        size += (long)(Utf8.utf8StringLengthInBytes(this.languages) + 1);
        ++size;
        for (Map.Entry<String, String> brandEntry : this.brandEntries.entrySet()) {
            size += (long)(Utf8.utf8StringLengthInBytes(brandEntry.getKey()) + 1);
            size += (long)(Utf8.utf8StringLengthInBytes(brandEntry.getValue()) + 1);
        }
        ++size;
        for (Map.Entry<String, String> idEntry : this.idEntries.entrySet()) {
            size += (long)(Utf8.utf8StringLengthInBytes(idEntry.getKey()) + 1);
            size += (long)(Utf8.utf8StringLengthInBytes(idEntry.getValue()) + 1);
        }
        return size;
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        IsoTypeWriter.writeZeroTermUtf8String(byteBuffer, this.mimeSubtypeName);
        IsoTypeWriter.writeZeroTermUtf8String(byteBuffer, this.profileLevelIdc);
        IsoTypeWriter.writeZeroTermUtf8String(byteBuffer, this.codecs);
        IsoTypeWriter.writeZeroTermUtf8String(byteBuffer, this.protection);
        IsoTypeWriter.writeZeroTermUtf8String(byteBuffer, this.languages);
        IsoTypeWriter.writeUInt8(byteBuffer, this.brandEntries.size());
        for (Map.Entry<String, String> brandEntry : this.brandEntries.entrySet()) {
            IsoTypeWriter.writeZeroTermUtf8String(byteBuffer, brandEntry.getKey());
            IsoTypeWriter.writeZeroTermUtf8String(byteBuffer, brandEntry.getValue());
        }
        IsoTypeWriter.writeUInt8(byteBuffer, this.idEntries.size());
        for (Map.Entry<String, String> idEntry : this.idEntries.entrySet()) {
            IsoTypeWriter.writeZeroTermUtf8String(byteBuffer, idEntry.getKey());
            IsoTypeWriter.writeZeroTermUtf8String(byteBuffer, idEntry.getValue());
        }
    }

    @Override
    protected void _parseDetails(ByteBuffer content) {
        this.parseVersionAndFlags(content);
        this.mimeSubtypeName = IsoTypeReader.readString(content);
        this.profileLevelIdc = IsoTypeReader.readString(content);
        this.codecs = IsoTypeReader.readString(content);
        this.protection = IsoTypeReader.readString(content);
        this.languages = IsoTypeReader.readString(content);
        int brandEntryCount = IsoTypeReader.readUInt8(content);
        while (brandEntryCount-- > 0) {
            this.brandEntries.put(IsoTypeReader.readString(content), IsoTypeReader.readString(content));
        }
        int idEntryCount = IsoTypeReader.readUInt8(content);
        while (idEntryCount-- > 0) {
            this.idEntries.put(IsoTypeReader.readString(content), IsoTypeReader.readString(content));
        }
    }

    public String getMimeSubtypeName() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_0, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.mimeSubtypeName;
    }

    public void setMimeSubtypeName(String mimeSubtypeName) {
        String string = mimeSubtypeName;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_1, (Object)this, (Object)this, string);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.mimeSubtypeName = mimeSubtypeName;
    }

    public String getProfileLevelIdc() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_2, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.profileLevelIdc;
    }

    public void setProfileLevelIdc(String profileLevelIdc) {
        String string = profileLevelIdc;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_3, (Object)this, (Object)this, string);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.profileLevelIdc = profileLevelIdc;
    }

    public String getCodecs() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_4, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.codecs;
    }

    public void setCodecs(String codecs) {
        String string = codecs;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_5, (Object)this, (Object)this, string);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.codecs = codecs;
    }

    public String getProtection() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_6, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.protection;
    }

    public void setProtection(String protection) {
        String string = protection;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_7, (Object)this, (Object)this, string);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.protection = protection;
    }

    public String getLanguages() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_8, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.languages;
    }

    public void setLanguages(String languages) {
        String string = languages;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_9, (Object)this, (Object)this, string);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.languages = languages;
    }

    public Map<String, String> getBrandEntries() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_10, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.brandEntries;
    }

    public void setBrandEntries(Map<String, String> brandEntries) {
        Map<String, String> map = brandEntries;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_11, (Object)this, (Object)this, map);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.brandEntries = brandEntries;
    }

    public Map<String, String> getIdEntries() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_12, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.idEntries;
    }

    public void setIdEntries(Map<String, String> idEntries) {
        Map<String, String> map = idEntries;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_13, (Object)this, (Object)this, map);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.idEntries = idEntries;
    }

    static {
        ContentInformationBox.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ContentInformationBox.java", ContentInformationBox.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMimeSubtypeName", "org.mp4parser.boxes.dece.ContentInformationBox", "", "", "", "java.lang.String"), 114);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setMimeSubtypeName", "org.mp4parser.boxes.dece.ContentInformationBox", "java.lang.String", "mimeSubtypeName", "", "void"), 118);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBrandEntries", "org.mp4parser.boxes.dece.ContentInformationBox", "", "", "", "java.util.Map"), 154);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setBrandEntries", "org.mp4parser.boxes.dece.ContentInformationBox", "java.util.Map", "brandEntries", "", "void"), 158);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getIdEntries", "org.mp4parser.boxes.dece.ContentInformationBox", "", "", "", "java.util.Map"), 162);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setIdEntries", "org.mp4parser.boxes.dece.ContentInformationBox", "java.util.Map", "idEntries", "", "void"), 166);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getProfileLevelIdc", "org.mp4parser.boxes.dece.ContentInformationBox", "", "", "", "java.lang.String"), 122);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setProfileLevelIdc", "org.mp4parser.boxes.dece.ContentInformationBox", "java.lang.String", "profileLevelIdc", "", "void"), 126);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCodecs", "org.mp4parser.boxes.dece.ContentInformationBox", "", "", "", "java.lang.String"), 130);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCodecs", "org.mp4parser.boxes.dece.ContentInformationBox", "java.lang.String", "codecs", "", "void"), 134);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getProtection", "org.mp4parser.boxes.dece.ContentInformationBox", "", "", "", "java.lang.String"), 138);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setProtection", "org.mp4parser.boxes.dece.ContentInformationBox", "java.lang.String", "protection", "", "void"), 142);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLanguages", "org.mp4parser.boxes.dece.ContentInformationBox", "", "", "", "java.lang.String"), 146);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setLanguages", "org.mp4parser.boxes.dece.ContentInformationBox", "java.lang.String", "languages", "", "void"), 150);
    }

    public static class BrandEntry {
        String iso_brand;
        String version;

        public BrandEntry(String iso_brand, String version) {
            this.iso_brand = iso_brand;
            this.version = version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BrandEntry that = (BrandEntry)o;
            if (this.iso_brand != null ? !this.iso_brand.equals(that.iso_brand) : that.iso_brand != null) {
                return false;
            }
            return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
        }

        public int hashCode() {
            int result = this.iso_brand != null ? this.iso_brand.hashCode() : 0;
            result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
            return result;
        }
    }
}

