/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.boxes.iso14496.part15;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.mp4parser.tools.IsoTypeReader;
import org.mp4parser.tools.IsoTypeWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HevcDecoderConfigurationRecord {
    int configurationVersion;
    int general_profile_space;
    boolean general_tier_flag;
    int general_profile_idc;
    long general_profile_compatibility_flags;
    long general_constraint_indicator_flags;
    int general_level_idc;
    int reserved1 = 15;
    int min_spatial_segmentation_idc;
    int reserved2 = 63;
    int parallelismType;
    int reserved3 = 63;
    int chromaFormat;
    int reserved4 = 31;
    int bitDepthLumaMinus8;
    int reserved5 = 31;
    int bitDepthChromaMinus8;
    int avgFrameRate;
    int constantFrameRate;
    int numTemporalLayers;
    boolean temporalIdNested;
    int lengthSizeMinusOne;
    List<Array> arrays = new ArrayList<Array>();
    boolean frame_only_constraint_flag;
    boolean non_packed_constraint_flag;
    boolean interlaced_source_flag;
    boolean progressive_source_flag;

    public void parse(ByteBuffer content) {
        this.configurationVersion = IsoTypeReader.readUInt8(content);
        int a = IsoTypeReader.readUInt8(content);
        this.general_profile_space = (a & 0xC0) >> 6;
        this.general_tier_flag = (a & 0x20) > 0;
        this.general_profile_idc = a & 0x1F;
        this.general_profile_compatibility_flags = IsoTypeReader.readUInt32(content);
        this.general_constraint_indicator_flags = IsoTypeReader.readUInt48(content);
        this.frame_only_constraint_flag = (this.general_constraint_indicator_flags >> 44 & 8L) > 0L;
        this.non_packed_constraint_flag = (this.general_constraint_indicator_flags >> 44 & 4L) > 0L;
        this.interlaced_source_flag = (this.general_constraint_indicator_flags >> 44 & 2L) > 0L;
        this.progressive_source_flag = (this.general_constraint_indicator_flags >> 44 & 1L) > 0L;
        this.general_constraint_indicator_flags &= 0x7FFFFFFFFFFFL;
        this.general_level_idc = IsoTypeReader.readUInt8(content);
        a = IsoTypeReader.readUInt16(content);
        this.reserved1 = (a & 0xF000) >> 12;
        this.min_spatial_segmentation_idc = a & 0xFFF;
        a = IsoTypeReader.readUInt8(content);
        this.reserved2 = (a & 0xFC) >> 2;
        this.parallelismType = a & 3;
        a = IsoTypeReader.readUInt8(content);
        this.reserved3 = (a & 0xFC) >> 2;
        this.chromaFormat = a & 3;
        a = IsoTypeReader.readUInt8(content);
        this.reserved4 = (a & 0xF8) >> 3;
        this.bitDepthLumaMinus8 = a & 7;
        a = IsoTypeReader.readUInt8(content);
        this.reserved5 = (a & 0xF8) >> 3;
        this.bitDepthChromaMinus8 = a & 7;
        this.avgFrameRate = IsoTypeReader.readUInt16(content);
        a = IsoTypeReader.readUInt8(content);
        this.constantFrameRate = (a & 0xC0) >> 6;
        this.numTemporalLayers = (a & 0x38) >> 3;
        this.temporalIdNested = (a & 4) > 0;
        this.lengthSizeMinusOne = a & 3;
        int numOfArrays = IsoTypeReader.readUInt8(content);
        this.arrays = new ArrayList<Array>();
        int i = 0;
        while (i < numOfArrays) {
            Array array = new Array();
            a = IsoTypeReader.readUInt8(content);
            array.array_completeness = (a & 0x80) > 0;
            array.reserved = (a & 0x40) > 0;
            array.nal_unit_type = a & 0x3F;
            int numNalus = IsoTypeReader.readUInt16(content);
            array.nalUnits = new ArrayList<byte[]>();
            int j = 0;
            while (j < numNalus) {
                int nalUnitLength = IsoTypeReader.readUInt16(content);
                byte[] nal = new byte[nalUnitLength];
                content.get(nal);
                array.nalUnits.add(nal);
                ++j;
            }
            this.arrays.add(array);
            ++i;
        }
    }

    public void write(ByteBuffer byteBuffer) {
        IsoTypeWriter.writeUInt8(byteBuffer, this.configurationVersion);
        IsoTypeWriter.writeUInt8(byteBuffer, (this.general_profile_space << 6) + (this.general_tier_flag ? 32 : 0) + this.general_profile_idc);
        IsoTypeWriter.writeUInt32(byteBuffer, this.general_profile_compatibility_flags);
        long _general_constraint_indicator_flags = this.general_constraint_indicator_flags;
        if (this.frame_only_constraint_flag) {
            _general_constraint_indicator_flags |= 0x800000000000L;
        }
        if (this.non_packed_constraint_flag) {
            _general_constraint_indicator_flags |= 0x400000000000L;
        }
        if (this.interlaced_source_flag) {
            _general_constraint_indicator_flags |= 0x200000000000L;
        }
        if (this.progressive_source_flag) {
            _general_constraint_indicator_flags |= 0x100000000000L;
        }
        IsoTypeWriter.writeUInt48(byteBuffer, _general_constraint_indicator_flags);
        IsoTypeWriter.writeUInt8(byteBuffer, this.general_level_idc);
        IsoTypeWriter.writeUInt16(byteBuffer, (this.reserved1 << 12) + this.min_spatial_segmentation_idc);
        IsoTypeWriter.writeUInt8(byteBuffer, (this.reserved2 << 2) + this.parallelismType);
        IsoTypeWriter.writeUInt8(byteBuffer, (this.reserved3 << 2) + this.chromaFormat);
        IsoTypeWriter.writeUInt8(byteBuffer, (this.reserved4 << 3) + this.bitDepthLumaMinus8);
        IsoTypeWriter.writeUInt8(byteBuffer, (this.reserved5 << 3) + this.bitDepthChromaMinus8);
        IsoTypeWriter.writeUInt16(byteBuffer, this.avgFrameRate);
        IsoTypeWriter.writeUInt8(byteBuffer, (this.constantFrameRate << 6) + (this.numTemporalLayers << 3) + (this.temporalIdNested ? 4 : 0) + this.lengthSizeMinusOne);
        IsoTypeWriter.writeUInt8(byteBuffer, this.arrays.size());
        for (Array array : this.arrays) {
            IsoTypeWriter.writeUInt8(byteBuffer, (array.array_completeness ? 128 : 0) + (array.reserved ? 64 : 0) + array.nal_unit_type);
            IsoTypeWriter.writeUInt16(byteBuffer, array.nalUnits.size());
            for (byte[] nalUnit : array.nalUnits) {
                IsoTypeWriter.writeUInt16(byteBuffer, nalUnit.length);
                byteBuffer.put(nalUnit);
            }
        }
    }

    public int getSize() {
        int size = 23;
        for (Array array : this.arrays) {
            size += 3;
            for (byte[] nalUnit : array.nalUnits) {
                size += 2;
                size += nalUnit.length;
            }
        }
        return size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HevcDecoderConfigurationRecord that = (HevcDecoderConfigurationRecord)o;
        if (this.avgFrameRate != that.avgFrameRate) {
            return false;
        }
        if (this.bitDepthChromaMinus8 != that.bitDepthChromaMinus8) {
            return false;
        }
        if (this.bitDepthLumaMinus8 != that.bitDepthLumaMinus8) {
            return false;
        }
        if (this.chromaFormat != that.chromaFormat) {
            return false;
        }
        if (this.configurationVersion != that.configurationVersion) {
            return false;
        }
        if (this.constantFrameRate != that.constantFrameRate) {
            return false;
        }
        if (this.general_constraint_indicator_flags != that.general_constraint_indicator_flags) {
            return false;
        }
        if (this.general_level_idc != that.general_level_idc) {
            return false;
        }
        if (this.general_profile_compatibility_flags != that.general_profile_compatibility_flags) {
            return false;
        }
        if (this.general_profile_idc != that.general_profile_idc) {
            return false;
        }
        if (this.general_profile_space != that.general_profile_space) {
            return false;
        }
        if (this.general_tier_flag != that.general_tier_flag) {
            return false;
        }
        if (this.lengthSizeMinusOne != that.lengthSizeMinusOne) {
            return false;
        }
        if (this.min_spatial_segmentation_idc != that.min_spatial_segmentation_idc) {
            return false;
        }
        if (this.numTemporalLayers != that.numTemporalLayers) {
            return false;
        }
        if (this.parallelismType != that.parallelismType) {
            return false;
        }
        if (this.reserved1 != that.reserved1) {
            return false;
        }
        if (this.reserved2 != that.reserved2) {
            return false;
        }
        if (this.reserved3 != that.reserved3) {
            return false;
        }
        if (this.reserved4 != that.reserved4) {
            return false;
        }
        if (this.reserved5 != that.reserved5) {
            return false;
        }
        if (this.temporalIdNested != that.temporalIdNested) {
            return false;
        }
        return !(this.arrays != null ? !this.arrays.equals(that.arrays) : that.arrays != null);
    }

    public int hashCode() {
        int result = this.configurationVersion;
        result = 31 * result + this.general_profile_space;
        result = 31 * result + (this.general_tier_flag ? 1 : 0);
        result = 31 * result + this.general_profile_idc;
        result = 31 * result + (int)(this.general_profile_compatibility_flags ^ this.general_profile_compatibility_flags >>> 32);
        result = 31 * result + (int)(this.general_constraint_indicator_flags ^ this.general_constraint_indicator_flags >>> 32);
        result = 31 * result + this.general_level_idc;
        result = 31 * result + this.reserved1;
        result = 31 * result + this.min_spatial_segmentation_idc;
        result = 31 * result + this.reserved2;
        result = 31 * result + this.parallelismType;
        result = 31 * result + this.reserved3;
        result = 31 * result + this.chromaFormat;
        result = 31 * result + this.reserved4;
        result = 31 * result + this.bitDepthLumaMinus8;
        result = 31 * result + this.reserved5;
        result = 31 * result + this.bitDepthChromaMinus8;
        result = 31 * result + this.avgFrameRate;
        result = 31 * result + this.constantFrameRate;
        result = 31 * result + this.numTemporalLayers;
        result = 31 * result + (this.temporalIdNested ? 1 : 0);
        result = 31 * result + this.lengthSizeMinusOne;
        result = 31 * result + (this.arrays != null ? this.arrays.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "HEVCDecoderConfigurationRecord{configurationVersion=" + this.configurationVersion + ", general_profile_space=" + this.general_profile_space + ", general_tier_flag=" + this.general_tier_flag + ", general_profile_idc=" + this.general_profile_idc + ", general_profile_compatibility_flags=" + this.general_profile_compatibility_flags + ", general_constraint_indicator_flags=" + this.general_constraint_indicator_flags + ", general_level_idc=" + this.general_level_idc + (this.reserved1 != 15 ? ", reserved1=" + this.reserved1 : "") + ", min_spatial_segmentation_idc=" + this.min_spatial_segmentation_idc + (this.reserved2 != 63 ? ", reserved2=" + this.reserved2 : "") + ", parallelismType=" + this.parallelismType + (this.reserved3 != 63 ? ", reserved3=" + this.reserved3 : "") + ", chromaFormat=" + this.chromaFormat + (this.reserved4 != 31 ? ", reserved4=" + this.reserved4 : "") + ", bitDepthLumaMinus8=" + this.bitDepthLumaMinus8 + (this.reserved5 != 31 ? ", reserved5=" + this.reserved5 : "") + ", bitDepthChromaMinus8=" + this.bitDepthChromaMinus8 + ", avgFrameRate=" + this.avgFrameRate + ", constantFrameRate=" + this.constantFrameRate + ", numTemporalLayers=" + this.numTemporalLayers + ", temporalIdNested=" + this.temporalIdNested + ", lengthSizeMinusOne=" + this.lengthSizeMinusOne + ", arrays=" + this.arrays + '}';
    }

    public int getConfigurationVersion() {
        return this.configurationVersion;
    }

    public void setConfigurationVersion(int configurationVersion) {
        this.configurationVersion = configurationVersion;
    }

    public int getGeneral_profile_space() {
        return this.general_profile_space;
    }

    public void setGeneral_profile_space(int general_profile_space) {
        this.general_profile_space = general_profile_space;
    }

    public boolean isGeneral_tier_flag() {
        return this.general_tier_flag;
    }

    public void setGeneral_tier_flag(boolean general_tier_flag) {
        this.general_tier_flag = general_tier_flag;
    }

    public int getGeneral_profile_idc() {
        return this.general_profile_idc;
    }

    public void setGeneral_profile_idc(int general_profile_idc) {
        this.general_profile_idc = general_profile_idc;
    }

    public long getGeneral_profile_compatibility_flags() {
        return this.general_profile_compatibility_flags;
    }

    public void setGeneral_profile_compatibility_flags(long general_profile_compatibility_flags) {
        this.general_profile_compatibility_flags = general_profile_compatibility_flags;
    }

    public long getGeneral_constraint_indicator_flags() {
        return this.general_constraint_indicator_flags;
    }

    public void setGeneral_constraint_indicator_flags(long general_constraint_indicator_flags) {
        this.general_constraint_indicator_flags = general_constraint_indicator_flags;
    }

    public int getGeneral_level_idc() {
        return this.general_level_idc;
    }

    public void setGeneral_level_idc(int general_level_idc) {
        this.general_level_idc = general_level_idc;
    }

    public int getMin_spatial_segmentation_idc() {
        return this.min_spatial_segmentation_idc;
    }

    public void setMin_spatial_segmentation_idc(int min_spatial_segmentation_idc) {
        this.min_spatial_segmentation_idc = min_spatial_segmentation_idc;
    }

    public int getParallelismType() {
        return this.parallelismType;
    }

    public void setParallelismType(int parallelismType) {
        this.parallelismType = parallelismType;
    }

    public int getChromaFormat() {
        return this.chromaFormat;
    }

    public void setChromaFormat(int chromaFormat) {
        this.chromaFormat = chromaFormat;
    }

    public int getBitDepthLumaMinus8() {
        return this.bitDepthLumaMinus8;
    }

    public void setBitDepthLumaMinus8(int bitDepthLumaMinus8) {
        this.bitDepthLumaMinus8 = bitDepthLumaMinus8;
    }

    public int getBitDepthChromaMinus8() {
        return this.bitDepthChromaMinus8;
    }

    public void setBitDepthChromaMinus8(int bitDepthChromaMinus8) {
        this.bitDepthChromaMinus8 = bitDepthChromaMinus8;
    }

    public int getAvgFrameRate() {
        return this.avgFrameRate;
    }

    public void setAvgFrameRate(int avgFrameRate) {
        this.avgFrameRate = avgFrameRate;
    }

    public int getNumTemporalLayers() {
        return this.numTemporalLayers;
    }

    public void setNumTemporalLayers(int numTemporalLayers) {
        this.numTemporalLayers = numTemporalLayers;
    }

    public int getLengthSizeMinusOne() {
        return this.lengthSizeMinusOne;
    }

    public void setLengthSizeMinusOne(int lengthSizeMinusOne) {
        this.lengthSizeMinusOne = lengthSizeMinusOne;
    }

    public boolean isTemporalIdNested() {
        return this.temporalIdNested;
    }

    public void setTemporalIdNested(boolean temporalIdNested) {
        this.temporalIdNested = temporalIdNested;
    }

    public int getConstantFrameRate() {
        return this.constantFrameRate;
    }

    public void setConstantFrameRate(int constantFrameRate) {
        this.constantFrameRate = constantFrameRate;
    }

    public List<Array> getArrays() {
        return this.arrays;
    }

    public void setArrays(List<Array> arrays) {
        this.arrays = arrays;
    }

    public boolean isFrame_only_constraint_flag() {
        return this.frame_only_constraint_flag;
    }

    public void setFrame_only_constraint_flag(boolean frame_only_constraint_flag) {
        this.frame_only_constraint_flag = frame_only_constraint_flag;
    }

    public boolean isNon_packed_constraint_flag() {
        return this.non_packed_constraint_flag;
    }

    public void setNon_packed_constraint_flag(boolean non_packed_constraint_flag) {
        this.non_packed_constraint_flag = non_packed_constraint_flag;
    }

    public boolean isInterlaced_source_flag() {
        return this.interlaced_source_flag;
    }

    public void setInterlaced_source_flag(boolean interlaced_source_flag) {
        this.interlaced_source_flag = interlaced_source_flag;
    }

    public boolean isProgressive_source_flag() {
        return this.progressive_source_flag;
    }

    public void setProgressive_source_flag(boolean progressive_source_flag) {
        this.progressive_source_flag = progressive_source_flag;
    }

    public static class Array {
        public boolean array_completeness;
        public boolean reserved;
        public int nal_unit_type;
        public List<byte[]> nalUnits;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Array array = (Array)o;
            if (this.array_completeness != array.array_completeness) {
                return false;
            }
            if (this.nal_unit_type != array.nal_unit_type) {
                return false;
            }
            if (this.reserved != array.reserved) {
                return false;
            }
            ListIterator<byte[]> e1 = this.nalUnits.listIterator();
            ListIterator<byte[]> e2 = array.nalUnits.listIterator();
            while (e1.hasNext() && e2.hasNext()) {
                byte[] o1 = e1.next();
                byte[] o2 = e2.next();
                if (!(o1 == null ? o2 != null : !Arrays.equals(o1, o2))) continue;
                return false;
            }
            return !e1.hasNext() && !e2.hasNext();
        }

        public int hashCode() {
            int result = this.array_completeness ? 1 : 0;
            result = 31 * result + (this.reserved ? 1 : 0);
            result = 31 * result + this.nal_unit_type;
            result = 31 * result + (this.nalUnits != null ? this.nalUnits.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Array{nal_unit_type=" + this.nal_unit_type + ", reserved=" + this.reserved + ", array_completeness=" + this.array_completeness + ", num_nals=" + this.nalUnits.size() + '}';
        }
    }
}

