/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.boxes.iso14496.part1.objectdescriptors;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.BaseDescriptor;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.Descriptor;
import org.mp4parser.tools.Hex;
import org.mp4parser.tools.IsoTypeWriter;

@Descriptor(tags={5})
public class DecoderSpecificInfo
extends BaseDescriptor {
    byte[] bytes;

    public DecoderSpecificInfo() {
        this.tag = 5;
    }

    public void parseDetail(ByteBuffer bb) throws IOException {
        this.bytes = new byte[bb.remaining()];
        bb.get(this.bytes);
    }

    public void setData(byte[] bytes) {
        this.bytes = bytes;
    }

    int getContentSize() {
        return this.bytes.length;
    }

    public ByteBuffer serialize() {
        ByteBuffer out = ByteBuffer.allocate(this.getSize());
        IsoTypeWriter.writeUInt8(out, this.tag);
        this.writeSize(out, this.getContentSize());
        out.put(this.bytes);
        return (ByteBuffer)out.rewind();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DecoderSpecificInfo");
        sb.append("{bytes=").append(this.bytes == null ? "null" : Hex.encodeHex(this.bytes));
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecoderSpecificInfo that = (DecoderSpecificInfo)o;
        return Arrays.equals(this.bytes, that.bytes);
    }

    public int hashCode() {
        return this.bytes != null ? Arrays.hashCode(this.bytes) : 0;
    }
}

