/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.boxes.apple;

import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.mp4parser.aj.lang.JoinPoint;
import org.mp4parser.aj.lang.Signature;
import org.mp4parser.aj.runtime.reflect.Factory;
import org.mp4parser.boxes.apple.AppleDataBox;
import org.mp4parser.support.RequiresParseDetailAspect;
import org.mp4parser.tools.IsoTypeReader;
import org.mp4parser.tools.Utf8;

public class AppleRecordingYearBox
extends AppleDataBox {
    DateFormat df;
    Date date = new Date();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public AppleRecordingYearBox() {
        super("\u00a9day", 1);
        this.df = new SimpleDateFormat("yyyy-MM-dd'T'kk:mm:ssZ");
        this.df.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    protected static String iso8601toRfc822Date(String iso8601) {
        iso8601 = iso8601.replaceAll("Z$", "+0000");
        iso8601 = iso8601.replaceAll("([0-9][0-9]):([0-9][0-9])$", "$1$2");
        return iso8601;
    }

    protected static String rfc822toIso8601Date(String rfc622) {
        rfc622 = rfc622.replaceAll("\\+0000$", "Z");
        return rfc622;
    }

    public Date getDate() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_0, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.date;
    }

    public void setDate(Date date) {
        Date date2 = date;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_1, (Object)this, (Object)this, date2);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.date = date;
    }

    protected byte[] writeData() {
        return Utf8.convert(AppleRecordingYearBox.rfc822toIso8601Date(this.df.format(this.date)));
    }

    protected void parseData(ByteBuffer data) {
        String dateString = IsoTypeReader.readString(data, data.remaining());
        try {
            this.date = this.df.parse(AppleRecordingYearBox.iso8601toRfc822Date(dateString));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    protected int getDataLength() {
        return Utf8.convert(AppleRecordingYearBox.rfc822toIso8601Date(this.df.format(this.date))).length;
    }

    static {
        AppleRecordingYearBox.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AppleRecordingYearBox.java", AppleRecordingYearBox.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDate", "org.mp4parser.boxes.apple.AppleRecordingYearBox", "", "", "", "java.util.Date"), 38);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDate", "org.mp4parser.boxes.apple.AppleRecordingYearBox", "java.util.Date", "date", "", "void"), 42);
    }
}

