/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.boxes.iso14496.part12;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import org.mp4parser.aspectj.lang.JoinPoint;
import org.mp4parser.aspectj.lang.Signature;
import org.mp4parser.aspectj.runtime.internal.Conversions;
import org.mp4parser.aspectj.runtime.reflect.Factory;
import org.mp4parser.support.AbstractFullBox;
import org.mp4parser.support.RequiresParseDetailAspect;
import org.mp4parser.tools.IsoTypeReader;
import org.mp4parser.tools.IsoTypeReaderVariable;
import org.mp4parser.tools.IsoTypeWriter;
import org.mp4parser.tools.IsoTypeWriterVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemLocationBox
extends AbstractFullBox {
    public static final String TYPE = "iloc";
    public int offsetSize = 8;
    public int lengthSize = 8;
    public int baseOffsetSize = 8;
    public int indexSize = 0;
    public List<Item> items = new LinkedList<Item>();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;

    public ItemLocationBox() {
        super(TYPE);
    }

    @Override
    protected long getContentSize() {
        long size = 8L;
        for (Item item : this.items) {
            size += (long)item.getSize();
        }
        return size;
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        IsoTypeWriter.writeUInt8(byteBuffer, this.offsetSize << 4 | this.lengthSize);
        if (this.getVersion() == 1) {
            IsoTypeWriter.writeUInt8(byteBuffer, this.baseOffsetSize << 4 | this.indexSize);
        } else {
            IsoTypeWriter.writeUInt8(byteBuffer, this.baseOffsetSize << 4);
        }
        IsoTypeWriter.writeUInt16(byteBuffer, this.items.size());
        for (Item item : this.items) {
            item.getContent(byteBuffer);
        }
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        this.parseVersionAndFlags(content);
        int tmp = IsoTypeReader.readUInt8(content);
        this.offsetSize = tmp >>> 4;
        this.lengthSize = tmp & 0xF;
        tmp = IsoTypeReader.readUInt8(content);
        this.baseOffsetSize = tmp >>> 4;
        if (this.getVersion() == 1) {
            this.indexSize = tmp & 0xF;
        }
        int itemCount = IsoTypeReader.readUInt16(content);
        int i = 0;
        while (i < itemCount) {
            this.items.add(new Item(content));
            ++i;
        }
    }

    public int getOffsetSize() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_0, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.offsetSize;
    }

    public void setOffsetSize(int offsetSize) {
        int n = offsetSize;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_1, (Object)this, (Object)this, Conversions.intObject(n));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.offsetSize = offsetSize;
    }

    public int getLengthSize() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_2, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.lengthSize;
    }

    public void setLengthSize(int lengthSize) {
        int n = lengthSize;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_3, (Object)this, (Object)this, Conversions.intObject(n));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.lengthSize = lengthSize;
    }

    public int getBaseOffsetSize() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_4, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.baseOffsetSize;
    }

    public void setBaseOffsetSize(int baseOffsetSize) {
        int n = baseOffsetSize;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_5, (Object)this, (Object)this, Conversions.intObject(n));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.baseOffsetSize = baseOffsetSize;
    }

    public int getIndexSize() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_6, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.indexSize;
    }

    public void setIndexSize(int indexSize) {
        int n = indexSize;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_7, (Object)this, (Object)this, Conversions.intObject(n));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.indexSize = indexSize;
    }

    public List<Item> getItems() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_8, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.items;
    }

    public void setItems(List<Item> items) {
        List<Item> list = items;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_9, (Object)this, (Object)this, list);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.items = items;
    }

    public Item createItem(int itemId, int constructionMethod, int dataReferenceIndex, long baseOffset, List<Extent> extents) {
        int n = itemId;
        int n2 = constructionMethod;
        int n3 = dataReferenceIndex;
        long l = baseOffset;
        List<Extent> list = extents;
        Object[] objectArray = new Object[]{Conversions.intObject(n), Conversions.intObject(n2), Conversions.intObject(n3), Conversions.longObject(l), list};
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_10, (Object)this, (Object)this, objectArray);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return new Item(itemId, constructionMethod, dataReferenceIndex, baseOffset, extents);
    }

    Item createItem(ByteBuffer bb) {
        return new Item(bb);
    }

    public Extent createExtent(long extentOffset, long extentLength, long extentIndex) {
        long l = extentOffset;
        long l2 = extentLength;
        long l3 = extentIndex;
        Object[] objectArray = new Object[]{Conversions.longObject(l), Conversions.longObject(l2), Conversions.longObject(l3)};
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_11, (Object)this, (Object)this, objectArray);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return new Extent(extentOffset, extentLength, extentIndex);
    }

    Extent createExtent(ByteBuffer bb) {
        return new Extent(bb);
    }

    static {
        ItemLocationBox.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ItemLocationBox.java", ItemLocationBox.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getOffsetSize", "org.mp4parser.boxes.iso14496.part12.ItemLocationBox", "", "", "", "int"), 118);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setOffsetSize", "org.mp4parser.boxes.iso14496.part12.ItemLocationBox", "int", "offsetSize", "", "void"), 122);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createItem", "org.mp4parser.boxes.iso14496.part12.ItemLocationBox", "int:int:int:long:java.util.List", "itemId:constructionMethod:dataReferenceIndex:baseOffset:extents", "", "org.mp4parser.boxes.iso14496.part12.ItemLocationBox$Item"), 159);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createExtent", "org.mp4parser.boxes.iso14496.part12.ItemLocationBox", "long:long:long", "extentOffset:extentLength:extentIndex", "", "org.mp4parser.boxes.iso14496.part12.ItemLocationBox$Extent"), 167);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLengthSize", "org.mp4parser.boxes.iso14496.part12.ItemLocationBox", "", "", "", "int"), 126);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setLengthSize", "org.mp4parser.boxes.iso14496.part12.ItemLocationBox", "int", "lengthSize", "", "void"), 130);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBaseOffsetSize", "org.mp4parser.boxes.iso14496.part12.ItemLocationBox", "", "", "", "int"), 134);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setBaseOffsetSize", "org.mp4parser.boxes.iso14496.part12.ItemLocationBox", "int", "baseOffsetSize", "", "void"), 138);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getIndexSize", "org.mp4parser.boxes.iso14496.part12.ItemLocationBox", "", "", "", "int"), 142);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setIndexSize", "org.mp4parser.boxes.iso14496.part12.ItemLocationBox", "int", "indexSize", "", "void"), 146);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getItems", "org.mp4parser.boxes.iso14496.part12.ItemLocationBox", "", "", "", "java.util.List"), 150);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setItems", "org.mp4parser.boxes.iso14496.part12.ItemLocationBox", "java.util.List", "items", "", "void"), 154);
    }

    public class Extent {
        public long extentOffset;
        public long extentLength;
        public long extentIndex;

        public Extent(long extentOffset, long extentLength, long extentIndex) {
            this.extentOffset = extentOffset;
            this.extentLength = extentLength;
            this.extentIndex = extentIndex;
        }

        public Extent(ByteBuffer in) {
            if (ItemLocationBox.this.getVersion() == 1 && ItemLocationBox.this.indexSize > 0) {
                this.extentIndex = IsoTypeReaderVariable.read(in, ItemLocationBox.this.indexSize);
            }
            this.extentOffset = IsoTypeReaderVariable.read(in, ItemLocationBox.this.offsetSize);
            this.extentLength = IsoTypeReaderVariable.read(in, ItemLocationBox.this.lengthSize);
        }

        public void getContent(ByteBuffer os) {
            if (ItemLocationBox.this.getVersion() == 1 && ItemLocationBox.this.indexSize > 0) {
                IsoTypeWriterVariable.write(this.extentIndex, os, ItemLocationBox.this.indexSize);
            }
            IsoTypeWriterVariable.write(this.extentOffset, os, ItemLocationBox.this.offsetSize);
            IsoTypeWriterVariable.write(this.extentLength, os, ItemLocationBox.this.lengthSize);
        }

        public int getSize() {
            return (ItemLocationBox.this.indexSize > 0 ? ItemLocationBox.this.indexSize : 0) + ItemLocationBox.this.offsetSize + ItemLocationBox.this.lengthSize;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Extent extent = (Extent)o;
            if (this.extentIndex != extent.extentIndex) {
                return false;
            }
            if (this.extentLength != extent.extentLength) {
                return false;
            }
            return this.extentOffset == extent.extentOffset;
        }

        public int hashCode() {
            int result = (int)(this.extentOffset ^ this.extentOffset >>> 32);
            result = 31 * result + (int)(this.extentLength ^ this.extentLength >>> 32);
            result = 31 * result + (int)(this.extentIndex ^ this.extentIndex >>> 32);
            return result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Extent");
            sb.append("{extentOffset=").append(this.extentOffset);
            sb.append(", extentLength=").append(this.extentLength);
            sb.append(", extentIndex=").append(this.extentIndex);
            sb.append('}');
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Item {
        public int itemId;
        public int constructionMethod;
        public int dataReferenceIndex;
        public long baseOffset;
        public List<Extent> extents = new LinkedList<Extent>();

        public Item(ByteBuffer in) {
            this.itemId = IsoTypeReader.readUInt16(in);
            if (ItemLocationBox.this.getVersion() == 1) {
                int tmp = IsoTypeReader.readUInt16(in);
                this.constructionMethod = tmp & 0xF;
            }
            this.dataReferenceIndex = IsoTypeReader.readUInt16(in);
            this.baseOffset = ItemLocationBox.this.baseOffsetSize > 0 ? IsoTypeReaderVariable.read(in, ItemLocationBox.this.baseOffsetSize) : 0L;
            int extentCount = IsoTypeReader.readUInt16(in);
            int i = 0;
            while (i < extentCount) {
                this.extents.add(new Extent(in));
                ++i;
            }
        }

        public Item(int itemId, int constructionMethod, int dataReferenceIndex, long baseOffset, List<Extent> extents) {
            this.itemId = itemId;
            this.constructionMethod = constructionMethod;
            this.dataReferenceIndex = dataReferenceIndex;
            this.baseOffset = baseOffset;
            this.extents = extents;
        }

        public int getSize() {
            int size = 2;
            if (ItemLocationBox.this.getVersion() == 1) {
                size += 2;
            }
            size += 2;
            size += ItemLocationBox.this.baseOffsetSize;
            size += 2;
            for (Extent extent : this.extents) {
                size += extent.getSize();
            }
            return size;
        }

        public void setBaseOffset(long baseOffset) {
            this.baseOffset = baseOffset;
        }

        public void getContent(ByteBuffer bb) {
            IsoTypeWriter.writeUInt16(bb, this.itemId);
            if (ItemLocationBox.this.getVersion() == 1) {
                IsoTypeWriter.writeUInt16(bb, this.constructionMethod);
            }
            IsoTypeWriter.writeUInt16(bb, this.dataReferenceIndex);
            if (ItemLocationBox.this.baseOffsetSize > 0) {
                IsoTypeWriterVariable.write(this.baseOffset, bb, ItemLocationBox.this.baseOffsetSize);
            }
            IsoTypeWriter.writeUInt16(bb, this.extents.size());
            for (Extent extent : this.extents) {
                extent.getContent(bb);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Item item = (Item)o;
            if (this.baseOffset != item.baseOffset) {
                return false;
            }
            if (this.constructionMethod != item.constructionMethod) {
                return false;
            }
            if (this.dataReferenceIndex != item.dataReferenceIndex) {
                return false;
            }
            if (this.itemId != item.itemId) {
                return false;
            }
            return !(this.extents != null ? !this.extents.equals(item.extents) : item.extents != null);
        }

        public int hashCode() {
            int result = this.itemId;
            result = 31 * result + this.constructionMethod;
            result = 31 * result + this.dataReferenceIndex;
            result = 31 * result + (int)(this.baseOffset ^ this.baseOffset >>> 32);
            result = 31 * result + (this.extents != null ? this.extents.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Item{baseOffset=" + this.baseOffset + ", itemId=" + this.itemId + ", constructionMethod=" + this.constructionMethod + ", dataReferenceIndex=" + this.dataReferenceIndex + ", extents=" + this.extents + '}';
        }
    }
}

