/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.tools.shell.Global;

class ExecUtil {
    private static final Object[] emptyArray = new Object[0];

    private ExecUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int runCommand(Global global, Scriptable thisObj, Object[] args) throws IOException {
        int i;
        int len = args.length;
        if (len == 0 || len == 1 && args[0] instanceof Scriptable) {
            throw Global.reportRuntimeError("msg.runCommand.bad.args");
        }
        String[] environment = null;
        File wd = null;
        InputStream in = null;
        OutputStream out = null;
        OutputStream err = null;
        Scriptable params = null;
        Global.CommandExecutor commandExecutor = null;
        Object[] addArgs = emptyArray;
        int timeout = 0;
        if (args[len - 1] instanceof Scriptable) {
            params = (Scriptable)args[--len];
            environment = ExecUtil.parseEnvironment(params);
            wd = ExecUtil.parseWorkingDir(params);
            in = ExecUtil.parseInput(params);
            out = ExecUtil.parseOutput(params, "output");
            err = ExecUtil.parseOutput(params, "err");
            timeout = ExecUtil.parseTimeout(params);
            addArgs = ExecUtil.parseAddArgs(params, thisObj);
            commandExecutor = ExecUtil.parseCommandLauncher(params);
        }
        if (out == null) {
            out = global.getOut();
        }
        if (err == null) {
            err = global.getErr();
        }
        if (commandExecutor == null) {
            commandExecutor = Runtime.getRuntime()::exec;
        }
        String[] cmd = new String[len + addArgs.length];
        for (i = 0; i != len; ++i) {
            cmd[i] = ScriptRuntime.toString((Object)args[i]);
        }
        for (i = 0; i != addArgs.length; ++i) {
            cmd[len + i] = ScriptRuntime.toString((Object)addArgs[i]);
        }
        try {
            Process p = commandExecutor.exec(cmd, environment, wd);
            int n = ExecUtil.waitForProcess(p, in, out, err, timeout);
            return n;
        }
        finally {
            if (out instanceof ReturnBuffer) {
                ScriptableObject.putProperty((Scriptable)params, (String)"output", (Object)out.toString());
            }
            if (err instanceof ReturnBuffer) {
                ScriptableObject.putProperty((Scriptable)params, (String)"err", (Object)out.toString());
            }
        }
    }

    private static String[] parseEnvironment(Scriptable params) {
        Object obj = ScriptableObject.getProperty((Scriptable)params, (String)"env");
        if (obj == Scriptable.NOT_FOUND) {
            return null;
        }
        if (obj == null) {
            return new String[0];
        }
        if (!(obj instanceof Scriptable)) {
            throw Global.reportRuntimeError("msg.runCommand.bad.env");
        }
        Scriptable envHash = (Scriptable)obj;
        Object[] ids = ScriptableObject.getPropertyIds((Scriptable)envHash);
        String[] environment = new String[ids.length];
        for (int i = 0; i != ids.length; ++i) {
            Object val;
            String key;
            Object keyObj = ids[i];
            if (keyObj instanceof String) {
                key = (String)keyObj;
                val = ScriptableObject.getProperty((Scriptable)envHash, (String)key);
            } else {
                int ikey = ((Number)keyObj).intValue();
                key = Integer.toString(ikey);
                val = ScriptableObject.getProperty((Scriptable)envHash, (int)ikey);
            }
            if (val == ScriptableObject.NOT_FOUND) {
                val = Undefined.instance;
            }
            environment[i] = key + "=" + ScriptRuntime.toString((Object)val);
        }
        return environment;
    }

    private static File parseWorkingDir(Scriptable params) {
        Object obj = ScriptableObject.getProperty((Scriptable)params, (String)"dir");
        if (obj == Scriptable.NOT_FOUND) {
            return null;
        }
        if (obj instanceof Wrapper) {
            obj = ((Wrapper)obj).unwrap();
        }
        if (obj instanceof File) {
            return (File)obj;
        }
        return new File(ScriptRuntime.toString((Object)obj));
    }

    private static InputStream parseInput(Scriptable params) throws IOException {
        Object obj = ScriptableObject.getProperty((Scriptable)params, (String)"input");
        if (obj == Scriptable.NOT_FOUND) {
            return null;
        }
        if (obj instanceof Wrapper) {
            obj = ((Wrapper)obj).unwrap();
        }
        if (obj instanceof InputStream) {
            return (InputStream)obj;
        }
        if (obj instanceof byte[]) {
            return new ByteArrayInputStream((byte[])obj);
        }
        String s = obj instanceof Reader ? Global.readReader((Reader)obj) : (obj instanceof char[] ? new String((char[])obj) : ScriptRuntime.toString((Object)obj));
        return new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8));
    }

    private static OutputStream parseOutput(Scriptable params, String type) {
        Object obj = ScriptableObject.getProperty((Scriptable)params, (String)type);
        if (obj == Scriptable.NOT_FOUND) {
            return null;
        }
        if (obj instanceof Wrapper) {
            obj = ((Wrapper)obj).unwrap();
        }
        if (obj instanceof OutputStream) {
            return (OutputStream)obj;
        }
        return new ReturnBuffer(ScriptRuntime.toString((Object)obj));
    }

    private static int parseTimeout(Scriptable params) {
        Object obj = ScriptableObject.getProperty((Scriptable)params, (String)"timeout");
        if (obj == Scriptable.NOT_FOUND) {
            return -1;
        }
        return ScriptRuntime.toInt32((Object)obj);
    }

    private static Object[] parseAddArgs(Scriptable params, Scriptable scope) {
        Object obj = ScriptableObject.getProperty((Scriptable)params, (String)"args");
        if (obj == Scriptable.NOT_FOUND) {
            return emptyArray;
        }
        Scriptable s = Context.toObject((Object)obj, (Scriptable)ScriptableObject.getTopLevelScope((Scriptable)scope));
        return ScriptRuntime.getArrayElements((Scriptable)s);
    }

    private static Global.CommandExecutor parseCommandLauncher(Scriptable params) {
        Object obj = ScriptableObject.getProperty((Scriptable)params, (String)"commandExecutor");
        if (obj == Scriptable.NOT_FOUND) {
            return null;
        }
        if (obj instanceof Wrapper) {
            obj = ((Wrapper)obj).unwrap();
        }
        return (Global.CommandExecutor)obj;
    }

    /*
     * Exception decompiling
     */
    private static int waitForProcess(Process p, InputStream in, OutputStream out, OutputStream err, int timeout) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static KillThread startKillThread(Process process, int timeout) {
        if (timeout <= 0) {
            return null;
        }
        KillThread killThread = new KillThread(process, timeout);
        killThread.start();
        return killThread;
    }

    private static PipeThread startPipeThread(InputStream in, OutputStream out, Closeable processStream) throws IOException {
        if (in == null) {
            out.close();
            return null;
        }
        if (out == null) {
            in.close();
            return null;
        }
        PipeThread pipeThread = new PipeThread(in, out, processStream);
        pipeThread.start();
        return pipeThread;
    }

    private static class ReturnBuffer
    extends ByteArrayOutputStream {
        public ReturnBuffer(String init) {
            this.writeBytes(init.getBytes(StandardCharsets.UTF_8));
        }

        @Override
        public synchronized String toString() {
            return super.toString(StandardCharsets.UTF_8);
        }
    }

    private static class PipeThread
    extends Thread
    implements AutoCloseable {
        private final OutputStream out;
        private final InputStream in;
        private final Closeable streamOfProcess;
        private Throwable error;
        boolean reportErrors = true;

        PipeThread(InputStream in, OutputStream out, Closeable streamOfProcess) {
            this.setDaemon(true);
            this.in = in;
            this.out = out;
            this.streamOfProcess = streamOfProcess;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            block17: {
                byte[] buffer = new byte[8192];
                try {
                    int read;
                    if (this.in == this.streamOfProcess) {
                        int read2;
                        while ((read2 = this.readNoThrow(buffer)) >= 0) {
                            this.out.write(buffer, 0, read2);
                            this.out.flush();
                        }
                        break block17;
                    }
                    assert (this.out == this.streamOfProcess);
                    while ((read = this.in.read(buffer, 0, buffer.length)) >= 0) {
                        try {
                            this.out.write(buffer, 0, read);
                            this.out.flush();
                        }
                        catch (IOException e) {
                            // empty catch block
                            break;
                        }
                    }
                }
                catch (Throwable t) {
                    this.error = t;
                }
                finally {
                    try {
                        this.streamOfProcess.close();
                    }
                    catch (IOException e) {}
                }
            }
        }

        private int readNoThrow(byte[] buffer) {
            try {
                return this.in.read(buffer, 0, buffer.length);
            }
            catch (IOException e) {
                return -1;
            }
        }

        @Override
        public void close() {
            while (true) {
                try {
                    this.join();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
            if (this.reportErrors && this.error != null) {
                throw Context.throwAsScriptRuntimeEx((Throwable)this.error);
            }
        }
    }

    private static class KillThread
    extends Thread
    implements AutoCloseable {
        private final Process process;
        private final int timeout;
        volatile boolean killed;

        public KillThread(Process process, int timeout) {
            this.setDaemon(true);
            this.process = process;
            this.timeout = timeout;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.timeout);
                this.killed = true;
                this.process.destroy();
            }
            catch (InterruptedException e) {
                this.interrupt();
            }
        }

        @Override
        public void close() {
            this.interrupt();
        }
    }
}

