/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.engine;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import javax.script.ScriptContext;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class Builtins {
    static final Object BUILTIN_KEY = new Object();
    private Writer stdout;

    void register(Context cx, ScriptableObject scope, ScriptContext sc) {
        this.stdout = sc.getWriter() == null ? new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8) : sc.getWriter();
        scope.defineProperty((Scriptable)scope, "print", 0, Builtins::print, 6, 3);
    }

    private static Object print(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        try {
            Builtins self = Builtins.getSelf(thisObj);
            for (Object arg : args) {
                self.stdout.write(ScriptRuntime.toString((Object)arg));
            }
            self.stdout.write(10);
            self.stdout.flush();
        }
        catch (IOException e) {
            throw Context.throwAsScriptRuntimeEx((Throwable)e);
        }
        return Undefined.instance;
    }

    private static Builtins getSelf(Scriptable scope) {
        return (Builtins)ScriptableObject.getTopScopeValue((Scriptable)scope, (Object)BUILTIN_KEY);
    }
}

