/*
 * Decompiled with CFR 0.152.
 */
package mozilla.components.browser.search;

import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.util.Base64;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mozilla.components.browser.search.SearchEngine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\bH\u0002J\u0018\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u001b"}, d2={"Lmozilla/components/browser/search/SearchEngineParser;", "", "()V", "load", "Lmozilla/components/browser/search/SearchEngine;", "assetManager", "Landroid/content/res/AssetManager;", "identifier", "", "path", "stream", "Ljava/io/InputStream;", "readImage", "", "parser", "Lorg/xmlpull/v1/XmlPullParser;", "builder", "Lmozilla/components/browser/search/SearchEngineParser$SearchEngineBuilder;", "readSearchPlugin", "readShortName", "readUri", "Landroid/net/Uri;", "template", "readUrl", "skip", "Companion", "SearchEngineBuilder", "search_release"})
public final class SearchEngineParser {
    private static final String URLTYPE_SUGGEST_JSON = "application/x-suggestions+json";
    private static final String URLTYPE_SEARCH_HTML = "text/html";
    private static final String URL_REL_MOBILE = "mobile";
    private static final String IMAGE_URI_PREFIX = "data:image/png;base64,";
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final SearchEngine load(@NotNull AssetManager assetManager, @NotNull String identifier, @NotNull String path) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)assetManager, (String)"assetManager");
        Intrinsics.checkParameterIsNotNull((Object)identifier, (String)"identifier");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        try {
            Closeable closeable = assetManager.open(path);
            Throwable throwable = null;
            try {
                InputStream stream;
                InputStream inputStream = stream = (InputStream)closeable;
                Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"stream");
                SearchEngine searchEngine = this.load(identifier, inputStream);
                return searchEngine;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (XmlPullParserException e) {
            throw (Throwable)((Object)new AssertionError("Parser exception while reading " + path, e));
        }
    }

    @NotNull
    public final SearchEngine load(@NotNull String identifier, @NotNull InputStream stream) throws IOException, XmlPullParserException {
        Intrinsics.checkParameterIsNotNull((Object)identifier, (String)"identifier");
        Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
        SearchEngineBuilder builder = new SearchEngineBuilder(identifier);
        XmlPullParser parser = XmlPullParserFactory.newInstance().newPullParser();
        parser.setInput((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
        parser.next();
        XmlPullParser xmlPullParser = parser;
        Intrinsics.checkExpressionValueIsNotNull((Object)xmlPullParser, (String)"parser");
        this.readSearchPlugin(xmlPullParser, builder);
        return builder.toSearchEngine();
    }

    private final void readSearchPlugin(XmlPullParser parser, SearchEngineBuilder builder) throws XmlPullParserException, IOException {
        if (2 != parser.getEventType()) {
            throw (Throwable)new XmlPullParserException("Expected start tag: " + parser.getPositionDescription());
        }
        String name = parser.getName();
        if (Intrinsics.areEqual((Object)"SearchPlugin", (Object)name) ^ true && Intrinsics.areEqual((Object)"OpenSearchDescription", (Object)name) ^ true) {
            throw (Throwable)new XmlPullParserException("Expected <SearchPlugin> or <OpenSearchDescription> as root tag: " + parser.getPositionDescription());
        }
        block10: while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            if (parser.getName() != null) {
                String string;
                int n = -1;
                switch (string.hashCode()) {
                    case -24251129: {
                        if (!string.equals("ShortName")) break;
                        n = 1;
                        break;
                    }
                    case 70760763: {
                        if (!string.equals("Image")) break;
                        n = 2;
                        break;
                    }
                    case 85327: {
                        if (!string.equals("Url")) break;
                        n = 3;
                        break;
                    }
                }
                switch (n) {
                    case 1: {
                        this.readShortName(parser, builder);
                        continue block10;
                    }
                    case 3: {
                        this.readUrl(parser, builder);
                        continue block10;
                    }
                    case 2: {
                        this.readImage(parser, builder);
                        continue block10;
                    }
                }
            }
            this.skip(parser);
        }
    }

    private final void readUrl(XmlPullParser parser, SearchEngineBuilder builder) throws XmlPullParserException, IOException {
        parser.require(2, null, "Url");
        String type = parser.getAttributeValue(null, "type");
        String template = parser.getAttributeValue(null, "template");
        String rel = parser.getAttributeValue(null, "rel");
        String string = template;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"template");
        Uri uri = this.readUri(parser, string);
        if (Intrinsics.areEqual((Object)type, (Object)URLTYPE_SEARCH_HTML)) {
            if (rel != null && Intrinsics.areEqual((Object)rel, (Object)URL_REL_MOBILE)) {
                builder.getResultsUris().add(0, uri);
            } else {
                builder.getResultsUris().add(uri);
            }
        } else if (Intrinsics.areEqual((Object)type, (Object)URLTYPE_SUGGEST_JSON)) {
            builder.setSuggestUri(uri);
        }
    }

    private final Uri readUri(XmlPullParser parser, String template) throws XmlPullParserException, IOException {
        Uri uri = Uri.parse((String)template);
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            if (Intrinsics.areEqual((Object)parser.getName(), (Object)"Param")) {
                String name = parser.getAttributeValue(null, "name");
                String value = parser.getAttributeValue(null, "value");
                uri = uri.buildUpon().appendQueryParameter(name, value).build();
                parser.nextTag();
                continue;
            }
            this.skip(parser);
        }
        Uri uri2 = uri;
        Intrinsics.checkExpressionValueIsNotNull((Object)uri2, (String)"uri");
        return uri2;
    }

    private final void skip(XmlPullParser parser) throws XmlPullParserException, IOException {
        if (parser.getEventType() != 2) {
            throw (Throwable)new IllegalStateException();
        }
        int depth = 1;
        while (depth != 0) {
            switch (parser.next()) {
                case 3: {
                    --depth;
                    break;
                }
                case 2: {
                    ++depth;
                }
            }
        }
    }

    private final void readShortName(XmlPullParser parser, SearchEngineBuilder builder) throws IOException, XmlPullParserException {
        parser.require(2, null, "ShortName");
        if (parser.next() == 4) {
            builder.setName(parser.getText());
            parser.nextTag();
        }
    }

    private final void readImage(XmlPullParser parser, SearchEngineBuilder builder) throws IOException, XmlPullParserException {
        String uri;
        parser.require(2, null, "Image");
        if (parser.next() != 4) {
            return;
        }
        String string = uri = parser.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"uri");
        if (!StringsKt.startsWith$default((String)string, (String)IMAGE_URI_PREFIX, (boolean)false, (int)2, null)) {
            return;
        }
        String string2 = uri;
        int n = IMAGE_URI_PREFIX.length();
        String string3 = string2.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        byte[] raw = Base64.decode((String)string3, (int)0);
        builder.setIcon(BitmapFactory.decodeByteArray((byte[])raw, (int)0, (int)raw.length));
        parser.nextTag();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u001b\u001a\u00020\u001cR\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u0004R \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001d"}, d2={"Lmozilla/components/browser/search/SearchEngineParser$SearchEngineBuilder;", "", "identifier", "", "(Ljava/lang/String;)V", "icon", "Landroid/graphics/Bitmap;", "getIcon", "()Landroid/graphics/Bitmap;", "setIcon", "(Landroid/graphics/Bitmap;)V", "name", "getName", "()Ljava/lang/String;", "setName", "resultsUris", "", "Landroid/net/Uri;", "getResultsUris", "()Ljava/util/List;", "setResultsUris", "(Ljava/util/List;)V", "suggestUri", "getSuggestUri", "()Landroid/net/Uri;", "setSuggestUri", "(Landroid/net/Uri;)V", "toSearchEngine", "Lmozilla/components/browser/search/SearchEngine;", "search_release"})
    private static final class SearchEngineBuilder {
        @NotNull
        private List<Uri> resultsUris;
        @Nullable
        private Uri suggestUri;
        @Nullable
        private String name;
        @Nullable
        private Bitmap icon;
        private final String identifier;

        @NotNull
        public final List<Uri> getResultsUris() {
            return this.resultsUris;
        }

        public final void setResultsUris(@NotNull List<Uri> list) {
            Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
            this.resultsUris = list;
        }

        @Nullable
        public final Uri getSuggestUri() {
            return this.suggestUri;
        }

        public final void setSuggestUri(@Nullable Uri uri) {
            this.suggestUri = uri;
        }

        @Nullable
        public final String getName() {
            return this.name;
        }

        public final void setName(@Nullable String string) {
            this.name = string;
        }

        @Nullable
        public final Bitmap getIcon() {
            return this.icon;
        }

        public final void setIcon(@Nullable Bitmap bitmap) {
            this.icon = bitmap;
        }

        @NotNull
        public final SearchEngine toSearchEngine() {
            String string = this.name;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Bitmap bitmap = this.icon;
            if (bitmap == null) {
                Intrinsics.throwNpe();
            }
            return new SearchEngine(this.identifier, string, bitmap, this.resultsUris, this.suggestUri);
        }

        public SearchEngineBuilder(@NotNull String identifier) {
            List list;
            Intrinsics.checkParameterIsNotNull((Object)identifier, (String)"identifier");
            this.identifier = identifier;
            SearchEngineBuilder searchEngineBuilder = this;
            searchEngineBuilder.resultsUris = list = (List)new ArrayList();
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lmozilla/components/browser/search/SearchEngineParser$Companion;", "", "()V", "IMAGE_URI_PREFIX", "", "URLTYPE_SEARCH_HTML", "URLTYPE_SUGGEST_JSON", "URL_REL_MOBILE", "search_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

