/*
 * Decompiled with CFR 0.152.
 */
package mozilla.components.browser.search;

import android.graphics.Bitmap;
import android.net.Uri;
import android.text.TextUtils;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0011\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB9\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0016\u001a\u00020\u0003J\u0018\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u0018\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0003H\u0002R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lmozilla/components/browser/search/SearchEngine;", "", "identifier", "", "name", "icon", "Landroid/graphics/Bitmap;", "resultsUris", "", "Landroid/net/Uri;", "suggestUri", "(Ljava/lang/String;Ljava/lang/String;Landroid/graphics/Bitmap;Ljava/util/List;Landroid/net/Uri;)V", "canProvideSearchSuggestions", "", "getCanProvideSearchSuggestions", "()Z", "getIcon", "()Landroid/graphics/Bitmap;", "getIdentifier", "()Ljava/lang/String;", "getName", "buildSearchUrl", "searchTerm", "buildSuggestionsURL", "buildURL", "uri", "paramSubstitution", "template", "query", "Companion", "search_release"})
public final class SearchEngine {
    private final boolean canProvideSearchSuggestions;
    @NotNull
    private final String identifier;
    @NotNull
    private final String name;
    @NotNull
    private final Bitmap icon;
    private final List<Uri> resultsUris;
    private final Uri suggestUri;
    private static final String MOZ_PARAM_LOCALE = "{moz:locale}";
    private static final String MOZ_PARAM_DIST_ID = "{moz:distributionID}";
    private static final String MOZ_PARAM_OFFICIAL = "{moz:official}";
    private static final String OS_PARAM_USER_DEFINED = "{searchTerms}";
    private static final String OS_PARAM_INPUT_ENCODING = "{inputEncoding}";
    private static final String OS_PARAM_LANGUAGE = "{language}";
    private static final String OS_PARAM_OUTPUT_ENCODING = "{outputEncoding}";
    private static final String OS_PARAM_OPTIONAL = "\\{(?:\\w+:)?\\w+?\\}";
    public static final Companion Companion = new Companion(null);

    public final boolean getCanProvideSearchSuggestions() {
        return this.canProvideSearchSuggestions;
    }

    @NotNull
    public final String buildSearchUrl(@NotNull String searchTerm) {
        Intrinsics.checkParameterIsNotNull((Object)searchTerm, (String)"searchTerm");
        Uri searchUri = this.resultsUris.get(0);
        return this.buildURL(searchUri, searchTerm);
    }

    @Nullable
    public final String buildSuggestionsURL(@NotNull String searchTerm) {
        Intrinsics.checkParameterIsNotNull((Object)searchTerm, (String)"searchTerm");
        Uri uri = this.suggestUri;
        if (uri == null) {
            return null;
        }
        Uri suggestUri = uri;
        return this.buildURL(suggestUri, searchTerm);
    }

    private final String buildURL(Uri uri, String searchTerm) {
        String template;
        String string = template = Uri.decode((String)uri.toString());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"template");
        String string2 = Uri.encode((String)searchTerm);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Uri.encode(searchTerm)");
        String urlWithSubstitutions = this.paramSubstitution(string, string2);
        return SearchEngine.Companion.normalize(urlWithSubstitutions);
    }

    private final String paramSubstitution(String template, String query) {
        String locale;
        String result = template;
        String string = locale = Locale.getDefault().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"locale");
        result = StringsKt.replace$default((String)result, (String)MOZ_PARAM_LOCALE, (String)string, (boolean)false, (int)4, null);
        result = StringsKt.replace$default((String)result, (String)MOZ_PARAM_DIST_ID, (String)"", (boolean)false, (int)4, null);
        result = StringsKt.replace$default((String)result, (String)MOZ_PARAM_OFFICIAL, (String)"unofficial", (boolean)false, (int)4, null);
        result = StringsKt.replace$default((String)result, (String)OS_PARAM_USER_DEFINED, (String)query, (boolean)false, (int)4, null);
        result = StringsKt.replace$default((String)result, (String)OS_PARAM_INPUT_ENCODING, (String)"UTF-8", (boolean)false, (int)4, null);
        result = StringsKt.replace$default((String)result, (String)OS_PARAM_LANGUAGE, (String)locale, (boolean)false, (int)4, null);
        result = StringsKt.replace$default((String)result, (String)OS_PARAM_OUTPUT_ENCODING, (String)"UTF-8", (boolean)false, (int)4, null);
        CharSequence charSequence = result;
        String string2 = OS_PARAM_OPTIONAL;
        string2 = new Regex(string2);
        String string3 = "";
        result = string2.replace(charSequence, string3);
        return result;
    }

    @NotNull
    public final String getIdentifier() {
        return this.identifier;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Bitmap getIcon() {
        return this.icon;
    }

    public SearchEngine(@NotNull String identifier, @NotNull String name, @NotNull Bitmap icon, @NotNull List<? extends Uri> resultsUris, @Nullable Uri suggestUri) {
        Intrinsics.checkParameterIsNotNull((Object)identifier, (String)"identifier");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)icon, (String)"icon");
        Intrinsics.checkParameterIsNotNull(resultsUris, (String)"resultsUris");
        this.identifier = identifier;
        this.name = name;
        this.icon = icon;
        this.resultsUris = resultsUris;
        this.suggestUri = suggestUri;
        boolean bl = this.canProvideSearchSuggestions = this.suggestUri != null;
        if (this.resultsUris.isEmpty()) {
            throw (Throwable)new IllegalArgumentException("Results uri list should not be empty!");
        }
    }

    public /* synthetic */ SearchEngine(String string, String string2, Bitmap bitmap, List list, Uri uri, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            uri = null;
        }
        this(string, string2, bitmap, list, uri);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lmozilla/components/browser/search/SearchEngine$Companion;", "", "()V", "MOZ_PARAM_DIST_ID", "", "MOZ_PARAM_LOCALE", "MOZ_PARAM_OFFICIAL", "OS_PARAM_INPUT_ENCODING", "OS_PARAM_LANGUAGE", "OS_PARAM_OPTIONAL", "OS_PARAM_OUTPUT_ENCODING", "OS_PARAM_USER_DEFINED", "normalize", "input", "search_release"})
    public static final class Companion {
        private final String normalize(String input) {
            Uri uri;
            String $receiver$iv = input;
            CharSequence $receiver$iv$iv = $receiver$iv;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $receiver$iv$iv.charAt(index$iv$iv);
                boolean bl = match$iv$iv = it <= ' ';
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String trimmedInput = ((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            Uri uri2 = uri = Uri.parse((String)trimmedInput);
            Intrinsics.checkExpressionValueIsNotNull((Object)uri2, (String)"uri");
            if (TextUtils.isEmpty((CharSequence)uri2.getScheme())) {
                uri = Uri.parse((String)("http://" + trimmedInput));
            }
            String string = uri.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"uri.toString()");
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

