/*
 * Decompiled with CFR 0.152.
 */
package mozilla.components.tooling.lint;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lmozilla/components/tooling/lint/LintLogChecks;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/Detector$UastScanner;", "()V", "getApplicableMethodNames", "", "", "visitMethod", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "tooling-lint"})
public final class LintLogChecks
extends Detector
implements Detector.UastScanner {
    private static final Issue ISSUE_LOG_USAGE;
    @NotNull
    private static final List<Issue> issues;
    public static final Companion Companion;

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object[])new String[]{"v", "d", "i", "w", "e"});
    }

    public void visitMethod(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        if (context.getEvaluator().isMemberInClass((PsiMember)method, "android.util.Log")) {
            JavaContext.report$default((JavaContext)context, (Issue)ISSUE_LOG_USAGE, (UElement)((UElement)node), (Location)context.getLocation((UElement)node), (String)"Using Android Log instead of base component", null, (int)16, null);
        }
    }

    static {
        Companion = new Companion(null);
        ISSUE_LOG_USAGE = Issue.Companion.create("LogUsage", "Log/Logger from base component should be used.", StringsKt.trimIndent((String)"The Log or Logger class from the base component should be used for logging instead of\n            Android's Log class. This will allow the app to control what logs should be accepted\n            and how they should be processed."), Category.MESSAGES, 5, Severity.WARNING, new Implementation(LintLogChecks.class, EnumSet.of((Enum)Scope.JAVA_FILE)));
        issues = CollectionsKt.listOf((Object)ISSUE_LOG_USAGE);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lmozilla/components/tooling/lint/LintLogChecks$Companion;", "", "()V", "ISSUE_LOG_USAGE", "Lcom/android/tools/lint/detector/api/Issue;", "issues", "", "getIssues", "()Ljava/util/List;", "tooling-lint"})
    public static final class Companion {
        @NotNull
        public final List<Issue> getIssues() {
            return issues;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

