/*
 * Decompiled with CFR 0.152.
 */
package mozilla.components.support.ktx.android.view;

import android.content.res.Resources;
import android.support.v4.view.ViewCompat;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import mozilla.components.support.ktx.android.view.ShowKeyboard;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\u001a\u0012\u0010\t\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\n\u001a\u00020\u0006\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\u0002\u001a\n\u0010\r\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u000e\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u000f\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0010\u001a\u00020\f*\u00020\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0003\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"isLTR", "", "Landroid/view/View;", "(Landroid/view/View;)Z", "isRTL", "layoutDirection", "", "getLayoutDirection", "(Landroid/view/View;)I", "dp", "pixels", "hideKeyboard", "", "isGone", "isInvisible", "isVisible", "showKeyboard", "ktx_release"})
public final class ViewKt {
    public static final int getLayoutDirection(@NotNull View $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return ViewCompat.getLayoutDirection((View)$receiver);
    }

    public static final boolean isRTL(@NotNull View $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getLayoutDirection() == 1;
    }

    public static final boolean isLTR(@NotNull View $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getLayoutDirection() == 0;
    }

    public static final int dp(@NotNull View $receiver, int pixels) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        float f = pixels;
        Resources resources = $receiver.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        return (int)TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)resources.getDisplayMetrics());
    }

    public static final boolean isVisible(@NotNull View $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getVisibility() == 0;
    }

    public static final boolean isGone(@NotNull View $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getVisibility() == 8;
    }

    public static final boolean isInvisible(@NotNull View $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getVisibility() == 4;
    }

    public static final void showKeyboard(@NotNull View $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        new ShowKeyboard($receiver).post();
    }

    public static final void hideKeyboard(@NotNull View $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Object object = $receiver.getContext().getSystemService("input_method");
        if (object == null) {
            return;
        }
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
        }
        InputMethodManager imm = (InputMethodManager)object;
        imm.hideSoftInputFromWindow($receiver.getWindowToken(), 0);
    }
}

