/*
 * Decompiled with CFR 0.152.
 */
package mozilla.components.feature.session;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import mozilla.components.browser.session.Session;
import mozilla.components.browser.session.SessionManager;
import mozilla.components.concept.engine.Engine;
import mozilla.components.concept.engine.EngineSession;
import mozilla.components.concept.engine.EngineView;
import mozilla.components.feature.session.SessionProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0006\u0010\u000e\u001a\u00020\nJ\u0006\u0010\u000f\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lmozilla/components/feature/session/EngineViewPresenter;", "Lmozilla/components/browser/session/SessionManager$Observer;", "sessionProvider", "Lmozilla/components/feature/session/SessionProvider;", "engine", "Lmozilla/components/concept/engine/Engine;", "engineView", "Lmozilla/components/concept/engine/EngineView;", "(Lmozilla/components/feature/session/SessionProvider;Lmozilla/components/concept/engine/Engine;Lmozilla/components/concept/engine/EngineView;)V", "onSessionSelected", "", "session", "Lmozilla/components/browser/session/Session;", "renderSession", "start", "stop", "feature-session_release"})
public final class EngineViewPresenter
implements SessionManager.Observer {
    private final SessionProvider sessionProvider;
    private final Engine engine;
    private final EngineView engineView;

    public final void start() {
        this.renderSession(this.sessionProvider.getSelectedSession());
        this.sessionProvider.getSessionManager().register((SessionManager.Observer)this);
    }

    public final void stop() {
        this.sessionProvider.getSessionManager().unregister((SessionManager.Observer)this);
    }

    public void onSessionSelected(@NotNull Session session) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        this.renderSession(session);
    }

    private final void renderSession(Session session) {
        EngineSession engineSession = this.sessionProvider.getOrCreateEngineSession(this.engine, session);
        this.engineView.render(engineSession);
    }

    public EngineViewPresenter(@NotNull SessionProvider sessionProvider, @NotNull Engine engine, @NotNull EngineView engineView) {
        Intrinsics.checkParameterIsNotNull((Object)sessionProvider, (String)"sessionProvider");
        Intrinsics.checkParameterIsNotNull((Object)engine, (String)"engine");
        Intrinsics.checkParameterIsNotNull((Object)engineView, (String)"engineView");
        this.sessionProvider = sessionProvider;
        this.engine = engine;
        this.engineView = engineView;
    }
}

