/*
 * Decompiled with CFR 0.152.
 */
package mozilla.components.feature.session;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mozilla.components.browser.session.Session;
import mozilla.components.browser.session.SessionManager;
import mozilla.components.concept.engine.Engine;
import mozilla.components.concept.engine.EngineSession;
import mozilla.components.concept.session.storage.SessionStorage;
import mozilla.components.feature.session.SessionProxy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B9\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00182\b\b\u0002\u0010\u001a\u001a\u00020\u0003J\u0018\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001a\u001a\u00020\u0003J\"\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u00032\b\b\u0002\u0010\u001f\u001a\u00020\u0018H\u0002J\u000e\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\"\u001a\u00020!R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lmozilla/components/feature/session/SessionProvider;", "", "initialSession", "Lmozilla/components/browser/session/Session;", "sessionStorage", "Lmozilla/components/concept/session/storage/SessionStorage;", "savePeriodically", "", "saveIntervalInSeconds", "", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "(Lmozilla/components/browser/session/Session;Lmozilla/components/concept/session/storage/SessionStorage;ZJLjava/util/concurrent/ScheduledExecutorService;)V", "scheduledFuture", "Ljava/util/concurrent/ScheduledFuture;", "selectedSession", "getSelectedSession", "()Lmozilla/components/browser/session/Session;", "sessionManager", "Lmozilla/components/browser/session/SessionManager;", "getSessionManager", "()Lmozilla/components/browser/session/SessionManager;", "sessions", "Ljava/util/concurrent/ConcurrentHashMap;", "Lmozilla/components/concept/engine/EngineSession;", "getEngineSession", "session", "getOrCreateEngineSession", "engine", "Lmozilla/components/concept/engine/Engine;", "initEngineSession", "engineSession", "start", "", "stop", "feature-session_release"})
public final class SessionProvider {
    private final ConcurrentHashMap<Session, EngineSession> sessions;
    @NotNull
    private final SessionManager sessionManager;
    private ScheduledFuture<?> scheduledFuture;
    private final SessionStorage sessionStorage;
    private final boolean savePeriodically;
    private final long saveIntervalInSeconds;
    private final ScheduledExecutorService scheduler;

    @NotNull
    public final SessionManager getSessionManager() {
        return this.sessionManager;
    }

    @NotNull
    public final Session getSelectedSession() {
        return this.sessionManager.getSelectedSession();
    }

    /*
     * WARNING - void declaration
     */
    public final void start(@NotNull Engine engine) {
        block3: {
            SessionStorage sessionStorage;
            Intrinsics.checkParameterIsNotNull((Object)engine, (String)"engine");
            SessionStorage sessionStorage2 = this.sessionStorage;
            if (sessionStorage2 == null) break block3;
            SessionStorage it = sessionStorage = sessionStorage2;
            if (this.sessions.isEmpty()) {
                void restoredSessions;
                Pair pair = this.sessionStorage.restore(engine);
                Map map = (Map)pair.component1();
                String restoredSelectedSession = (String)pair.component2();
                Iterable $receiver$iv = restoredSessions.keySet();
                for (Object element$iv : $receiver$iv) {
                    Session it2 = (Session)element$iv;
                    this.initEngineSession(engine, it2, (EngineSession)MapsKt.getValue((Map)restoredSessions, (Object)it2));
                    this.sessionManager.add(it2, Intrinsics.areEqual((Object)it2.getId(), (Object)restoredSelectedSession));
                }
                this.sessions.putAll((Map<Session, EngineSession>)restoredSessions);
            }
            if (this.savePeriodically) {
                this.scheduledFuture = this.scheduler.scheduleAtFixedRate(new Runnable(this, engine){
                    final /* synthetic */ SessionProvider this$0;
                    final /* synthetic */ Engine $engine$inlined;
                    {
                        this.this$0 = sessionProvider;
                        this.$engine$inlined = engine;
                    }

                    public final void run() {
                        SessionProvider.access$getSessionStorage$p(this.this$0).persist((Map)SessionProvider.access$getSessions$p(this.this$0), this.this$0.getSelectedSession().getId());
                    }
                }, this.saveIntervalInSeconds, this.saveIntervalInSeconds, TimeUnit.SECONDS);
            }
        }
    }

    @Nullable
    public final EngineSession getEngineSession(@NotNull Session session) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return this.sessions.get(session);
    }

    @Nullable
    public static /* bridge */ /* synthetic */ EngineSession getEngineSession$default(SessionProvider sessionProvider, Session session, int n, Object object) {
        if ((n & 1) != 0) {
            session = sessionProvider.getSelectedSession();
        }
        return sessionProvider.getEngineSession(session);
    }

    @NotNull
    public final EngineSession getOrCreateEngineSession(@NotNull Engine engine, @NotNull Session session) {
        Intrinsics.checkParameterIsNotNull((Object)engine, (String)"engine");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        ConcurrentMap $receiver$iv = this.sessions;
        Object object = $receiver$iv.get(session);
        if (object == null) {
            EngineSession engineSession = SessionProvider.initEngineSession$default(this, engine, session, null, 4, null);
            EngineSession default$iv = engineSession;
            object = $receiver$iv.putIfAbsent(session, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkExpressionValueIsNotNull(object, (String)"sessions.getOrPut(sessio\u2026ssion(engine, session) })");
        return (EngineSession)object;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ EngineSession getOrCreateEngineSession$default(SessionProvider sessionProvider, Engine engine, Session session, int n, Object object) {
        if ((n & 2) != 0) {
            session = sessionProvider.getSelectedSession();
        }
        return sessionProvider.getOrCreateEngineSession(engine, session);
    }

    private final EngineSession initEngineSession(Engine engine, Session session, EngineSession engineSession) {
        new SessionProxy(session, engineSession);
        engineSession.loadUrl(session.getUrl());
        return engineSession;
    }

    static /* bridge */ /* synthetic */ EngineSession initEngineSession$default(SessionProvider sessionProvider, Engine engine, Session session, EngineSession engineSession, int n, Object object) {
        if ((n & 4) != 0) {
            engineSession = engine.createSession();
        }
        return sessionProvider.initEngineSession(engine, session, engineSession);
    }

    public final void stop() {
        block0: {
            ScheduledFuture<?> scheduledFuture = this.scheduledFuture;
            if (scheduledFuture == null) break block0;
            scheduledFuture.cancel(false);
        }
    }

    public SessionProvider(@NotNull Session initialSession, @Nullable SessionStorage sessionStorage, boolean savePeriodically, long saveIntervalInSeconds, @NotNull ScheduledExecutorService scheduler) {
        Intrinsics.checkParameterIsNotNull((Object)initialSession, (String)"initialSession");
        Intrinsics.checkParameterIsNotNull((Object)scheduler, (String)"scheduler");
        this.sessionStorage = sessionStorage;
        this.savePeriodically = savePeriodically;
        this.saveIntervalInSeconds = saveIntervalInSeconds;
        this.scheduler = scheduler;
        this.sessions = new ConcurrentHashMap();
        this.sessionManager = new SessionManager(initialSession);
    }

    public /* synthetic */ SessionProvider(Session session, SessionStorage sessionStorage, boolean bl, long l, ScheduledExecutorService scheduledExecutorService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            session = new Session("", null, 2, null);
        }
        if ((n & 2) != 0) {
            sessionStorage = null;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            l = 300L;
        }
        if ((n & 0x10) != 0) {
            ScheduledExecutorService scheduledExecutorService2 = Executors.newSingleThreadScheduledExecutor();
            Intrinsics.checkExpressionValueIsNotNull((Object)scheduledExecutorService2, (String)"Executors.newSingleThreadScheduledExecutor()");
            scheduledExecutorService = scheduledExecutorService2;
        }
        this(session, sessionStorage, bl, l, scheduledExecutorService);
    }

    public SessionProvider() {
        this(null, null, false, 0L, null, 31, null);
    }

    @Nullable
    public static final /* synthetic */ SessionStorage access$getSessionStorage$p(SessionProvider $this) {
        return $this.sessionStorage;
    }

    @NotNull
    public static final /* synthetic */ ConcurrentHashMap access$getSessions$p(SessionProvider $this) {
        return $this.sessions;
    }
}

