/*
 * Decompiled with CFR 0.152.
 */
package mozilla.components.ui.autocomplete;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.Rect;
import android.os.Build;
import android.support.v7.widget.AppCompatEditText;
import android.text.Editable;
import android.text.NoCopySpan;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.style.BackgroundColorSpan;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputConnectionWrapper;
import android.view.inputmethod.InputMethodManager;
import android.widget.TextView;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mozilla.components.ui.autocomplete.InlineAutocompleteEditTextKt$sam$OnKeyListener$d565d400;
import mozilla.components.ui.autocomplete.R;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 b2\u00020\u0001:\u0003abcB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u00108\u001a\u00020\u0017H\u0002J\u0010\u00109\u001a\u00020\u001c2\u0006\u0010:\u001a\u00020;H\u0002J\b\u0010<\u001a\u00020\u0017H\u0002J\b\u0010=\u001a\u00020\u0017H\u0016J\u0010\u0010>\u001a\u00020\u00172\b\u0010?\u001a\u0004\u0018\u00010\u000fJ\u0012\u0010@\u001a\u0004\u0018\u00010A2\u0006\u0010B\u001a\u00020CH\u0016J\"\u0010D\u001a\u00020\u00172\u0006\u0010E\u001a\u00020\u001c2\u0006\u0010F\u001a\u00020\b2\b\u0010G\u001a\u0004\u0018\u00010HH\u0016J\u0018\u0010*\u001a\u00020\u001c2\u0006\u0010I\u001a\u00020\b2\u0006\u0010J\u001a\u00020$H\u0016J\u0018\u0010+\u001a\u00020\u00172\u0006\u0010K\u001a\u00020\b2\u0006\u0010L\u001a\u00020\bH\u0016J\u0010\u0010M\u001a\u00020\u001c2\u0006\u0010J\u001a\u00020NH\u0016J\u0010\u0010O\u001a\u00020\u00172\u0006\u0010P\u001a\u00020\u001cH\u0016J\u0010\u0010Q\u001a\u00020\u001c2\u0006\u0010:\u001a\u00020;H\u0002J\b\u0010R\u001a\u00020\u0017H\u0002J\u0010\u0010S\u001a\u00020\u00172\u0006\u0010J\u001a\u00020TH\u0016J\u0018\u0010U\u001a\u00020\u00172\u0010\u0010V\u001a\f\u0012\u0004\u0012\u00020\u00170\u0016j\u0002`\u0018J&\u0010W\u001a\u00020\u00172\u001e\u0010V\u001a\u001a\u0012\u0004\u0012\u00020\u001f\u0012\u0006\u0012\u0004\u0018\u00010\u0000\u0012\u0004\u0012\u00020\u00170\u001ej\u0002` J*\u0010X\u001a\u00020\u00172\"\u0010V\u001a\u001e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u001c0\"j\u0002`%J\u001e\u0010Y\u001a\u00020\u00172\u0016\u0010V\u001a\u0012\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00170/j\u0002`0J$\u0010Z\u001a\u00020\u00172\u001c\u0010V\u001a\u0018\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00170\u001ej\u0002`2J$\u0010[\u001a\u00020\u00172\u001c\u0010V\u001a\u0018\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00170\u001ej\u0002`5J\u001e\u0010\\\u001a\u00020\u00172\u0016\u0010V\u001a\u0012\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00170/j\u0002`7J\u001a\u0010]\u001a\u00020\u00172\b\u0010:\u001a\u0004\u0018\u00010^2\u0006\u0010_\u001a\u00020`H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR$\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016j\u0004\u0018\u0001`\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u001d\u001a\u001e\u0012\u0004\u0012\u00020\u001f\u0012\u0006\u0012\u0004\u0018\u00010\u0000\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u001ej\u0004\u0018\u0001` X\u0082\u000e\u00a2\u0006\u0002\n\u0000R.\u0010!\u001a\"\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u001c\u0018\u00010\"j\u0004\u0018\u0001`%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010&\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R&\u0010)\u001a\u001a\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u001c0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010*\u001a\u001a\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u001c0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010+\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00170\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010,\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010(R\"\u0010.\u001a\u0016\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u0017\u0018\u00010/j\u0004\u0018\u0001`0X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u00101\u001a\u001c\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u001ej\u0004\u0018\u0001`2X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u00104\u001a\u001c\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u001ej\u0004\u0018\u0001`5X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u00106\u001a\u0016\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u0017\u0018\u00010/j\u0004\u0018\u0001`7X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006d"}, d2={"Lmozilla/components/ui/autocomplete/InlineAutocompleteEditText;", "Landroid/support/v7/widget/AppCompatEditText;", "ctx", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "autoCompleteBackgroundColor", "", "autoCompletePrefixLength", "autoCompleteSpans", "", "", "[Ljava/lang/Object;", "<set-?>", "Lmozilla/components/ui/autocomplete/InlineAutocompleteEditText$AutocompleteResult;", "autocompleteResult", "getAutocompleteResult", "()Lmozilla/components/ui/autocomplete/InlineAutocompleteEditText$AutocompleteResult;", "setAutocompleteResult", "(Lmozilla/components/ui/autocomplete/InlineAutocompleteEditText$AutocompleteResult;)V", "commitListener", "Lkotlin/Function0;", "", "Lmozilla/components/ui/autocomplete/OnCommitListener;", "getCtx", "()Landroid/content/Context;", "discardAutoCompleteResult", "", "filterListener", "Lkotlin/Function2;", "", "Lmozilla/components/ui/autocomplete/OnFilterListener;", "keyPreImeListener", "Lkotlin/Function3;", "Landroid/view/View;", "Landroid/view/KeyEvent;", "Lmozilla/components/ui/autocomplete/OnKeyPreImeListener;", "nonAutocompleteText", "getNonAutocompleteText", "()Ljava/lang/String;", "onKey", "onKeyPreIme", "onSelectionChanged", "originalText", "getOriginalText", "searchStateChangeListener", "Lkotlin/Function1;", "Lmozilla/components/ui/autocomplete/OnSearchStateChangeListener;", "selectionChangedListener", "Lmozilla/components/ui/autocomplete/OnSelectionChangedListener;", "settingAutoComplete", "textChangeListener", "Lmozilla/components/ui/autocomplete/OnTextChangeListener;", "windowFocusChangeListener", "Lmozilla/components/ui/autocomplete/OnWindowsFocusChangeListener;", "beginSettingAutocomplete", "commitAutocomplete", "text", "Landroid/text/Editable;", "endSettingAutocomplete", "onAttachedToWindow", "onAutocomplete", "result", "onCreateInputConnection", "Landroid/view/inputmethod/InputConnection;", "outAttrs", "Landroid/view/inputmethod/EditorInfo;", "onFocusChanged", "gainFocus", "direction", "previouslyFocusedRect", "Landroid/graphics/Rect;", "keyCode", "event", "selStart", "selEnd", "onTouchEvent", "Landroid/view/MotionEvent;", "onWindowFocusChanged", "hasFocus", "removeAutocomplete", "resetAutocompleteState", "sendAccessibilityEventUnchecked", "Landroid/view/accessibility/AccessibilityEvent;", "setOnCommitListener", "l", "setOnFilterListener", "setOnKeyPreImeListener", "setOnSearchStateChangeListener", "setOnSelectionChangedListener", "setOnTextChangeListener", "setOnWindowsFocusChangeListener", "setText", "", "type", "Landroid/widget/TextView$BufferType;", "AutocompleteResult", "Companion", "TextChangeListener", "autocomplete_release"})
public class InlineAutocompleteEditText
extends AppCompatEditText {
    private Function0<Unit> commitListener;
    private Function2<? super String, ? super InlineAutocompleteEditText, Unit> filterListener;
    private Function1<? super Boolean, Unit> searchStateChangeListener;
    private Function2<? super String, ? super String, Unit> textChangeListener;
    private Function3<? super View, ? super Integer, ? super KeyEvent, Boolean> keyPreImeListener;
    private Function2<? super Integer, ? super Integer, Unit> selectionChangedListener;
    private Function1<? super Boolean, Unit> windowFocusChangeListener;
    @NotNull
    private AutocompleteResult autocompleteResult;
    private int autoCompletePrefixLength;
    private boolean settingAutoComplete;
    private Object[] autoCompleteSpans;
    private boolean discardAutoCompleteResult;
    private final int autoCompleteBackgroundColor;
    private final Function3<View, Integer, KeyEvent, Boolean> onKeyPreIme;
    private final Function3<View, Integer, KeyEvent, Boolean> onKey;
    private final Function2<Integer, Integer, Unit> onSelectionChanged;
    @NotNull
    private final Context ctx;
    @NotNull
    private static final NoCopySpan.Concrete AUTOCOMPLETE_SPAN;
    private static final int DEFAULT_AUTOCOMPLETE_BACKGROUND_COLOR;
    public static final Companion Companion;

    public final void setOnCommitListener(@NotNull Function0<Unit> l) {
        Intrinsics.checkParameterIsNotNull(l, (String)"l");
        this.commitListener = l;
    }

    public final void setOnFilterListener(@NotNull Function2<? super String, ? super InlineAutocompleteEditText, Unit> l) {
        Intrinsics.checkParameterIsNotNull(l, (String)"l");
        this.filterListener = l;
    }

    public final void setOnSearchStateChangeListener(@NotNull Function1<? super Boolean, Unit> l) {
        Intrinsics.checkParameterIsNotNull(l, (String)"l");
        this.searchStateChangeListener = l;
    }

    public final void setOnTextChangeListener(@NotNull Function2<? super String, ? super String, Unit> l) {
        Intrinsics.checkParameterIsNotNull(l, (String)"l");
        this.textChangeListener = l;
    }

    public final void setOnKeyPreImeListener(@NotNull Function3<? super View, ? super Integer, ? super KeyEvent, Boolean> l) {
        Intrinsics.checkParameterIsNotNull(l, (String)"l");
        this.keyPreImeListener = l;
    }

    public final void setOnSelectionChangedListener(@NotNull Function2<? super Integer, ? super Integer, Unit> l) {
        Intrinsics.checkParameterIsNotNull(l, (String)"l");
        this.selectionChangedListener = l;
    }

    public final void setOnWindowsFocusChangeListener(@NotNull Function1<? super Boolean, Unit> l) {
        Intrinsics.checkParameterIsNotNull(l, (String)"l");
        this.windowFocusChangeListener = l;
    }

    @NotNull
    public final AutocompleteResult getAutocompleteResult() {
        return this.autocompleteResult;
    }

    private final void setAutocompleteResult(AutocompleteResult autocompleteResult) {
        this.autocompleteResult = autocompleteResult;
    }

    @NotNull
    public final String getNonAutocompleteText() {
        Editable editable = this.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)editable, (String)"text");
        return InlineAutocompleteEditText.Companion.getNonAutocompleteText(editable);
    }

    @NotNull
    public final String getOriginalText() {
        return ((Object)this.getText().subSequence(0, this.autoCompletePrefixLength)).toString();
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.keyPreImeListener = this.onKeyPreIme;
        this.selectionChangedListener = this.onSelectionChanged;
        Object object = this.onKey;
        if (object != null) {
            Function3<View, Integer, KeyEvent, Boolean> function3 = object;
            object = new InlineAutocompleteEditTextKt$sam$OnKeyListener$d565d400(function3);
        }
        this.setOnKeyListener((View.OnKeyListener)object);
        this.addTextChangedListener(new TextChangeListener());
    }

    public void onFocusChanged(boolean gainFocus, int direction, @Nullable Rect previouslyFocusedRect) {
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
        boolean isActive = !TextUtils.isEmpty((CharSequence)((CharSequence)this.getText()));
        Function1<? super Boolean, Unit> function1 = this.searchStateChangeListener;
        if (function1 != null) {
            Unit cfr_ignored_0 = (Unit)function1.invoke((Object)isActive);
        }
        if (gainFocus) {
            this.resetAutocompleteState();
            return;
        }
        Editable editable = this.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)editable, (String)"text");
        this.removeAutocomplete(editable);
        Object object = this.ctx.getSystemService("input_method");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
        }
        InputMethodManager imm = (InputMethodManager)object;
        try {
            imm.restartInput((View)this);
            imm.hideSoftInputFromWindow(this.getWindowToken(), 0);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setText(@Nullable CharSequence text, @NotNull TextView.BufferType type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        CharSequence charSequence = text;
        if (charSequence == null || (charSequence = ((Object)charSequence).toString()) == null) {
            charSequence = "";
        }
        CharSequence textString = charSequence;
        super.setText(textString, type);
        this.resetAutocompleteState();
    }

    public void sendAccessibilityEventUnchecked(@NotNull AccessibilityEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (event.getEventType() == 8192 && this.getParent() != null && !this.isShown()) {
            this.onInitializeAccessibilityEvent(event);
            this.dispatchPopulateAccessibilityEvent(event);
            this.getParent().requestSendAccessibilityEvent((View)this, event);
        } else {
            super.sendAccessibilityEventUnchecked(event);
        }
    }

    private final void beginSettingAutocomplete() {
        this.beginBatchEdit();
        this.settingAutoComplete = true;
    }

    private final void endSettingAutocomplete() {
        this.settingAutoComplete = false;
        this.endBatchEdit();
    }

    private final void resetAutocompleteState() {
        this.autoCompleteSpans = new Object[]{Companion.getAUTOCOMPLETE_SPAN(), new BackgroundColorSpan(this.autoCompleteBackgroundColor)};
        this.autocompleteResult = AutocompleteResult.Companion.emptyResult();
        this.autoCompletePrefixLength = this.getText().length();
        this.setCursorVisible(true);
    }

    private final boolean removeAutocomplete(Editable text) {
        int start = text.getSpanStart((Object)Companion.getAUTOCOMPLETE_SPAN());
        if (start < 0) {
            return false;
        }
        this.beginSettingAutocomplete();
        text.delete(start, text.length());
        this.autocompleteResult = AutocompleteResult.Companion.emptyResult();
        this.setCursorVisible(true);
        this.endSettingAutocomplete();
        return true;
    }

    private final boolean commitAutocomplete(Editable text) {
        block3: {
            int start = text.getSpanStart((Object)Companion.getAUTOCOMPLETE_SPAN());
            if (start < 0) {
                return false;
            }
            this.beginSettingAutocomplete();
            if (this.autoCompleteSpans == null) {
                Intrinsics.throwNpe();
            }
            for (Object span : this.autoCompleteSpans) {
                text.removeSpan(span);
            }
            this.autoCompletePrefixLength = text.length();
            this.setCursorVisible(true);
            this.endSettingAutocomplete();
            Function2<? super String, ? super InlineAutocompleteEditText, Unit> function2 = this.filterListener;
            if (function2 == null) break block3;
            Unit cfr_ignored_0 = (Unit)function2.invoke((Object)text.toString(), null);
        }
        return true;
    }

    public final void onAutocomplete(@Nullable AutocompleteResult result) {
        if (this.discardAutoCompleteResult) {
            return;
        }
        if (!this.isEnabled() || result == null || result.isEmpty()) {
            this.autocompleteResult = AutocompleteResult.Companion.emptyResult();
            return;
        }
        Editable text = this.getText();
        int textLength = text.length();
        int resultLength = result.getLength();
        int autoCompleteStart = text.getSpanStart((Object)Companion.getAUTOCOMPLETE_SPAN());
        this.autocompleteResult = result;
        if (autoCompleteStart > -1) {
            if (!TextUtils.regionMatches((CharSequence)result.getText(), (int)0, (CharSequence)((CharSequence)text), (int)0, (int)autoCompleteStart)) {
                return;
            }
            this.beginSettingAutocomplete();
            text.replace(autoCompleteStart, textLength, (CharSequence)result.getText(), autoCompleteStart, resultLength);
            if (autoCompleteStart == resultLength) {
                this.setCursorVisible(true);
            }
            this.endSettingAutocomplete();
        } else {
            int i;
            if (resultLength <= textLength || !TextUtils.regionMatches((CharSequence)result.getText(), (int)0, (CharSequence)((CharSequence)text), (int)0, (int)textLength)) {
                return;
            }
            Object[] spans = text.getSpans(textLength, textLength, Object.class);
            int[] spanStarts = new int[spans.length];
            int[] spanEnds = new int[spans.length];
            int[] spanFlags = new int[spans.length];
            int n = 0;
            Intrinsics.checkExpressionValueIsNotNull((Object)spans, (String)"spans");
            int n2 = spans.length;
            while (n < n2) {
                Object span = spans[i];
                int spanFlag = text.getSpanFlags(span);
                if ((spanFlag & 0x100) != 0 || span == Selection.SELECTION_START || span == Selection.SELECTION_END) {
                    spanStarts[i] = text.getSpanStart(span);
                    spanEnds[i] = text.getSpanEnd(span);
                    spanFlags[i] = spanFlag;
                }
                ++i;
            }
            this.beginSettingAutocomplete();
            text.append((CharSequence)result.getText(), textLength, resultLength);
            n2 = spans.length;
            for (i = 0; i < n2; ++i) {
                int spanFlag = spanFlags[i];
                if (spanFlag == 0) continue;
                text.setSpan(spans[i], spanStarts[i], spanEnds[i], spanFlag);
            }
            if (this.autoCompleteSpans == null) {
                Intrinsics.throwNpe();
            }
            for (Object span : this.autoCompleteSpans) {
                text.setSpan(span, textLength, resultLength, 33);
            }
            this.setCursorVisible(false);
            this.bringPointIntoView(resultLength);
            this.endSettingAutocomplete();
        }
        this.announceForAccessibility(text.toString());
    }

    @Nullable
    public InputConnection onCreateInputConnection(@NotNull EditorInfo outAttrs) {
        Intrinsics.checkParameterIsNotNull((Object)outAttrs, (String)"outAttrs");
        InputConnection inputConnection = super.onCreateInputConnection(outAttrs);
        if (inputConnection == null) {
            return null;
        }
        InputConnection ic = inputConnection;
        return (InputConnection)new InputConnectionWrapper(this, ic, ic, false){
            final /* synthetic */ InlineAutocompleteEditText this$0;
            final /* synthetic */ InputConnection $ic;

            public boolean deleteSurroundingText(int beforeLength, int afterLength) {
                Editable editable = this.this$0.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)editable, (String)"text");
                if (InlineAutocompleteEditText.access$removeAutocomplete(this.this$0, editable)) {
                    Object object = this.this$0.getCtx().getSystemService("input_method");
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
                    }
                    InputMethodManager imm = (InputMethodManager)object;
                    imm.restartInput((View)this.this$0);
                    return false;
                }
                return super.deleteSurroundingText(beforeLength, afterLength);
            }

            private final boolean removeAutocompleteOnComposing(CharSequence text) {
                Editable editable = this.this$0.getText();
                int composingStart = BaseInputConnection.getComposingSpanStart((Spannable)((Spannable)editable));
                int composingEnd = BaseInputConnection.getComposingSpanEnd((Spannable)((Spannable)editable));
                if (composingStart >= 0 && composingEnd >= 0 && composingEnd - composingStart > text.length()) {
                    Editable editable2 = editable;
                    Intrinsics.checkExpressionValueIsNotNull((Object)editable2, (String)"editable");
                    if (InlineAutocompleteEditText.access$removeAutocomplete(this.this$0, editable2)) {
                        this.finishComposingText();
                        this.setComposingRegion(composingStart, composingEnd);
                        return true;
                    }
                }
                return false;
            }

            public boolean commitText(@NotNull CharSequence text, int newCursorPosition) {
                Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                return this.removeAutocompleteOnComposing(text) ? false : super.commitText(text, newCursorPosition);
            }

            public boolean setComposingText(@NotNull CharSequence text, int newCursorPosition) {
                Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                return this.removeAutocompleteOnComposing(text) ? false : super.setComposingText(text, newCursorPosition);
            }
            {
                this.this$0 = $outer;
                this.$ic = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3);
            }
        };
    }

    public boolean onKeyPreIme(int keyCode, @NotNull KeyEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Object object = this.keyPreImeListener;
        return object != null && (object = (Boolean)object.invoke((Object)this, (Object)keyCode, (Object)event)) != null ? (Boolean)object : false;
    }

    public void onSelectionChanged(int selStart, int selEnd) {
        Function2<? super Integer, ? super Integer, Unit> function2 = this.selectionChangedListener;
        if (function2 != null) {
            Unit cfr_ignored_0 = (Unit)function2.invoke((Object)selStart, (Object)selEnd);
        }
        super.onSelectionChanged(selStart, selEnd);
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        block0: {
            super.onWindowFocusChanged(hasFocus);
            Function1<? super Boolean, Unit> function1 = this.windowFocusChangeListener;
            if (function1 == null) break block0;
            Unit cfr_ignored_0 = (Unit)function1.invoke((Object)hasFocus);
        }
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (Build.VERSION.SDK_INT == 23 && event.getActionMasked() == 1) {
            boolean bl2;
            try {
                bl2 = super.onTouchEvent(event);
            }
            catch (NullPointerException ignored) {
                this.clearFocus();
                bl2 = true;
            }
            bl = bl2;
        } else {
            bl = super.onTouchEvent(event);
        }
        return bl;
    }

    @NotNull
    public final Context getCtx() {
        return this.ctx;
    }

    public InlineAutocompleteEditText(@NotNull Context ctx, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(ctx, attrs);
        this.ctx = ctx;
        this.autocompleteResult = AutocompleteResult.Companion.emptyResult();
        this.autoCompleteBackgroundColor = ((Number)((Function0)new Function0<Integer>(this, attrs){
            final /* synthetic */ InlineAutocompleteEditText this$0;
            final /* synthetic */ AttributeSet $attrs;

            /*
             * WARNING - void declaration
             */
            public final int invoke() {
                void var2_2;
                TypedArray a = this.this$0.getContext().obtainStyledAttributes(this.$attrs, R.styleable.InlineAutocompleteEditText);
                int color = a.getColor(R.styleable.InlineAutocompleteEditText_autocompleteBackgroundColor, InlineAutocompleteEditText.Companion.getDEFAULT_AUTOCOMPLETE_BACKGROUND_COLOR());
                a.recycle();
                return (int)var2_2;
            }
            {
                this.this$0 = inlineAutocompleteEditText;
                this.$attrs = attributeSet;
                super(0);
            }
        }).invoke()).intValue();
        this.onKeyPreIme = (Function3)new Function3<View, Integer, KeyEvent, Boolean>(this){
            final /* synthetic */ InlineAutocompleteEditText this$0;

            public final boolean invoke(@NotNull View $noName_0, int keyCode, @NotNull KeyEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                if (event.getAction() != 0) {
                    return false;
                }
                if (keyCode == 66) {
                    Editable content;
                    Editable editable = content = this.this$0.getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)editable, (String)"content");
                    if (!mozilla.components.ui.autocomplete.InlineAutocompleteEditText$Companion.access$hasCompositionString(InlineAutocompleteEditText.Companion, editable)) {
                        Function0 function0 = InlineAutocompleteEditText.access$getCommitListener$p(this.this$0);
                        if (function0 != null) {
                            Unit cfr_ignored_0 = (Unit)function0.invoke();
                        }
                        return true;
                    }
                }
                if (keyCode == 4) {
                    Editable editable = this.this$0.getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)editable, (String)"text");
                    InlineAutocompleteEditText.access$removeAutocomplete(this.this$0, editable);
                    return false;
                }
                return false;
            }
            {
                this.this$0 = inlineAutocompleteEditText;
                super(3);
            }
        };
        this.onKey = (Function3)new Function3<View, Integer, KeyEvent, Boolean>(this){
            final /* synthetic */ InlineAutocompleteEditText this$0;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean invoke(@NotNull View $noName_0, int keyCode, @NotNull KeyEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                if (keyCode == 66) {
                    if (event.getAction() != 0) {
                        return true;
                    }
                    Function0 function0 = InlineAutocompleteEditText.access$getCommitListener$p(this.this$0);
                    if (function0 == null) return true;
                    Unit cfr_ignored_0 = (Unit)function0.invoke();
                    return true;
                }
                if (keyCode != 67) {
                    if (keyCode != 112) return false;
                }
                Editable editable = this.this$0.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)editable, (String)"text");
                if (!InlineAutocompleteEditText.access$removeAutocomplete(this.this$0, editable)) return false;
                return true;
            }
            {
                this.this$0 = inlineAutocompleteEditText;
                super(3);
            }
        };
        this.onSelectionChanged = (Function2)new Function2<Integer, Integer, Unit>(this){
            final /* synthetic */ InlineAutocompleteEditText this$0;

            public final void invoke(int selStart, int selEnd) {
                Editable text = this.this$0.getText();
                int start = text.getSpanStart((Object)InlineAutocompleteEditText.Companion.getAUTOCOMPLETE_SPAN());
                if (InlineAutocompleteEditText.access$getSettingAutoComplete$p(this.this$0) || start < 0 || start == selStart && start == selEnd) {
                    return;
                }
                if (selStart <= start && selEnd <= start) {
                    Editable editable = text;
                    Intrinsics.checkExpressionValueIsNotNull((Object)editable, (String)"text");
                    InlineAutocompleteEditText.access$removeAutocomplete(this.this$0, editable);
                } else {
                    Editable editable = text;
                    Intrinsics.checkExpressionValueIsNotNull((Object)editable, (String)"text");
                    InlineAutocompleteEditText.access$commitAutocomplete(this.this$0, editable);
                }
            }
            {
                this.this$0 = inlineAutocompleteEditText;
                super(2);
            }
        };
    }

    static {
        Companion = new Companion(null);
        AUTOCOMPLETE_SPAN = new NoCopySpan.Concrete();
        DEFAULT_AUTOCOMPLETE_BACKGROUND_COLOR = Color.parseColor((String)"#ffb5007f");
    }

    public static final /* synthetic */ void access$setSettingAutoComplete$p(InlineAutocompleteEditText $this, boolean bl) {
        $this.settingAutoComplete = bl;
    }

    public static final /* synthetic */ int access$getAutoCompletePrefixLength$p(InlineAutocompleteEditText $this) {
        return $this.autoCompletePrefixLength;
    }

    public static final /* synthetic */ boolean access$getDiscardAutoCompleteResult$p(InlineAutocompleteEditText $this) {
        return $this.discardAutoCompleteResult;
    }

    @NotNull
    public static final /* synthetic */ AutocompleteResult access$getAutocompleteResult$p(InlineAutocompleteEditText $this) {
        return $this.autocompleteResult;
    }

    public static final /* synthetic */ void access$setAutocompleteResult$p(InlineAutocompleteEditText $this, @NotNull AutocompleteResult autocompleteResult) {
        $this.autocompleteResult = autocompleteResult;
    }

    public static final /* synthetic */ void access$setSearchStateChangeListener$p(InlineAutocompleteEditText $this, @Nullable Function1 function1) {
        $this.searchStateChangeListener = function1;
    }

    public static final /* synthetic */ void access$setFilterListener$p(InlineAutocompleteEditText $this, @Nullable Function2 function2) {
        $this.filterListener = function2;
    }

    public static final /* synthetic */ void access$setTextChangeListener$p(InlineAutocompleteEditText $this, @Nullable Function2 function2) {
        $this.textChangeListener = function2;
    }

    @Nullable
    public static final /* synthetic */ Function0 access$getCommitListener$p(InlineAutocompleteEditText $this) {
        return $this.commitListener;
    }

    public static final /* synthetic */ void access$setCommitListener$p(InlineAutocompleteEditText $this, @Nullable Function0 function0) {
        $this.commitListener = function0;
    }

    public static final /* synthetic */ boolean access$commitAutocomplete(InlineAutocompleteEditText $this, @NotNull Editable text) {
        return $this.commitAutocomplete(text);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0013\b\u0086\b\u0018\u0000 !2\u00020\u0001:\u0001!B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u001c\b\u0002\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\bj\u0004\u0018\u0001`\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0006H\u00c6\u0003J\u001d\u0010\u001a\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\bj\u0004\u0018\u0001`\tH\u00c2\u0003JE\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u001c\b\u0002\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\bj\u0004\u0018\u0001`\tH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u000f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u0006H\u00d6\u0001J\u000e\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u000b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\"\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\bj\u0004\u0018\u0001`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013\u00a8\u0006\""}, d2={"Lmozilla/components/ui/autocomplete/InlineAutocompleteEditText$AutocompleteResult;", "", "text", "", "source", "totalItems", "", "textFormatter", "Lkotlin/Function1;", "Lmozilla/components/ui/autocomplete/TextFormatter;", "(Ljava/lang/String;Ljava/lang/String;ILkotlin/jvm/functions/Function1;)V", "formattedText", "getFormattedText", "()Ljava/lang/String;", "isEmpty", "", "()Z", "length", "getLength", "()I", "getSource", "getText", "getTotalItems", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "startsWith", "toString", "Companion", "autocomplete_release"})
    public static final class AutocompleteResult {
        private final boolean isEmpty;
        private final int length;
        @NotNull
        private final String text;
        @NotNull
        private final String source;
        private final int totalItems;
        private final Function1<String, String> textFormatter;
        public static final Companion Companion = new Companion(null);

        public final boolean isEmpty() {
            return this.isEmpty;
        }

        public final int getLength() {
            return this.length;
        }

        @NotNull
        public final String getFormattedText() {
            Object object = this.textFormatter;
            if (object == null || (object = (String)object.invoke((Object)this.text)) == null) {
                object = this.text;
            }
            return object;
        }

        public final boolean startsWith(@NotNull String text) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            return StringsKt.startsWith$default((String)this.text, (String)text, (boolean)false, (int)2, null);
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final String getSource() {
            return this.source;
        }

        public final int getTotalItems() {
            return this.totalItems;
        }

        public AutocompleteResult(@NotNull String text, @NotNull String source, int totalItems, @Nullable Function1<? super String, String> textFormatter) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            this.text = text;
            this.source = source;
            this.totalItems = totalItems;
            this.textFormatter = textFormatter;
            CharSequence charSequence = this.text;
            AutocompleteResult autocompleteResult = this;
            autocompleteResult.isEmpty = bl = charSequence.length() == 0;
            this.length = this.text.length();
        }

        public /* synthetic */ AutocompleteResult(String string, String string2, int n, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                function1 = null;
            }
            this(string, string2, n, (Function1<? super String, String>)function1);
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        @NotNull
        public final String component2() {
            return this.source;
        }

        public final int component3() {
            return this.totalItems;
        }

        private final Function1<String, String> component4() {
            return this.textFormatter;
        }

        @NotNull
        public final AutocompleteResult copy(@NotNull String text, @NotNull String source, int totalItems, @Nullable Function1<? super String, String> textFormatter) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            return new AutocompleteResult(text, source, totalItems, textFormatter);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ AutocompleteResult copy$default(AutocompleteResult autocompleteResult, String string, String string2, int n, Function1 function1, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = autocompleteResult.text;
            }
            if ((n2 & 2) != 0) {
                string2 = autocompleteResult.source;
            }
            if ((n2 & 4) != 0) {
                n = autocompleteResult.totalItems;
            }
            if ((n2 & 8) != 0) {
                function1 = autocompleteResult.textFormatter;
            }
            return autocompleteResult.copy(string, string2, n, function1);
        }

        public String toString() {
            return "AutocompleteResult(text=" + this.text + ", source=" + this.source + ", totalItems=" + this.totalItems + ", textFormatter=" + this.textFormatter + ")";
        }

        public int hashCode() {
            String string = this.text;
            String string2 = this.source;
            Function1<String, String> function1 = this.textFormatter;
            return (((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + this.totalItems) * 31 + (function1 != null ? function1.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof AutocompleteResult)) break block3;
                    AutocompleteResult autocompleteResult = (AutocompleteResult)object;
                    if (!Intrinsics.areEqual((Object)this.text, (Object)autocompleteResult.text) || !Intrinsics.areEqual((Object)this.source, (Object)autocompleteResult.source) || !(this.totalItems == autocompleteResult.totalItems) || !Intrinsics.areEqual(this.textFormatter, autocompleteResult.textFormatter)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lmozilla/components/ui/autocomplete/InlineAutocompleteEditText$AutocompleteResult$Companion;", "", "()V", "emptyResult", "Lmozilla/components/ui/autocomplete/InlineAutocompleteEditText$AutocompleteResult;", "autocomplete_release"})
        public static final class Companion {
            @NotNull
            public final AutocompleteResult emptyResult() {
                return new AutocompleteResult("", "", 0, null, 8, null);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J(\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J(\u0010\u000f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lmozilla/components/ui/autocomplete/InlineAutocompleteEditText$TextChangeListener;", "Landroid/text/TextWatcher;", "(Lmozilla/components/ui/autocomplete/InlineAutocompleteEditText;)V", "textLengthBeforeChange", "", "afterTextChanged", "", "editable", "Landroid/text/Editable;", "beforeTextChanged", "s", "", "start", "count", "after", "onTextChanged", "before", "autocomplete_release"})
    private final class TextChangeListener
    implements TextWatcher {
        private int textLengthBeforeChange;

        public void afterTextChanged(@NotNull Editable editable) {
            block8: {
                Intrinsics.checkParameterIsNotNull((Object)editable, (String)"editable");
                if (!InlineAutocompleteEditText.this.isEnabled() || InlineAutocompleteEditText.this.settingAutoComplete) {
                    return;
                }
                String text = Companion.getNonAutocompleteText(editable);
                int textLength = text.length();
                boolean doAutocomplete = true;
                if (StringsKt.contains$default((CharSequence)text, (CharSequence)" ", (boolean)false, (int)2, null)) {
                    doAutocomplete = false;
                } else if (textLength == this.textLengthBeforeChange - 1 || textLength == 0) {
                    doAutocomplete = false;
                }
                InlineAutocompleteEditText.this.autoCompletePrefixLength = textLength;
                InlineAutocompleteEditText.this.discardAutoCompleteResult = !doAutocomplete;
                if (doAutocomplete && InlineAutocompleteEditText.this.getAutocompleteResult().startsWith(text)) {
                    InlineAutocompleteEditText.this.onAutocomplete(InlineAutocompleteEditText.this.getAutocompleteResult());
                    doAutocomplete = false;
                } else {
                    InlineAutocompleteEditText.this.removeAutocomplete(editable);
                }
                Function1 function1 = InlineAutocompleteEditText.this.searchStateChangeListener;
                if (function1 != null) {
                    Unit cfr_ignored_0 = (Unit)function1.invoke((Object)(textLength > 0 ? 1 : 0));
                }
                Function2 function2 = InlineAutocompleteEditText.this.filterListener;
                if (function2 != null) {
                    Unit cfr_ignored_1 = (Unit)function2.invoke((Object)text, (Object)(doAutocomplete ? InlineAutocompleteEditText.this : null));
                }
                Function2 function22 = InlineAutocompleteEditText.this.textChangeListener;
                if (function22 == null) break block8;
                Unit cfr_ignored_2 = (Unit)function22.invoke((Object)text, (Object)InlineAutocompleteEditText.this.getText().toString());
            }
        }

        public void beforeTextChanged(@NotNull CharSequence s, int start, int count, int after) {
            Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
            this.textLengthBeforeChange = s.length();
        }

        public void onTextChanged(@NotNull CharSequence s, int start, int before, int count) {
            Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lmozilla/components/ui/autocomplete/InlineAutocompleteEditText$Companion;", "", "()V", "AUTOCOMPLETE_SPAN", "Landroid/text/NoCopySpan$Concrete;", "getAUTOCOMPLETE_SPAN", "()Landroid/text/NoCopySpan$Concrete;", "DEFAULT_AUTOCOMPLETE_BACKGROUND_COLOR", "", "getDEFAULT_AUTOCOMPLETE_BACKGROUND_COLOR", "()I", "getNonAutocompleteText", "", "text", "Landroid/text/Editable;", "hasCompositionString", "", "content", "autocomplete_release"})
    public static final class Companion {
        @NotNull
        public final NoCopySpan.Concrete getAUTOCOMPLETE_SPAN() {
            return AUTOCOMPLETE_SPAN;
        }

        public final int getDEFAULT_AUTOCOMPLETE_BACKGROUND_COLOR() {
            return DEFAULT_AUTOCOMPLETE_BACKGROUND_COLOR;
        }

        private final String getNonAutocompleteText(Editable text) {
            String string;
            int start = text.getSpanStart((Object)this.getAUTOCOMPLETE_SPAN());
            if (start < 0) {
                string = text.toString();
            } else {
                String string2 = TextUtils.substring((CharSequence)((CharSequence)text), (int)0, (int)start);
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"TextUtils.substring(text, 0, start)");
            }
            return string;
        }

        private final boolean hasCompositionString(Editable content) {
            boolean bl;
            block1: {
                Object[] spans = content.getSpans(0, content.length(), Object.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)spans, (String)"spans");
                for (Object element$iv : spans) {
                    Object span = element$iv;
                    if (!((content.getSpanFlags(span) & 0x100) != 0)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$hasCompositionString(Companion $this, @NotNull Editable content) {
            return $this.hasCompositionString(content);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

