/*
 * Decompiled with CFR 0.152.
 */
package mousio.client.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

public final class SRV2URIs {
    public static URI[] fromService(String service) throws NamingException {
        return SRV2URIs.fromDNSName("_etcd-server._tcp." + service);
    }

    public static URI[] fromDNSName(String srvName) throws NamingException {
        ArrayList<URI> uris = new ArrayList<URI>();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        env.put("java.naming.provider.url", "dns:");
        InitialDirContext ctx = new InitialDirContext(env);
        Attributes attributes = ctx.getAttributes(srvName, new String[]{"SRV"});
        NamingEnumeration<? extends Attribute> records = attributes.getAll();
        while (records.hasMore()) {
            Attribute next = records.next();
            NamingEnumeration<?> values = next.getAll();
            while (values.hasMore()) {
                String dns = (String)values.next();
                String[] split = dns.split(" ");
                String port = split[2];
                String host = split[3];
                if (host.endsWith(".")) {
                    host = host.substring(0, host.length() - 1);
                }
                URI uri = URI.create("http://" + host + ":" + port);
                uris.add(uri);
            }
        }
        return uris.toArray(new URI[uris.size()]);
    }
}

