/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.maven.tckextract;

import com.github.javaparser.ParseResult;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.comments.CommentsCollection;
import com.github.javaparser.utils.SourceRoot;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="extract-tck-tests", defaultPhase=LifecyclePhase.PROCESS_SOURCES, requiresDependencyResolution=ResolutionScope.TEST)
public class ExtractTckTests
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    private static final String TEST_NAME_TAG = "@testName:";
    @Parameter(defaultValue="${project.build.directory}/tck-test.txt", required=true)
    private File tckTestsFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            Files.deleteIfExists(this.tckTestsFile.toPath());
            this.tckTestsFile.getParentFile().mkdirs();
            if (!this.tckTestsFile.exists()) {
                this.tckTestsFile.createNewFile();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        SourceRoot sourceRoot = new SourceRoot(Paths.get((String)this.project.getCompileSourceRoots().get(0), new String[0]));
        sourceRoot.getParserConfiguration().setLanguageLevel(ParserConfiguration.LanguageLevel.JAVA_11);
        try {
            List parseResults = sourceRoot.tryToParse("");
            for (ParseResult parseResult : parseResults) {
                if (parseResult.getCommentsCollection().isEmpty()) continue;
                List methodNames = ((CommentsCollection)parseResult.getCommentsCollection().get()).getBlockComments().stream().map(blockComment -> {
                    List methods = Arrays.asList(blockComment.getContent().split(System.lineSeparator())).stream().filter(s -> StringUtils.contains((CharSequence)s, (CharSequence)TEST_NAME_TAG)).map(s -> StringUtils.substringAfter((String)s, (String)TEST_NAME_TAG)).collect(Collectors.toList());
                    return methods.isEmpty() ? "" : (String)methods.get(0);
                }).collect(Collectors.toList());
                CompilationUnit cu = (CompilationUnit)parseResult.getResult().get();
                String fqcn = ((PackageDeclaration)cu.getPackageDeclaration().get()).getNameAsString() + "." + ((TypeDeclaration)cu.getPrimaryType().get()).getName();
                List classNameMethods = methodNames.stream().filter(s -> StringUtils.isNotEmpty((CharSequence)s)).map(s -> fqcn + "#" + StringUtils.trim((String)s)).collect(Collectors.toList());
                Files.write(this.tckTestsFile.toPath(), classNameMethods, StandardCharsets.UTF_8, StandardOpenOption.APPEND);
            }
            this.getLog().debug((CharSequence)"end");
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }
}

