/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.rhttp.server;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Servlet;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.mortbay.jetty.rhttp.server.ExternalServlet;
import org.mortbay.jetty.rhttp.server.Gateway;
import org.mortbay.jetty.rhttp.server.GatewayServlet;
import org.mortbay.jetty.rhttp.server.StandardGateway;
import org.mortbay.jetty.rhttp.server.StandardTargetIdRetriever;
import org.mortbay.jetty.rhttp.server.TargetIdRetriever;

public class GatewayServer {
    private final Logger logger = Log.getLogger((String)this.getClass().toString());
    private final List<Connector> connectors = new ArrayList<Connector>();
    private volatile Server server;
    private volatile String contextPath = "";
    private volatile String externalServletPath = "/gw";
    private volatile String gatewayServletPath = "/__rhttp";
    private volatile String resourcesPath = System.getProperty("java.io.tmpdir");
    private volatile String resourcesServletPath = "/__r";
    private volatile long gatewayTimeout = 20000L;
    private volatile long externalTimeout = 60000L;
    private volatile long clientTimeout = 15000L;
    private volatile TargetIdRetriever targetIdRetriever = new StandardTargetIdRetriever();
    private volatile Gateway gateway;

    public void addConnector(Connector connector) {
        this.connectors.add(connector);
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getExternalServletPath() {
        return this.externalServletPath;
    }

    public void setExternalServletPath(String externalServletPath) {
        this.externalServletPath = externalServletPath;
    }

    public String getGatewayServletPath() {
        return this.gatewayServletPath;
    }

    public void setGatewayServletPath(String gatewayServletPath) {
        this.gatewayServletPath = gatewayServletPath;
    }

    public String getResourcesPath() {
        return this.resourcesPath;
    }

    public void setResourcesPath(String resourcesPath) {
        this.resourcesPath = resourcesPath;
    }

    public String getResourcesServletPath() {
        return this.resourcesServletPath;
    }

    public void setResourcesServletPath(String resourcesServletPath) {
        this.resourcesServletPath = resourcesServletPath;
    }

    public long getGatewayTimeout() {
        return this.gatewayTimeout;
    }

    public void setGatewayTimeout(long gatewayTimeout) {
        this.gatewayTimeout = gatewayTimeout;
    }

    public long getExternalTimeout() {
        return this.externalTimeout;
    }

    public void setExternalTimeout(long externalTimeout) {
        this.externalTimeout = externalTimeout;
    }

    public long getClientTimeout() {
        return this.clientTimeout;
    }

    public void setClientTimeout(long clientTimeout) {
        this.clientTimeout = clientTimeout;
    }

    public TargetIdRetriever getTargetIdRetriever() {
        return this.targetIdRetriever;
    }

    public void setTargetIdRetriever(TargetIdRetriever targetIdRetriever) {
        this.targetIdRetriever = targetIdRetriever;
    }

    protected Gateway getGateway() {
        return this.gateway;
    }

    public void start() throws Exception {
        this.server = new Server();
        for (Connector connector : this.connectors) {
            this.server.addConnector(connector);
        }
        HandlerCollection handlers = new HandlerCollection();
        this.server.setHandler((Handler)handlers);
        ServletContextHandler servlets = new ServletContextHandler((HandlerContainer)handlers, this.contextPath, 1);
        MimeTypes mimeTypes = new MimeTypes();
        mimeTypes.addMimeMapping("jad", "text/vnd.sun.j2me.app-descriptor");
        servlets.setMimeTypes(mimeTypes);
        this.gateway = this.createGateway();
        ExternalServlet externalServlet = new ExternalServlet(this.gateway, this.targetIdRetriever);
        ServletHolder externalServletHolder = new ServletHolder((Servlet)externalServlet);
        servlets.addServlet(externalServletHolder, this.externalServletPath + "/*");
        this.logger.debug("External servlet mapped to {}/*", new Object[]{this.externalServletPath});
        GatewayServlet gatewayServlet = new GatewayServlet(this.gateway, this.clientTimeout);
        ServletHolder gatewayServletHolder = new ServletHolder((Servlet)gatewayServlet);
        servlets.addServlet(gatewayServletHolder, this.gatewayServletPath + "/*");
        this.logger.debug("Gateway servlet mapped to {}/*", new Object[]{this.gatewayServletPath});
        DefaultServlet resourcesServlet = new DefaultServlet();
        ServletHolder resourcesServletHolder = new ServletHolder((Servlet)resourcesServlet);
        resourcesServletHolder.setInitParameter("dirAllowed", "true");
        resourcesServletHolder.setInitParameter("resourceBase", this.resourcesPath);
        servlets.addServlet(resourcesServletHolder, this.resourcesServletPath + "/*");
        this.logger.debug("Resources servlet mapped to {}/*", new Object[]{this.resourcesServletPath});
        this.setupResourcesDirectory(this.resourcesServletPath);
        this.server.start();
        this.logger.info("{} started", new Object[]{this.getClass().getSimpleName()});
    }

    protected Gateway createGateway() {
        StandardGateway gateway = new StandardGateway();
        gateway.setGatewayTimeout(this.getGatewayTimeout());
        gateway.setExternalTimeout(this.getExternalTimeout());
        return gateway;
    }

    private void setupResourcesDirectory(String path) {
        File resourcesFile = new File(this.resourcesPath, path);
        if (resourcesFile.exists()) {
            if (!resourcesFile.isDirectory()) {
                this.logger.info("Resources path " + resourcesFile.getAbsolutePath() + ", not a directory", new Object[0]);
            } else if (!resourcesFile.canRead()) {
                this.logger.info("Resources path " + resourcesFile.getAbsolutePath() + ", no permission to read", new Object[0]);
            }
        } else {
            boolean created = resourcesFile.mkdirs();
            if (!created) {
                this.logger.info("Resources path " + resourcesFile.getAbsolutePath() + ", could not create it", new Object[0]);
            } else {
                this.logger.info("Resources path " + resourcesFile.getAbsolutePath() + ", created successfully", new Object[0]);
            }
        }
    }

    public void stop() throws Exception {
        this.server.stop();
        this.server.join();
        this.logger.info("{} stopped", new Object[]{this.getClass().getSimpleName()});
    }
}

