/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.rhttp.loadtest;

import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.mortbay.jetty.rhttp.gateway.GatewayServer;
import org.mortbay.jetty.rhttp.gateway.StandardTargetIdRetriever;
import org.mortbay.jetty.rhttp.gateway.TargetIdRetriever;

public class Server {
    public static void main(String[] args) throws Exception {
        int port = 8080;
        if (args.length > 0) {
            port = Integer.parseInt(args[0]);
        }
        GatewayServer server = new GatewayServer();
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setLowResourceMaxIdleTime(connector.getMaxIdleTime());
        connector.setPort(port);
        server.addConnector((Connector)connector);
        server.setTargetIdRetriever((TargetIdRetriever)new StandardTargetIdRetriever());
        server.start();
        server.getServer().dumpStdErr();
        Runtime.getRuntime().addShutdownHook(new Shutdown(server));
    }

    private static class Shutdown
    extends Thread {
        private final GatewayServer server;

        public Shutdown(GatewayServer server) {
            this.server = server;
        }

        public void run() {
            try {
                this.server.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

