/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.rhttp.loadtest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.client.Address;
import org.eclipse.jetty.client.ContentExchange;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.mortbay.jetty.rhttp.client.JettyClient;
import org.mortbay.jetty.rhttp.client.RHTTPClient;
import org.mortbay.jetty.rhttp.client.RHTTPListener;
import org.mortbay.jetty.rhttp.client.RHTTPRequest;
import org.mortbay.jetty.rhttp.client.RHTTPResponse;

public class Loader {
    private final List<RHTTPClient> clients = new ArrayList<RHTTPClient>();
    private final AtomicLong start = new AtomicLong();
    private final AtomicLong end = new AtomicLong();
    private final AtomicLong responses = new AtomicLong();
    private final AtomicLong failures = new AtomicLong();
    private final AtomicLong minLatency = new AtomicLong();
    private final AtomicLong maxLatency = new AtomicLong();
    private final AtomicLong totLatency = new AtomicLong();
    private final ConcurrentMap<Long, AtomicLong> latencies = new ConcurrentHashMap<Long, AtomicLong>();
    private final String nodeName;

    public static void main(String[] args) throws Exception {
        String nodeName = "";
        if (args.length > 0) {
            nodeName = args[0];
        }
        Loader loader = new Loader(nodeName);
        loader.run();
    }

    public Loader(String nodeName) {
        this.nodeName = nodeName;
    }

    private void run() throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.setMaxConnectionsPerAddress(40000);
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMaxThreads(500);
        threadPool.setDaemon(true);
        httpClient.setThreadPool((ThreadPool)threadPool);
        httpClient.setIdleTimeout(5000L);
        httpClient.start();
        Random random = new Random();
        BufferedReader console = new BufferedReader(new InputStreamReader(System.in));
        System.err.print("server [localhost]: ");
        String value = console.readLine().trim();
        if (value.length() == 0) {
            value = "localhost";
        }
        String host = value;
        System.err.print("port [8080]: ");
        value = console.readLine().trim();
        if (value.length() == 0) {
            value = "8080";
        }
        int port = Integer.parseInt(value);
        System.err.print("context []: ");
        value = console.readLine().trim();
        if (value.length() == 0) {
            value = "";
        }
        String context = value;
        System.err.print("external path [/]: ");
        value = console.readLine().trim();
        if (value.length() == 0) {
            value = "/";
        }
        String externalPath = value;
        System.err.print("gateway path [/__gateway]: ");
        value = console.readLine().trim();
        if (value.length() == 0) {
            value = "/__gateway";
        }
        String gatewayPath = value;
        int clients = 100;
        int batchCount = 1000;
        int batchSize = 5;
        long batchPause = 5L;
        int requestSize = 50;
        while (true) {
            RHTTPClient client;
            System.err.println("-----");
            System.err.print("clients [" + clients + "]: ");
            value = console.readLine();
            if (value == null) break;
            if ((value = value.trim()).length() == 0) {
                value = "" + clients;
            }
            clients = Integer.parseInt(value);
            System.err.println("Waiting for clients to be ready...");
            Address gatewayAddress = new Address(host, port);
            String gatewayURI = context + gatewayPath;
            int currentClients = this.clients.size();
            if (currentClients < clients) {
                for (int i = 0; i < clients - currentClients; ++i) {
                    client = new JettyClient(httpClient, gatewayAddress, gatewayURI, this.nodeName + (currentClients + i));
                    client.addListener((RHTTPListener)new EchoListener(client));
                    client.connect();
                    this.clients.add(client);
                    if (i % 10 != 0) continue;
                    Thread.sleep(100L);
                }
            } else if (currentClients > clients) {
                for (int i = 0; i < currentClients - clients; ++i) {
                    client = this.clients.remove(currentClients - i - 1);
                    client.disconnect();
                }
            }
            System.err.println("Clients ready");
            currentClients = this.clients.size();
            if (currentClients <= 0) continue;
            System.err.print("batch count [" + batchCount + "]: ");
            value = console.readLine().trim();
            if (value.length() == 0) {
                value = "" + batchCount;
            }
            batchCount = Integer.parseInt(value);
            System.err.print("batch size [" + batchSize + "]: ");
            value = console.readLine().trim();
            if (value.length() == 0) {
                value = "" + batchSize;
            }
            batchSize = Integer.parseInt(value);
            System.err.print("batch pause [" + batchPause + "]: ");
            value = console.readLine().trim();
            if (value.length() == 0) {
                value = "" + batchPause;
            }
            batchPause = Long.parseLong(value);
            System.err.print("request size [" + requestSize + "]: ");
            value = console.readLine().trim();
            if (value.length() == 0) {
                value = "" + requestSize;
            }
            requestSize = Integer.parseInt(value);
            String requestBody = "";
            for (int i = 0; i < requestSize; ++i) {
                requestBody = requestBody + "x";
            }
            String externalURL = "http://" + host + ":" + port + context + externalPath;
            if (!externalURL.endsWith("/")) {
                externalURL = externalURL + "/";
            }
            this.reset();
            long start = System.nanoTime();
            long expected = 0L;
            for (int i = 0; i < batchCount; ++i) {
                for (int j = 0; j < batchSize; ++j) {
                    int clientIndex = random.nextInt(this.clients.size());
                    RHTTPClient client2 = this.clients.get(clientIndex);
                    String targetId = client2.getTargetId();
                    String url = externalURL + targetId;
                    ExternalExchange exchange = new ExternalExchange();
                    exchange.setMethod("GET");
                    exchange.setURL(url);
                    exchange.setRequestContent((Buffer)new ByteArrayBuffer(requestBody, "UTF-8"));
                    exchange.send(httpClient);
                    ++expected;
                }
                if (batchPause <= 0L) continue;
                Thread.sleep(batchPause);
            }
            long end = System.nanoTime();
            long elapsedNanos = end - start;
            if (elapsedNanos > 0L) {
                System.err.print("Messages - Elapsed | Rate = ");
                System.err.print(TimeUnit.NANOSECONDS.toMillis(elapsedNanos));
                System.err.print(" ms | ");
                System.err.print(expected * 1000L * 1000L * 1000L / elapsedNanos);
                System.err.println(" requests/s ");
            }
            this.waitForResponses(expected);
            this.printReport(expected);
        }
    }

    private void reset() {
        this.start.set(0L);
        this.end.set(0L);
        this.responses.set(0L);
        this.failures.set(0L);
        this.minLatency.set(Long.MAX_VALUE);
        this.maxLatency.set(0L);
        this.totLatency.set(0L);
    }

    private void updateLatencies(long start, long end) {
        long latency = end - start;
        long oldMinLatency = this.minLatency.get();
        while (latency < oldMinLatency && !this.minLatency.compareAndSet(oldMinLatency, latency)) {
            oldMinLatency = this.minLatency.get();
        }
        long oldMaxLatency = this.maxLatency.get();
        while (latency > oldMaxLatency && !this.maxLatency.compareAndSet(oldMaxLatency, latency)) {
            oldMaxLatency = this.maxLatency.get();
        }
        this.totLatency.addAndGet(latency);
        this.latencies.putIfAbsent(latency, new AtomicLong(0L));
        ((AtomicLong)this.latencies.get(latency)).incrementAndGet();
    }

    private boolean waitForResponses(long expected) throws InterruptedException {
        int maxRetries;
        long arrived = this.responses.get() + this.failures.get();
        long lastArrived = 0L;
        int retries = maxRetries = 20;
        while (arrived < expected) {
            System.err.println("Waiting for responses to arrive " + arrived + "/" + expected);
            Thread.sleep(500L);
            if (lastArrived == arrived) {
                if (--retries == 0) {
                    break;
                }
            } else {
                lastArrived = arrived;
                retries = maxRetries;
            }
            arrived = this.responses.get() + this.failures.get();
        }
        if (arrived < expected) {
            System.err.println("Interrupting wait for responses " + arrived + "/" + expected);
            return false;
        }
        System.err.println("All responses arrived " + arrived + "/" + expected);
        return true;
    }

    public void printReport(long expectedCount) {
        long responseCount = this.responses.get() + this.failures.get();
        System.err.print("Messages - Success/Failures/Expected = ");
        System.err.print(this.responses.get());
        System.err.print("/");
        System.err.print(this.failures.get());
        System.err.print("/");
        System.err.println(expectedCount);
        long elapsedNanos = this.end.get() - this.start.get();
        if (elapsedNanos > 0L) {
            System.err.print("Messages - Elapsed | Rate = ");
            System.err.print(TimeUnit.NANOSECONDS.toMillis(elapsedNanos));
            System.err.print(" ms | ");
            System.err.print(responseCount * 1000L * 1000L * 1000L / elapsedNanos);
            System.err.println(" responses/s ");
        }
        if (this.latencies.size() > 1) {
            long maxLatencyBucketFrequency = 0L;
            long[] latencyBucketFrequencies = new long[20];
            long latencyRange = this.maxLatency.get() - this.minLatency.get();
            Iterator entries = this.latencies.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                long latency = (Long)entry.getKey();
                Long bucketIndex = (latency - this.minLatency.get()) * (long)latencyBucketFrequencies.length / latencyRange;
                int index = bucketIndex.intValue() == latencyBucketFrequencies.length ? latencyBucketFrequencies.length - 1 : bucketIndex.intValue();
                long value = ((AtomicLong)entry.getValue()).get();
                int n = index;
                latencyBucketFrequencies[n] = latencyBucketFrequencies[n] + value;
                if (latencyBucketFrequencies[index] > maxLatencyBucketFrequency) {
                    maxLatencyBucketFrequency = latencyBucketFrequencies[index];
                }
                entries.remove();
            }
            System.err.println("Messages - Latency Distribution Curve (X axis: Frequency, Y axis: Latency):");
            for (int i = 0; i < latencyBucketFrequencies.length; ++i) {
                int j;
                long latencyBucketFrequency = latencyBucketFrequencies[i];
                int value = Math.round((float)latencyBucketFrequency * (float)latencyBucketFrequencies.length / (float)maxLatencyBucketFrequency);
                if (value == latencyBucketFrequencies.length) {
                    --value;
                }
                for (j = 0; j < value; ++j) {
                    System.err.print(" ");
                }
                System.err.print("@");
                for (j = value + 1; j < latencyBucketFrequencies.length; ++j) {
                    System.err.print(" ");
                }
                System.err.print("  _  ");
                System.err.print(TimeUnit.NANOSECONDS.toMillis(latencyRange * (long)(i + 1) / (long)latencyBucketFrequencies.length + this.minLatency.get()));
                System.err.println(" ms (" + latencyBucketFrequency + ")");
            }
        }
        System.err.print("Messages - Latency Min/Ave/Max = ");
        System.err.print(TimeUnit.NANOSECONDS.toMillis(this.minLatency.get()) + "/");
        System.err.print(responseCount == 0L ? "-/" : TimeUnit.NANOSECONDS.toMillis(this.totLatency.get() / responseCount) + "/");
        System.err.println(TimeUnit.NANOSECONDS.toMillis(this.maxLatency.get()) + " ms");
    }

    private static class EchoListener
    implements RHTTPListener {
        private final RHTTPClient client;

        public EchoListener(RHTTPClient client) {
            this.client = client;
        }

        public void onRequest(RHTTPRequest request) throws Exception {
            RHTTPResponse response = new RHTTPResponse(request.getId(), 200, "OK", new HashMap(), request.getBody());
            this.client.deliver(response);
        }
    }

    private class ExternalExchange
    extends ContentExchange {
        private volatile long sendTime;

        private ExternalExchange() {
            super(true);
        }

        private void send(HttpClient httpClient) throws IOException {
            this.sendTime = System.nanoTime();
            httpClient.send((HttpExchange)this);
        }

        protected void onResponseComplete() throws IOException {
            if (this.getResponseStatus() == 200) {
                Loader.this.responses.incrementAndGet();
            } else {
                Loader.this.failures.incrementAndGet();
            }
            long arrivalTime = System.nanoTime();
            if (Loader.this.start.get() == 0L) {
                Loader.this.start.set(arrivalTime);
            }
            Loader.this.end.set(arrivalTime);
            Loader.this.updateLatencies(this.sendTime, arrivalTime);
        }

        protected void onException(Throwable x) {
            Loader.this.failures.incrementAndGet();
        }
    }
}

