/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.rhttp.gateway;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.mortbay.jetty.rhttp.client.RHTTPRequest;
import org.mortbay.jetty.rhttp.client.RHTTPResponse;
import org.mortbay.jetty.rhttp.gateway.ClientDelegate;
import org.mortbay.jetty.rhttp.gateway.ExternalRequest;
import org.mortbay.jetty.rhttp.gateway.Gateway;
import org.mortbay.jetty.rhttp.gateway.StandardTargetIdRetriever;
import org.mortbay.jetty.rhttp.gateway.TargetIdRetriever;
import org.mortbay.jetty.rhttp.gateway.Utils;

public class ConnectorServlet
extends HttpServlet {
    private final Logger logger = Log.getLogger((String)((Object)((Object)this)).getClass().toString());
    private final TargetIdRetriever targetIdRetriever = new StandardTargetIdRetriever();
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private final ConcurrentMap<String, Future<?>> expirations = new ConcurrentHashMap();
    private final Gateway gateway;
    private long clientTimeout = 15000L;

    public ConnectorServlet(Gateway gateway) {
        this.gateway = gateway;
    }

    public void init() throws ServletException {
        String t = this.getInitParameter("clientTimeout");
        if (t != null && !"".equals(t)) {
            this.clientTimeout = Long.parseLong(t);
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String targetId = this.targetIdRetriever.retrieveTargetId(request);
        String uri = request.getRequestURI();
        String path = uri.substring(request.getServletPath().length());
        String[] segments = path.split("/");
        if (segments.length < 3) {
            throw new ServletException("Invalid request to " + ((Object)((Object)this)).getClass().getSimpleName() + ": " + uri);
        }
        String action = segments[2];
        if ("handshake".equals(action)) {
            this.serviceHandshake(targetId, request, response);
        } else if ("connect".equals(action)) {
            this.serviceConnect(targetId, request, response);
        } else if ("deliver".equals(action)) {
            this.serviceDeliver(targetId, request, response);
        } else if ("disconnect".equals(action)) {
            this.serviceDisconnect(targetId, request, response);
        } else {
            throw new ServletException("Invalid request to " + ((Object)((Object)this)).getClass().getSimpleName() + ": " + uri);
        }
    }

    private void serviceHandshake(String targetId, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        ClientDelegate client = this.gateway.getClientDelegate(targetId);
        if (client != null) {
            throw new IOException("Client with targetId " + targetId + " is already connected");
        }
        client = this.gateway.newClientDelegate(targetId);
        ClientDelegate existing = this.gateway.addClientDelegate(targetId, client);
        if (existing != null) {
            throw new IOException("Client with targetId " + targetId + " is already connected");
        }
        this.flush(client, httpRequest, httpResponse);
    }

    private void flush(ClientDelegate client, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        List<RHTTPRequest> requests = client.process(httpRequest);
        if (requests != null) {
            if (!client.isClosed()) {
                this.schedule(client);
            }
            ServletOutputStream output = httpResponse.getOutputStream();
            for (RHTTPRequest request : requests) {
                output.write(request.getFrameBytes());
            }
            output.flush();
            this.logger.debug("Delivered to device {} requests {} ", new Object[]{client.getTargetId(), requests});
        }
    }

    private void schedule(ClientDelegate client) {
        ScheduledFuture<?> task = this.scheduler.schedule(new ClientExpirationTask(client), this.clientTimeout, TimeUnit.MILLISECONDS);
        Future existing = this.expirations.put(client.getTargetId(), task);
        assert (existing == null);
    }

    private void unschedule(String targetId) {
        Future task = (Future)this.expirations.remove(targetId);
        if (task != null) {
            task.cancel(false);
        }
    }

    private void serviceConnect(String targetId, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        this.unschedule(targetId);
        ClientDelegate client = this.gateway.getClientDelegate(targetId);
        if (client == null) {
            httpResponse.sendError(401);
            return;
        }
        this.flush(client, httpRequest, httpResponse);
        if (client.isClosed()) {
            this.gateway.removeClientDelegate(targetId);
        }
    }

    private void expireConnect(ClientDelegate client, long time) {
        String targetId = client.getTargetId();
        this.logger.info("Client with targetId {} missing, last seen {} ms ago, closing it", new Object[]{targetId, System.currentTimeMillis() - time});
        client.close();
        this.unschedule(targetId);
        this.gateway.removeClientDelegate(targetId);
    }

    private void serviceDeliver(String targetId, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException, IOException {
        if (this.gateway.getClientDelegate(targetId) == null) {
            httpResponse.sendError(401);
            return;
        }
        byte[] body = Utils.read((InputStream)httpRequest.getInputStream());
        RHTTPResponse response = RHTTPResponse.fromFrameBytes((byte[])body);
        ExternalRequest externalRequest = this.gateway.removeExternalRequest(response.getId());
        if (externalRequest != null) {
            externalRequest.respond(response);
            this.logger.debug("Deliver request from device {}, gateway request {}, response {}", new Object[]{targetId, externalRequest, response});
        } else {
            this.logger.debug("Deliver request from device {}, missing gateway request, response {}", new Object[]{targetId, response});
        }
    }

    private void serviceDisconnect(String targetId, HttpServletRequest request, HttpServletResponse response) {
        ClientDelegate client = this.gateway.getClientDelegate(targetId);
        if (client != null) {
            client.close();
        }
    }

    private class ClientExpirationTask
    implements Runnable {
        private final long time = System.currentTimeMillis();
        private final ClientDelegate client;

        public ClientExpirationTask(ClientDelegate client) {
            this.client = client;
        }

        public void run() {
            ConnectorServlet.this.expireConnect(this.client, this.time);
        }
    }
}

