/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.rhttp.connector;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.jetty.io.ByteArrayEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.BlockingHttpConnection;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.mortbay.jetty.rhttp.client.RHTTPClient;
import org.mortbay.jetty.rhttp.client.RHTTPListener;
import org.mortbay.jetty.rhttp.client.RHTTPRequest;
import org.mortbay.jetty.rhttp.client.RHTTPResponse;

public class ReverseHTTPConnector
extends AbstractConnector
implements RHTTPListener {
    private final BlockingQueue<RHTTPRequest> requests = new LinkedBlockingQueue<RHTTPRequest>();
    private final RHTTPClient client;

    public ReverseHTTPConnector(RHTTPClient client) {
        this.client = client;
        super.setHost(client.getHost());
        super.setPort(client.getPort());
    }

    public void setHost(String host) {
        throw new UnsupportedOperationException();
    }

    public void setPort(int port) {
        throw new UnsupportedOperationException();
    }

    protected void doStart() throws Exception {
        if (this.client instanceof LifeCycle) {
            ((LifeCycle)this.client).start();
        }
        super.doStart();
        this.client.connect();
    }

    protected void doStop() throws Exception {
        this.client.disconnect();
        super.doStop();
        if (this.client instanceof LifeCycle) {
            ((LifeCycle)this.client).stop();
        }
    }

    public void open() {
        this.client.addListener((RHTTPListener)this);
    }

    public void close() {
        this.client.removeListener((RHTTPListener)this);
    }

    public int getLocalPort() {
        return -1;
    }

    public Object getConnection() {
        return this;
    }

    protected void accept(int acceptorId) throws IOException, InterruptedException {
        RHTTPRequest request = this.requests.take();
        IncomingRequest incomingRequest = new IncomingRequest(request);
        this.getThreadPool().dispatch((Runnable)incomingRequest);
    }

    public void persist(EndPoint endpoint) throws IOException {
    }

    public void onRequest(RHTTPRequest request) throws Exception {
        this.requests.add(request);
    }

    private class IncomingRequest
    implements Runnable {
        private final RHTTPRequest request;

        private IncomingRequest(RHTTPRequest request) {
            this.request = request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            byte[] requestBytes = this.request.getRequestBytes();
            ByteArrayEndPoint endPoint = new ByteArrayEndPoint(requestBytes, 1024);
            endPoint.setGrowOutput(true);
            BlockingHttpConnection connection = new BlockingHttpConnection((Connector)ReverseHTTPConnector.this, (EndPoint)endPoint, ReverseHTTPConnector.this.getServer());
            ReverseHTTPConnector.this.connectionOpened((Connection)connection);
            try {
                while (endPoint.getIn().length() > 0) {
                    connection.handle();
                }
                byte[] responseBytes = endPoint.getOut().asArray();
                RHTTPResponse response = RHTTPResponse.fromResponseBytes((int)this.request.getId(), (byte[])responseBytes);
                ReverseHTTPConnector.this.client.deliver(response);
            }
            catch (Exception x) {
                Log.debug((Throwable)x);
            }
            finally {
                ReverseHTTPConnector.this.connectionClosed((Connection)connection);
            }
        }
    }
}

