/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plugin.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mortbay.jetty.plugin.util.PluginLog;

public class Scanner
extends Thread {
    private int scanInterval;
    private List roots;
    private Map scanInfo = Collections.EMPTY_MAP;
    private List listeners;

    public Scanner() {
        this.setDaemon(true);
    }

    public List getRoots() {
        return this.roots;
    }

    public void setRoots(List roots) {
        this.roots = roots;
        this.scanInfo = this.scan();
    }

    public int getScanInterval() {
        return this.scanInterval;
    }

    public void setScanInterval(int scanInterval) {
        this.scanInterval = scanInterval;
    }

    public List getListeners() {
        return this.listeners;
    }

    public void setListeners(List listeners) {
        this.listeners = listeners;
    }

    public void run() {
        long sleepMillis = (long)this.getScanInterval() * 1000L;
        boolean running = true;
        while (running) {
            try {
                Thread.sleep(sleepMillis);
                Map latestScanInfo = this.scan();
                List filesWithDifferences = this.getDifferences(latestScanInfo, this.scanInfo);
                if (!filesWithDifferences.isEmpty() && this.getListeners() != null && !this.getListeners().isEmpty()) {
                    try {
                        PluginLog.getLog().info((CharSequence)"Calling scanner listeners ...");
                        for (int i = 0; i < this.getListeners().size(); ++i) {
                            ((Listener)this.getListeners().get(i)).changesDetected(this, filesWithDifferences);
                        }
                        PluginLog.getLog().info((CharSequence)"Listeners completed.");
                    }
                    catch (Exception e) {
                        PluginLog.getLog().warn((CharSequence)"Error doing stop/start", (Throwable)e);
                    }
                }
                this.scanInfo = latestScanInfo;
            }
            catch (InterruptedException e) {
                running = false;
            }
        }
    }

    private Map scan() {
        PluginLog.getLog().info((CharSequence)"Scanning ...");
        List roots = this.getRoots();
        if (roots == null || roots.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap scanInfoMap = new HashMap();
        Iterator<Object> itor = roots.iterator();
        while (itor.hasNext()) {
            File f = (File)itor.next();
            this.scan(f, scanInfoMap);
        }
        if (PluginLog.getLog().isDebugEnabled()) {
            itor = this.scanInfo.entrySet().iterator();
            while (itor.hasNext()) {
                Map.Entry e = (Map.Entry)itor.next();
                PluginLog.getLog().debug((CharSequence)("Scanned " + e.getKey() + " : " + e.getValue()));
            }
        }
        PluginLog.getLog().info((CharSequence)("Scan complete at " + new Date().toString()));
        return scanInfoMap;
    }

    private void scan(File f, Map scanInfoMap) {
        try {
            if (f.isFile()) {
                String name = f.getCanonicalPath();
                long lastModified = f.lastModified();
                scanInfoMap.put(name, new Long(lastModified));
            } else if (f.isDirectory()) {
                File[] files = f.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    this.scan(files[i], scanInfoMap);
                }
            } else {
                PluginLog.getLog().error((CharSequence)("Skipping file of unacceptable type: " + f.getName()));
            }
        }
        catch (IOException e) {
            PluginLog.getLog().error((CharSequence)"Error scanning watched files", (Throwable)e);
        }
    }

    private List getDifferences(Map newScan, Map oldScan) {
        ArrayList fileNames = new ArrayList();
        HashSet oldScanKeys = new HashSet(oldScan.keySet());
        Iterator itor = newScan.entrySet().iterator();
        while (itor.hasNext()) {
            Map.Entry entry = itor.next();
            if (!oldScanKeys.contains(entry.getKey())) {
                fileNames.add(entry.getKey());
                continue;
            }
            if (!oldScan.get(entry.getKey()).equals(entry.getValue())) {
                fileNames.add(entry.getKey());
                oldScanKeys.remove(entry.getKey());
                continue;
            }
            oldScanKeys.remove(entry.getKey());
        }
        if (!oldScanKeys.isEmpty()) {
            fileNames.addAll(oldScanKeys);
        }
        return fileNames;
    }

    public static interface Listener {
        public void changesDetected(Scanner var1, List var2);
    }
}

