/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListELResolver
extends ELResolver {
    private final boolean readOnly;
    private static final Class UNMODIFIABLE = Collections.unmodifiableList(new ArrayList()).getClass();

    public ListELResolver() {
        this.readOnly = true;
    }

    public ListELResolver(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base instanceof List) {
            context.setPropertyResolved(true);
            List list = (List)base;
            int idx = ListELResolver.coerce(property);
            if (idx < 0 || idx >= list.size()) {
                return null;
            }
            return list.get(idx);
        }
        return null;
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base instanceof List) {
            context.setPropertyResolved(true);
            List list = (List)base;
            int idx = ListELResolver.coerce(property);
            if (idx < 0 || idx >= list.size()) {
                return null;
            }
            Object obj = list.get(idx);
            return obj != null ? obj.getClass() : null;
        }
        return null;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base instanceof List) {
            context.setPropertyResolved(true);
            List list = (List)base;
            if (this.readOnly) {
                throw new PropertyNotWritableException(ListELResolver.message(context, "resolverNotWriteable", new Object[]{base.getClass().getName()}));
            }
            int idx = ListELResolver.coerce(property);
            try {
                list.set(idx, value);
            }
            catch (UnsupportedOperationException e) {
                throw new PropertyNotWritableException(e);
            }
            catch (IndexOutOfBoundsException e) {
                throw new PropertyNotFoundException(e);
            }
        }
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base instanceof List) {
            context.setPropertyResolved(true);
            List list = (List)base;
            int idx = ListELResolver.coerce(property);
            if (idx < 0 || idx >= list.size()) {
                throw new PropertyNotFoundException(new ArrayIndexOutOfBoundsException(idx).getMessage());
            }
            return this.readOnly || UNMODIFIABLE.equals(list.getClass());
        }
        return this.readOnly;
    }

    @Override
    public Iterator getFeatureDescriptors(ELContext context, Object base) {
        if (base instanceof List) {
            FeatureDescriptor[] descs = new FeatureDescriptor[((List)base).size()];
            for (int i = 0; i < descs.length; ++i) {
                descs[i] = new FeatureDescriptor();
                descs[i].setDisplayName("[" + i + "]");
                descs[i].setExpert(false);
                descs[i].setHidden(false);
                descs[i].setName("" + i);
                descs[i].setPreferred(true);
                descs[i].setValue("resolvableAtDesignTime", Boolean.FALSE);
                descs[i].setValue("type", Integer.class);
            }
            return Arrays.asList(descs).iterator();
        }
        return null;
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base != null && base instanceof List) {
            return Integer.class;
        }
        return null;
    }

    private static final int coerce(Object property) {
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof Character) {
            return ((Character)property).charValue();
        }
        if (property instanceof Boolean) {
            return (Boolean)property != false ? 1 : 0;
        }
        throw new IllegalArgumentException(property != null ? property.toString() : "null");
    }
}

